/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : WTXCommsSystemInterface.h
//
// Date             : 10 February 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.2 $
//
// Description      : WTXCommsSystemInterface.h contains the 
//                    definition of the CWTXCommsSystemInterface 
//                    class.  This class is derived from 
//                    CFSISuiteCommsSystemInterface instead of 
//                    CCommsSystemInterface because 
//                    CFSISuiteCommsSystemInterface already implements 
//                    the LoadVariables code needed for WTX...  This 
//                    class is meant to be used on for initial testing 
//                    and demos of IOS to VxWorks simulation 
//                    communications.  The USE_WTX switch, when set, 
//                    will set all of the necessary symbols and add the 
//                    wtx library(ies) for linkage.  No mention of the 
//                    WTX library should exist any where else except 
//                    for at the initialization of the m_mapCommsSystem 
//                    data structure.  
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : CVariant, CFSISuiteCommsSystemInterface, 
//                    CCommsSystemInterface, CCriticalSection, map,
//                    iterator, CVariableData.  
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        If USE_WTX is set, then the WTX libraries are 
//                        needed.  Of course, the licenses should also be paid.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        Microsoft Visual C++ pragma used to localize the 
//                        WTX symbols.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3
//                                          Microsoft Windows NT 5.0
//
//                    Compiler(s) - Visual C++ 5.0 with VisC++ service pack 3
//                                  Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: WTXCommsSystemInterface.h $
// Revision 1.2  2000/03/06 16:06:45  billyb
// Changed function signature to eliminate warnings.
// Revision 1.1  1999/08/24 18:25:03  billyb
// Initial Revision
//
#if !defined(_WTXCOMMSSYSTEMINTERFACE_H_)
#define _WTXCOMMSSYSTEMINTERFACE_H_

#include "FSISuiteCommsSystemInterface.h"

//#define  USE_WTX

#ifdef USE_WTX
#pragma comment(lib, "C:\\Tornado\\host\\x86-win32\\lib\\wtxapidll-d.lib ")
#define  CPU   82
#include "wtx.h"
#endif

#undef   OK
#define  OKAY  0

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CWTXCommsSystemInterface : public CFSISuiteCommsSystemInterface  
{
private:
#ifdef USE_WTX
    static  HWTX                                           m_hWtx;
#endif

protected:
    static UINT                   ThreadFunc(LPVOID lParam);

public:
	CWTXCommsSystemInterface();
	virtual ~CWTXCommsSystemInterface();

    static CCommsSystemInterface* CreateComms();

    static void ReadData();

    virtual void WriteData(CVariant* pVariant, CVariableData* pVarData);
    virtual void Start();
    virtual void Stop();
};

#endif // !defined(_WTXCOMMSSYSTEMINTERFACE_H_)
