/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : MessageLoggingSystemInterface.h
//
// Date             : 25 August 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.5 $
//
// Description      : MessageLoggingSystemInterface.h contains the 
//                    definition of the CMessageLoggingSystemInterface class.  
//                    This class is used about the same way as the comms 
//                    system interface classes in that each of the classes has 
//                    data either from variables on the host, a data 
//                    file, or local variables or from a logs.  Both 
//                    types of classes also manage the actions that can 
//                    access this data and then distribute the data to 
//                    the graphical elements.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : CMessageLogAction, _FSI_STL::string, 
//                    _FSI_STL::map, _FSI_STL::list, CAction, CIOAction.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: MessageLoggingSystemInterface.h $                                                                   //
// Revision 1.5  2000/03/31 22:36:07  billyb                                                                   //
// Added data structure to tell which logs have changed.                                                                   //
// Added UpdateComms method.                                                                   //
// Revision 1.4  2000/03/06 16:08:05  billyb                                                                   //
// Changed function signatures to eliminate warnings.                                                                   //
// Revision 1.3  2000/01/21 10:09:38  billyb                                                                   //
// Added accessor to get the data structure containing all of                                                                   //
// the logs.                                                                   //
// Revision 1.2  1999/08/25 20:01:33  billyb                                                                   //
// Added comments.  Corrected problem with deleting actions from the local data structures that caused a crash.                                                                   //
/////////////////////////////////////////////////////////////////////////////
#if !defined(_MESSAGELOGGINGSYSTEMINTERFACE_H_)
#define _MESSAGELOGGINGSYSTEMINTERFACE_H_

#include <map>
#include <string>
#include <list>
#include <afxmt.h>

#include "..\core\corecommssysteminterface.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CIOAction;
class CMessageLogAction;
class CVariant;

class CMessageLoggingSystemInterface : public CCoreCommsSystemInterface
{
protected:
    FILE* fp;

    // map of log name to variant that will hold the log messages
    _FSI_STL::map<_FSI_STL::string, CVariant*>      m_mapLog2Variant;

    // map of log name to list of actions attached to that log
    _FSI_STL::map<_FSI_STL::string, _FSI_STL::list<CMessageLogAction*> >  m_mapLog2Actions;

    _FSI_STL::list<CIOAction*>                      m_listActionsToDelete;
    _FSI_STL::list<CIOAction*>                      m_listActionsToAdd;

    CCriticalSection                                m_sync;
    CCriticalSection                                m_syncDelete;
    CCriticalSection                                m_syncAdd;

    _FSI_STL::map<_FSI_STL::string, bool>           m_mapLogChanged;

public:
	CMessageLoggingSystemInterface();
	virtual ~CMessageLoggingSystemInterface();

    // Accessor
    _FSI_STL::map<_FSI_STL::string, CVariant*> Logs();

    void ToDelete(CIOAction* pCommsAction);
    void ToAdd(CIOAction* pCommsAction);

    void AddAction(CIOAction* pIOAction);
    void DeleteAction(CIOAction* pIOAction);

    void AddMessage(const _FSI_STL::string& stlStrLog, const _FSI_STL::string& stlStrMessage);

    void UpdateComms();

    virtual void Stop();
};

#endif // !defined(_MESSAGELOGGINGSYSTEMINTERFACE_H_)
