/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : MessageLogActionPage.cpp
//
// Date             : 09 February 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.4 $
//
// Description      : MessageLogActionPage.cpp contains the implementation of
//                    the CMessageLogActionPage class.  This class is used to 
//                    set the properties for a CCommsAction object.  It 
//                    is derived from Core::CIOActionPage.  This page is 
//                    displayed in the CWidgetProps dialog.  The standard 
//                    CBasePage framework methods--SetProperties and 
//                    UpdateProperties--are defined and implemented in 
//                    Core::CIOActionPage.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : Core::CIOActionPage, Core::CBasePage, _FSI_STL::string, 
//                    _FSI_STL::map, Comms::CCommsAction, 
//                    Comms::CCommsSystemInterface, Core::CVariableData.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 4
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 5.0 with VisC++ service pack 3
//                                  Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: MessageLogActionPage.cpp $
// Revision 1.4  2000/03/06 21:27:06  billyb
// latest
// Revision 1.2  2000/01/21 10:08:56  billyb
// Page will have all of the read/write attributes disabled and
// will show the different log names.
//
#include "..\core\stdafx.h"
#include "MessageLogActionPage.h"

#include "MessageLogAction.h"

#include "..\core\Widget.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
//
// CMessageLogActionPage::CMessageLogActionPage()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 09 February 1999
//
// Engineer         : Billy Baker
//
// Description      : Default constructor.  The base class constructor 
//                    is also called with the resource template 
//                    identifier for the property page.  Since all 
//                    CIOActionPage classes share the same template, 
//                    the title of the property page is changed here.
//
/////////////////////////////////////////////////////////////////////////////
CMessageLogActionPage::CMessageLogActionPage() : CIOActionPage()
{
	//{{AFX_DATA_INIT(CMessageLogActionPage)
	//}}AFX_DATA_INIT
    m_stlStrPageName = _FSI_STL::string("Message Log Action");
    m_psp.dwFlags |= PSP_USETITLE;
    m_psp.pszTitle = _T("Message Log Action");
}

/////////////////////////////////////////////////////////////////////////////
//
// CMessageLogActionPage::~CMessageLogActionPage()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 09 February 1999
//
// Engineer         : Billy Baker
//
// Description      : Default destructor.
//
/////////////////////////////////////////////////////////////////////////////
CMessageLogActionPage::~CMessageLogActionPage()
{
}

BEGIN_MESSAGE_MAP(CMessageLogActionPage, CIOActionPage)
	//{{AFX_MSG_MAP(CMessageLogActionPage)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
//
// CBasePage* CMessageLogActionPage::CreateObject()
//
// Inputs           : None.
//
// Return Values    : Address of a new instance of CMessageLogActionPage.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : CreateObject() is a common framework method that must be
//                    implemented by each CBasePage derived class.  The widget
//                    that uses this page associates the name of this page with 
//                    this static CreateObject method so that a new object can be
//                    created without linking against the library that contains
//                    this class.
//
/////////////////////////////////////////////////////////////////////////////
CBasePage* CMessageLogActionPage::CreateObject()
{
    return new CMessageLogActionPage;
}

/////////////////////////////////////////////////////////////////////////////
//
// BOOL CMessageLogActionPage::OnInitDialog()
//
// Inputs           : None.
//
// Return Values    : TRUE.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : OnInitDialog() is an override of the MFC common framework
//                    method by the same name for a CDialog derived class.  Its
//                    purpose is to fill the list of variables from the IO
//                    source datafile.  The parent class will fill the list of
//                    the parent graphical element's expected variables.
//
/////////////////////////////////////////////////////////////////////////////
BOOL CMessageLogActionPage::OnInitDialog() 
{
    CIOActionPage::OnInitDialog();

    m_ctrlVariableList.ResetContent();

    // Attempt to fill in the variables from the comms system.

    if (CMessageLogAction::m_pLogSystemInterface != NULL)
    {
        _FSI_STL::map<_FSI_STL::string, CVariant*> mapLogs;
        mapLogs = CMessageLogAction::m_pLogSystemInterface->Logs();
        _FSI_STL::map<_FSI_STL::string, CVariant*>::iterator mIt;
        mIt = mapLogs.begin();
        _FSI_STL::map<_FSI_STL::string, CVariant*>::iterator mendIt;
        mendIt = mapLogs.end();

        // Fill the combobox with the variables from the current 
        // CCommsSystemInterface derived class.
        while (mIt != mendIt)
        {
            m_ctrlVariableList.AddString(CString((*mIt).first.c_str()));
            mIt++;
        }

        m_ctrlVariableList.SelectString(-1, m_strCommVariable);
    }


    CWnd* pWnd = GetDlgItem(IDC_ARRAY_STATIC);
    if (pWnd != NULL)
    {
       pWnd->SetWindowText("Show Size");
    }

    pWnd = GetDlgItem(IDC_COMMS_READ_CHANGED);
    if (pWnd != NULL)
    {
       pWnd->EnableWindow(FALSE);
    }

    pWnd = GetDlgItem(IDC_COMMS_READ_ONCE);
    if (pWnd != NULL)
    {
       pWnd->EnableWindow(FALSE);
    }

    pWnd = GetDlgItem(IDC_COMMS_READ_ALWAYS);
    if (pWnd != NULL)
    {
       pWnd->EnableWindow(FALSE);
    }

    pWnd = GetDlgItem(IDC_COMMS_READ_NEVER);
    if (pWnd != NULL)
    {
       pWnd->EnableWindow(FALSE);
    }

    pWnd = GetDlgItem(IDC_COMMS_WRITE);
    if (pWnd != NULL)
    {
       pWnd->EnableWindow(FALSE);
    }

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

