#if !defined(_MESSAGELOGACTION_H_)
#define _MESSAGELOGACTION_H_

#include "MessageLoggingSystemInterface.h"
#include "CommsSystemInterface.h"
#include "CommsShared.h"

#include "..\core\IOAction.h"
#include "..\core\Widget.h"


#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CMessageLogAction : public CIOAction, public CWidget, public CCommsShared
{
protected:
    bool            m_bFirstDelete;
    bool            m_bInitialized;

public:
	CMessageLogAction();
	virtual ~CMessageLogAction();

    // Common methods for creating a CWidget derived class.
    virtual void Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                            const long int lId, bool bEditMode);
    virtual void ResetProperties();
    static CWidget* CreateObject();

    virtual void OnLoad();
	virtual void OnUpdate();

    // Accessors
    CMessageLoggingSystemInterface*     MessageLoggingSystemInterface();

    // Mutators
    void MessageLoggingSystemInterface(const CMessageLoggingSystemInterface* pMLSI);

    virtual void Deleting(bool bDeleting);
};

#endif // !defined(_MESSAGELOGACTION_H_)
