#include "..\core\stdafx.h"
#include "MessageLogAction.h"

#include "MessageLogActionPage.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

/////////////////////////////////////////////////////////////////////////////
//
// CMessageLogAction::CMessageLogAction
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : Default constructor.  Sets the name of the widget.
//                    Adds the CMessageLogActionPage to the list of widget
//                    property pages.
/////////////////////////////////////////////////////////////////////////////
CMessageLogAction::CMessageLogAction()
{
    m_stlStrWidgetName = _FSI_STL::string("Message_Log_Action");

    m_listWidgetPropPages.push_back(CMessageLogActionPage::CreateObject);

    m_bFirstDelete = true;
    m_bInitialized = false;
}

/////////////////////////////////////////////////////////////////////////////
//
// CMessageLogAction::~CMessageLogAction
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : Default destructor.  If a CCommsSystemInterface derived
//                    class has been instaniated, then an attempt is made to
//                    remove this instance of CMessageLogAction from the list of
//                    CMessageLogAction instances managed by the 
//                    CCommsSystemInterface derived class.
//
/////////////////////////////////////////////////////////////////////////////
CMessageLogAction::~CMessageLogAction()
{
}

/////////////////////////////////////////////////////////////////////////////
//
// void CMessageLogAction::Initialize()
//
// Inputs           : CXMLWidget*& rpXMLWidget - pointer to return a new 
//                                               instance of a CXMLWidget.
//                    CWnd* pWnd - the parent of this widget.
//                    const long lId - the control ID.
//                    bool bEditMode - whether this widget is being created 
//                                     in the editor or the runtime.
//
// Return Values    : None.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : Initialize() is a common framework method that must be
//                    implemented by each CWidget derived class.  Besides 
//                    standard initialization code for a CAction and CWidget
//                    derived class, the CCommsSystemInterface derived class
//                    is started if it has not already been started. 
//
/////////////////////////////////////////////////////////////////////////////
void CMessageLogAction::Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                                const long lId, bool bEditMode)
{
    // Call the base class.
    CWidget::Initialize(rpXMLWidget,pWnd, lId, bEditMode);

    // Set the action and widget pointers.
    m_pAction = this;
    m_pWidget = (CWidget*)this;

    if (rpXMLWidget != NULL)
    {
        m_pIOActionXMLWidget = m_pXMLWidget;
        ResetProperties();
    }

    m_bInitialized = true;

    OnLoad();
}

/////////////////////////////////////////////////////////////////////////////
//
// CWidget* CMessageLogAction::CreateObject()
//
// Inputs           : None.
//
// Return Values    : Address of a new instance of CMessageLogAction.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : CreateObject() is a common framework method that must be
//                    implemented by each CWidget derived class.  The main
//                    application associates the name of this widget with this
//                    static CreateObject method so that a new object can be
//                    created without linking against the library that contains
//                    this class.
//
/////////////////////////////////////////////////////////////////////////////
CWidget* CMessageLogAction::CreateObject()
{
    return new CMessageLogAction();
}

/////////////////////////////////////////////////////////////////////////////
//
// void CMessageLogAction::ResetProperties()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : ResetProperties() is a common framework method that 
//                    should be implemented by each CWidget derived class.  
//                    ResetProperties is called when a new instance is created
//                    as well as when the widget props dialog is used to change
//                    properties. 
//
/////////////////////////////////////////////////////////////////////////////
void CMessageLogAction::ResetProperties()
{
    CWidget::ResetProperties();
    CIOAction::ResetProperties();

    // If we're not editing and the comms system has been created,
    // add this commsaction to the comms system.
    if (m_bEditing == false && m_pLogSystemInterface != NULL)
    {
        m_pLogSystemInterface->ToAdd(this);
    }
}

void CMessageLogAction::OnLoad()
{
    OnUpdate();
}

/////////////////////////////////////////////////////////////////////////////
//
// void CMessageLogAction::OnUpdate()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : OnUpdate() is a common framework method for CAction
//                    derived classes.  Its purpose is to send a new value
//                    to its parent graphical widget.  OnUpdate should 
//                    generally be called by some other class than the parent 
//                    graphical element.
//
/////////////////////////////////////////////////////////////////////////////
void CMessageLogAction::OnUpdate()
{
    // Make sure there is a Variant will a value to send to the parent
    // graphical widget.
    if (m_bDeleting == true)
    {
        return;
    }

    if (m_pVariant == NULL)
    {
        return;
    }

    if (CWidget::IsValidAddress(m_pParentWidget) != VALID)
    {
        return;
    }

    CString strElementVar = CString(m_stlStrElementVar.c_str());

    // Send the new value to the parent graphical widget.
    // m_bUseRange will tell the parent whether to use the m_pVariant
    // value of the data for colors and text.
    _FSI_STL::deque<VariantListData>   *pList;
    pList   =  m_pVariant->DataList();
    CVariant   var;

    if (pList)
    {
        _FSI_STL::deque<VariantListData>::reverse_iterator   reverseIt;
        reverseIt  =  pList->rbegin();

        CString    message = "";

        CVariant   tmpVar;
        int        count =  0;

        if (!pList->empty())
        {
            while (reverseIt != pList->rend()   && count < m_lElement)
            {
                tmpVar.Value((*reverseIt).s_pcValue, VAR_STRING, (*reverseIt).s_unLength);
                if (count  >  0)
                   message = "\n" + message;
                message =  ((_FSI_STL::string)tmpVar).c_str()   +  message;
                reverseIt++;
                count++;
            }
        }

        var.Value(_FSI_STL::string((LPCSTR)message));
    }

    m_ChangeValue.Variant(&var);

    m_ChangeValue.UseRange(m_bUseRange);

    m_pParentWidget->ChangeValue(strElementVar, &m_ChangeValue);

    if (m_pCommsSystemInterface != NULL)
    {
        m_pCommsSystemInterface->ToRefresh(m_pParentWidget);
    }
}

void CMessageLogAction::Deleting(bool bDeleting)
{
    if (m_pLogSystemInterface != NULL && 
        m_bFirstDelete == true        &&
        m_bInitialized == true        &&
        bDeleting      == true)
    {
        CWidget::Deleting(false);
        m_pLogSystemInterface->ToDelete(this);

        m_bFirstDelete = false;
    }
    else
    {
        // Don't need to delete from LogSystem since
        // it could not have been added if it was NULL.
        CWidget::Deleting(bDeleting);
    }
}


CMessageLoggingSystemInterface* CMessageLogAction::MessageLoggingSystemInterface()
{
    return m_pLogSystemInterface;
}

void CMessageLogAction::MessageLoggingSystemInterface(const CMessageLoggingSystemInterface* pLCSI)
{
    m_pLogSystemInterface = (CMessageLoggingSystemInterface*)pLCSI;
}
