/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : LocalCommsSystemInterface.h
//
// Date             : 02 April 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.3 $
//
// Description      : LocalCommsSystemInterface.h contains the 
//                    definition of the CLocalCommsSystemInterface 
//                    class.  This class is derived from 
//                    CCoreCommsSystemInterface but shares many 
//                    similarities with CCommsSystemInterface.  The 
//                    difference being that a number of data structures 
//                    in CLocalCommsSystemInterface are not static 
//                    where they are in CCommsSystemInterface.  They 
//                    are not static here because a timer is not used 
//                    to perform LocalComms updates.  Rather, when a 
//                    value is changed, it is immediately sent to all 
//                    of the CLocalCommsActions that are watching that 
//                    variable.  All of the LocalComms variables are 
//                    also persistent in that they are not added and 
//                    deleted as the page changes.  Initial values are su
//                    pported.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : Core::CCoreCommsSystemInterface, _FSI_STL::map, 
//                    _FSI_STL::string, Core::CIOAction, 
//                    Core::CVariableData, Core::CRange, Core::CVariant.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3
//                                          Microsoft Windows NT 5.0
//
//                    Compiler(s) - Visual C++ 5.0 with VisC++ service pack 3
//                                  Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: LocalCommsSystemInterface.h $
// Revision 1.3  2000/03/06 16:10:52  billyb
// Changed function signatures to eliminate warnings.
// Revision 1.2  1999/09/24 17:23:52  billyb
// Changed m_mapVarName2Variant to support screen
// dependent variables.  Added constant for a screen
// independent variable.  Changed signature of WriteData
// to include a long for which screen dependent or the
// independent variable to use.
//
#if !defined(_LOCALCOMMSSYSTEMINTERFACE_H_)
#define _LOCALCOMMSSYSTEMINTERFACE_H_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "..\core\corecommssysteminterface.h"
#include "..\core\variabledata.h"
#include "..\core\Range.h"

class CLocalCommsAction;
class CWidget;

#include <afxmt.h>

static const long int INDEPENDENT_VARIABLE = -1000;

class CLocalCommsAction;
class CCommsShared;

class CLocalCommsSystemInterface : public CCoreCommsSystemInterface  
{
protected:
    // The data structure that maps the variable to an instance of
    // CVariant.  A CVariant for PITCH would be shared by all comms
    // actions above in the list for PITCH.
    _FSI_STL::map<_FSI_STL::string, _FSI_STL::map<long, CVariant*> >      m_mapVarName2Variant;

    // The data structure that maps the variable to a list of
    // all comms actions that want the value for the variable.
    // The map simply keeps track of the alias to list relationship.
    // The comms action pointers should not be deleted in the comms
    // system interface.
    _FSI_STL::map<_FSI_STL::string, _FSI_STL::list<CLocalCommsAction*> >  m_mapVarName2Comms;

    // The data structure that maps the variable alias to a list of
    // CRanges.  All actions referencing the same CVariant will also
    // reference the same list in this data structure.
    _FSI_STL::map<_FSI_STL::string, _FSI_STL::list<CRange*> >        m_mapVarName2Ranges;

    CCriticalSection                              m_sync;

public:
	CLocalCommsSystemInterface();
	virtual ~CLocalCommsSystemInterface();

    virtual void AddComms(CIOAction* pIOAction);
    virtual void DeleteComms(CIOAction* pIOAction);
    
    virtual void LoadVariables(const _FSI_STL::string& rstlStrVariablesFile);
    virtual void WriteData(CVariant* pVariant, CVariableData* pVarData, long hParent);
    virtual void Start() { m_bStarted = true; };
    virtual void Stop();

    // Map of the name of a variable alias to a structure of data that
    // goes along with the alias--ID, real variable name, type, etc.  See
    // the LoadVariables method of the specific comms system interface derived
    // class for the exact data.
    _FSI_STL::map<_FSI_STL::string,  CVariableData*>        m_mapVarName2Data;

    friend class CLocalCommsAction;

    friend class CCommsShared;
};

#endif // !defined(_LOCALCOMMSSYSTEMINTERFACE_H_)
