/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : LocalCommsSystemInterface.cpp
//
// Date             : 02 April 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.8 $
//
// Description      : LocalCommsSystemInterface.cpp contains the 
//                    implementation of the CLocalCommsSystemInterface 
//                    class.  This class is derived from 
//                    CCoreCommsSystemInterface but shares many 
//                    similarities with CCommsSystemInterface.  The 
//                    difference being that a number of data structures 
//                    in CLocalCommsSystemInterface are not static 
//                    where they are in CCommsSystemInterface.  They 
//                    are not static here because a timer is not used 
//                    to perform LocalComms updates.  Rather, when a 
//                    value is changed, it is immediately sent to all 
//                    of the CLocalCommsActions that are watching that 
//                    variable.  All of the LocalComms variables are 
//                    also persistent in that they are not added and 
//                    deleted as the page changes.  Initial values are su
//                    pported.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : Core::CCoreCommsSystemInterface, _FSI_STL::map, 
//                    _FSI_STL::string, Core::CIOAction, 
//                    Core::CVariableData, Core::CRange, Core::CVariant.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3
//                                          Microsoft Windows NT 5.0
//
//                    Compiler(s) - Visual C++ 5.0 with VisC++ service pack 3
//                                  Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: LocalCommsSystemInterface.cpp $
// Revision 1.8  2000/05/03 21:09:20  billyb
// New storage method for screen dependent variables.
// Decreased number of messages to messge log.
// Revision 1.7  2000/03/06 16:11:42  billyb
// Changed function signatures to eliminate warnings.
// Added const to references to eliminate warnings.
// Revision 1.6  2000/01/20 08:20:18  billyb
// Changed screen dependent from view based to frame based
// to avoid problems with double buffered views.
// Revision 1.5  1999/11/04 19:57:41  billyb
// Changed for loop to while and added variable for map end()
// call to decrease calls to end().  Delete XMLPage after variables
// are read instead of waiting until instance is destroyed.
// Revision 1.4  1999/10/14 19:19:48  billyb
// Changed call to ParseFile to use class member for 
// IXMLDocument.
// Revision 1.2  1999/09/02 17:12:28  billyb
// Initialized the initial data format member of a local comms
// action when it is added in AddComms.  
// Initialized the initial data format meber of CVariableData
// when the variables file is read.
//
#include "..\core\stdafx.h"
#include "LocalCommsSystemInterface.h"
#include "LocalCommsAction.h"
#include "MessageLogAction.h"

#include "..\core\XMLParser5.h"

#include <algorithm>

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

CLocalCommsSystemInterface::CLocalCommsSystemInterface()
{
    m_pXMLVariablesPage = NULL;
}

CLocalCommsSystemInterface::~CLocalCommsSystemInterface()
{
    if (m_pXMLVariablesPage != NULL)
    {
        delete m_pXMLVariablesPage;
    }
}

void CLocalCommsSystemInterface::AddComms(CIOAction* pIOAction)
{
    m_sync.Lock();
    CLocalCommsAction* pCommsAction = (CLocalCommsAction*)pIOAction;
    // Make sure that we got a CCommsAction pointer.
    if (pCommsAction == NULL)
    {
       m_sync.Unlock();
       return;
    }

    const _FSI_STL::string& stlStrName = pCommsAction->Variable();

    // Make sure pCommsAction's variables are in the list of varaibles.
    if (m_mapVarName2Data.find(stlStrName) != m_mapVarName2Data.end())
    {
        if (m_mapVarName2Ranges.find(stlStrName) != m_mapVarName2Ranges.end())
        {
            _FSI_STL::list<CRange*>::iterator lIt = 
                                        m_mapVarName2Ranges[stlStrName].begin();
            _FSI_STL::list<CRange*>::iterator lendIt = 
                                        m_mapVarName2Ranges[stlStrName].end();

            while (lIt != lendIt)
            {
                pCommsAction->AddRange((*lIt));
                lIt++;
            }
        }

        pCommsAction->InitialDataFormat(m_mapVarName2Data[stlStrName]->InitialDataFormat());

        // If the variable for pCommsAction has been added once, then
        // assign the same memory for the variant that stores the value
        // for Variable to pCommsAction.  Else, add pCommsAction to the 
        // map of variable IDs to CCommsAction pointers.  Then create a 
        // new variant for Variable and assign it to pCommsAction's variant
        // pointer.
        if (m_mapVarName2Variant.find(stlStrName) != m_mapVarName2Variant.end())
        {
            CVariant* pVariant = NULL;

            if (m_mapVarName2Data[stlStrName]->ScreenDependent() == true)
            {
                HWND hWnd = pCommsAction->ParentWidget()->MainFrameHwnd();
                if ((m_mapVarName2Variant[stlStrName]).find((long)hWnd) !=
                        (m_mapVarName2Variant[stlStrName]).end())
                {
                    // A screen dependent variant has been created based on
                    // the CCommsAction's parent widget's framework parent.
                    // Assign the variant to pVariant so that it may be passed
                    // to the CCommsAction.
                    pVariant = (m_mapVarName2Variant[stlStrName])[(long)hWnd];
                }
                else
                {
                    // A screen dependent variant has not been created.  Create a
                    // new CVariant.  Setup the variant based on the data in
                    // m_mapVarName2Data.  Add the variant to the map of varname
                    // 2 variant.
                    // Assign the variant to pVariant so that it may be passed
                    // to the CCommsAction.
                    pVariant = new CVariant();

                    if (pVariant != NULL)
                    {
                        pVariant->Value(m_mapVarName2Data[stlStrName]->InitialValue());
                        pVariant->ChangeType(m_mapVarName2Data[stlStrName]->Type());
                    }

                    (m_mapVarName2Variant[stlStrName])[(long)hWnd] = pVariant;
                }
            }
            else
            {
                // get the variant for this variable and give a pointer
                // to it to the passed comms action.  The INDEPENDENT_VARIABLE
                // HWND would generally be invalid but it is used as the value 
                // for getting a screen independent variable.
                pVariant = (m_mapVarName2Variant[stlStrName])[INDEPENDENT_VARIABLE];
            }


            pCommsAction->Variant(pVariant);
            m_mapVarName2Comms[stlStrName].push_back(pCommsAction);
        }
    }

    m_sync.Unlock();
}

void CLocalCommsSystemInterface::DeleteComms(CIOAction* pIOAction)
{
    m_sync.Lock();
    // Make sure that we got a CCommsAction pointer.
    CLocalCommsAction* pCommsAction = (CLocalCommsAction*)pIOAction;
    if (pCommsAction == NULL)
    {
        m_sync.Unlock();
        return;
    }

    const _FSI_STL::string& stlStrName = pCommsAction->Variable();

    // Make sure pCommsAction's variable is in the list of varaibles.
    if (m_mapVarName2Data.find(stlStrName) != m_mapVarName2Data.end())
    {
        // Valid variable.  Get ID for variable.
        CVariableData* pVarData = m_mapVarName2Data[stlStrName];

        if (pVarData == NULL)
        {
            m_sync.Unlock();
            return;
        }

        if (m_mapVarName2Comms.find(stlStrName) != m_mapVarName2Comms.end())
        {
            // VarName is in the map of VarName2Comms which means that it has 
            // commsactions attached to it.
            // Remove the comms object from the list of comms objects.
            _FSI_STL::map<_FSI_STL::string, _FSI_STL::list<CLocalCommsAction*> >::iterator mIt;
            mIt = m_mapVarName2Comms.find(stlStrName);

            // find the passed commsaction in the list for ulID
            _FSI_STL::list<CLocalCommsAction*>::iterator lIt = 
                                               _FSI_STL::find((*mIt).second.begin(),
                                                         (*mIt).second.end(), 
                                                         pCommsAction);
            if (lIt != (*mIt).second.end())
            {
                // pCommsAction is in the list.
                if ((*mIt).second.size() == 1)
                {
                    // Remove the commsaction from the list for ulID.
                    (*mIt).second.erase(lIt);

                    // Remove ulID.
                    m_mapVarName2Comms.erase(mIt);
                }
                else
                {
                    // Remove the commsaction from the list for ulID..
                    (*mIt).second.erase(lIt);
                }
            }
        }
    }
    m_sync.Unlock();
}

void CLocalCommsSystemInterface::LoadVariables(const _FSI_STL::string& rstlStrVariablesFile)
{
    CVariant variant;

    if (rstlStrVariablesFile != _FSI_STL::string(""))
    {
        CXMLParser5 xmlParser(rstlStrVariablesFile.c_str());

        // Clean up old file.
        if (m_pXMLVariablesPage != NULL)
        {
            delete m_pXMLVariablesPage;
            m_pXMLVariablesPage = NULL;
        }

        // Parse the new file.
        m_pXMLVariablesPage = new CXMLPage;
        xmlParser.ParseFile(m_pXMLVariablesPage, m_pXMLDoc);

        ELEMENT_LIST::iterator elIt = NULL;
        STRING2STRING_MAP::iterator s2sIt;
        CVariableData* pVarData ;
        while (m_pXMLVariablesPage->FindElement(elIt, 
                                             _FSI_STL::string("COMMS_VARIABLE")) == true)
        {
            // Get the alias name.
            _FSI_STL::string stlStrVarName((*elIt)->ElementValue().c_str());
            pVarData = new CVariableData;

            if (pVarData != NULL)
            {
                pVarData->SimVarName((*elIt)->ElementValue());
            }

            // Get the ID.
            if ((*elIt)->FindAttribute(s2sIt,_FSI_STL::string("ID")) == true)
            {
                if (pVarData != NULL)
                {
                    pVarData->ID(atoi((*s2sIt).second.c_str()));
                }
            }


            // Get the type.
            if ((*elIt)->FindAttribute(s2sIt,_FSI_STL::string("TYPE")) == true)
            {
                if (pVarData != NULL)
                {
                    pVarData->Type(atoi((*s2sIt).second.c_str()));
                }
            }

            // Get the format.
            if ((*elIt)->FindAttribute(s2sIt,_FSI_STL::string("FORMAT")) == true)
            {
                if (pVarData != NULL)
                {
                    pVarData->InitialDataFormat(atoi((*s2sIt).second.c_str()));
                }
            }

            // Get any initial value.
            if ((*elIt)->FindAttribute(s2sIt,_FSI_STL::string("INITIAL")) == true)
            {
                if (pVarData != NULL)
                {
                    pVarData->InitialValue((*s2sIt).second);
                }
            }

            // Get whether the variable is screen dependent.
            if ((*elIt)->FindAttribute(s2sIt,_FSI_STL::string("DEPENDENT")) == true)
            {
                if (pVarData != NULL)
                {
                    CString str((*s2sIt).second.c_str());
                    str.MakeUpper();
                    if (str == "YES")
                    {
                        pVarData->ScreenDependent(true);
                    }
                    else
                    {
                        pVarData->ScreenDependent(false);
                    }
                }
            }

            // If one already exists, delete and replace.
            if (m_mapVarName2Data.find(stlStrVarName) != m_mapVarName2Data.end())
            {
                delete (*(m_mapVarName2Data.find(stlStrVarName))).second;
            }

            m_mapVarName2Data[stlStrVarName] = pVarData;

            if (m_mapVarName2Variant.find(stlStrVarName) != 
                                                    m_mapVarName2Variant.end())
            {
                if (pVarData->ScreenDependent() == false)
                {
                    delete (m_mapVarName2Variant[stlStrVarName])[INDEPENDENT_VARIABLE];
                }
            }

            if (pVarData->ScreenDependent() == false)
            {
                (m_mapVarName2Variant[stlStrVarName])[INDEPENDENT_VARIABLE] = new CVariant();

                // Set the variant to any initial value from the data file.
                (m_mapVarName2Variant[stlStrVarName])[INDEPENDENT_VARIABLE]->Value(pVarData->InitialValue());
                (m_mapVarName2Variant[stlStrVarName])[INDEPENDENT_VARIABLE]->ChangeType(pVarData->Type());
            }
            else
            {
                // Just add the variable name with no variant.  AddComms will
                // take care of adding the variant(s).
                m_mapVarName2Variant[stlStrVarName];
            }


            // Move to next element.
            elIt++;
        }

        elIt = NULL;
        while (m_pXMLVariablesPage->FindElement(elIt, _FSI_STL::string("RANGE")) == true)
        {

            // Get the log message.
            _FSI_STL::string stlStrLogMessage((*elIt)->ElementValue().c_str());

            // Get the alias name.
            if ((*elIt)->FindAttribute(s2sIt,_FSI_STL::string("VAR")) == true)
            {
                if (m_mapVarName2Data.find((*s2sIt).second) != m_mapVarName2Data.end())
                {
                    CVariableData* pVarData = m_mapVarName2Data[(*s2sIt).second];
                    CRange* pRange = new CRange;
                    if (pRange != NULL)
                    {
                        pRange->LogMessage(stlStrLogMessage);
                    }
                    m_mapVarName2Ranges[(*s2sIt).second].push_back(pRange);

                    if ((*elIt)->FindAttribute(s2sIt,_FSI_STL::string("ID")) == true)
                    {
                        if (pRange != NULL)
                        {
                            pRange->ID(atoi((*s2sIt).second.c_str()));
                        }
                    }

                    if ((*elIt)->FindAttribute(s2sIt,_FSI_STL::string("LOW")) == true)
                    {
                        if (pRange != NULL)
                        {
                            CVariant var;
                            var.Value((*s2sIt).second);
                            var.ChangeType(pVarData->Type());
                            pRange->Lower(var);
                        }
                    }

                    if ((*elIt)->FindAttribute(s2sIt,_FSI_STL::string("HIGH")) == true)
                    {
                        if (pRange != NULL)
                        {
                            CVariant var;
                            var.Value((*s2sIt).second);
                            var.ChangeType(pVarData->Type());
                            pRange->Upper(var);
                        }
                    }

                    if ((*elIt)->FindAttribute(s2sIt,_FSI_STL::string("BACK_TRUE")) == true)
                    {
                        if (pRange != NULL)
                        {
                            CColor color(CString((*s2sIt).second.c_str()));
                            pRange->BackgroundTrue(color);
                        }
                    }

                    if ((*elIt)->FindAttribute(s2sIt,_FSI_STL::string("FORE_TRUE")) == true)
                    {
                        if (pRange != NULL)
                        {
                            CColor color(CString((*s2sIt).second.c_str()));
                            pRange->ForegroundTrue(color);
                        }
                    }

                    if ((*elIt)->FindAttribute(s2sIt,_FSI_STL::string("TEXT_TRUE")) == true)
                    {
                        if (pRange != NULL)
                        {
                            pRange->TextTrue((*s2sIt).second);
                        }
                    }

                    if ((*elIt)->FindAttribute(s2sIt,_FSI_STL::string("BACK_FALSE")) == true)
                    {
                        if (pRange != NULL)
                        {
                            CColor color(CString((*s2sIt).second.c_str()));
                            pRange->BackgroundFalse(color);
                        }
                    }

                    if ((*elIt)->FindAttribute(s2sIt,_FSI_STL::string("FORE_FALSE")) == true)
                    {
                        if (pRange != NULL)
                        {
                            CColor color(CString((*s2sIt).second.c_str()));
                            pRange->ForegroundFalse(color);
                        }
                    }

                    if ((*elIt)->FindAttribute(s2sIt,_FSI_STL::string("TEXT_FALSE")) == true)
                    {
                        if (pRange != NULL)
                        {
                            pRange->TextFalse((*s2sIt).second);
                        }
                    }

                    if ((*elIt)->FindAttribute(s2sIt,_FSI_STL::string("LOWER_COND")) == true)
                    {
                        if (pRange != NULL)
                        {
                            pRange->LowerConditional((unsigned char)atoi((*s2sIt).second.c_str()));
                        }
                    }

                    if ((*elIt)->FindAttribute(s2sIt,_FSI_STL::string("UPPER_COND")) == true)
                    {
                        if (pRange != NULL)
                        {
                            pRange->UpperConditional((unsigned char)atoi((*s2sIt).second.c_str()));
                        }
                    }
                }
            }


            // Move to next element.
            elIt++;
        }

        if (m_pXMLVariablesPage != NULL)
        {
            delete m_pXMLVariablesPage;
            m_pXMLVariablesPage = NULL;
        }
    }
}

void CLocalCommsSystemInterface::Stop()
{
    m_bStarted = false;

    m_sync.Lock();
    // Free memory for the CVariableData instances that
    // were created in a call to LoadVariables.
    _FSI_STL::map<_FSI_STL::string, CVariableData*>::iterator mIt;
    mIt = m_mapVarName2Data.begin();
    _FSI_STL::map<_FSI_STL::string, CVariableData*>::iterator mendIt;
    mendIt = m_mapVarName2Data.end();
    while (mIt != mendIt)
    {
        delete (*mIt).second;
        mIt++;
    }
    m_mapVarName2Data.clear();

    // Free memory for the CVariant instances that
    // were created in a call to AddComms.
    _FSI_STL::map<_FSI_STL::string, _FSI_STL::map<long, CVariant*> >::iterator mvIt;
    _FSI_STL::map<_FSI_STL::string, _FSI_STL::map<long, CVariant*> >::iterator mvendIt;
    _FSI_STL::map<long, CVariant*>::iterator mHCvIt     = NULL;
    _FSI_STL::map<long, CVariant*>::iterator mHCvendIt  = NULL;
    mvIt    = m_mapVarName2Variant.begin();
    mvendIt = m_mapVarName2Variant.end();
    while (mvIt != mvendIt)
    {
        mHCvIt      = (*mvIt).second.begin();
        mHCvendIt   = (*mvIt).second.end();

        while (mHCvIt != mHCvendIt)
        {
            delete (*mHCvIt).second;
            mHCvIt++;
        }

        (*mvIt).second.clear();

        mvIt++;
    }
    m_mapVarName2Variant.clear();

    _FSI_STL::map<_FSI_STL::string, _FSI_STL::list<CLocalCommsAction*> >::iterator caIt;
    caIt = m_mapVarName2Comms.begin();
    _FSI_STL::map<_FSI_STL::string, _FSI_STL::list<CLocalCommsAction*> >::iterator caendIt;
    caendIt = m_mapVarName2Comms.end();
    while (caIt != caendIt)
    {
        (*caIt).second.clear();

         caIt++;
    }
    m_mapVarName2Comms.clear();

    _FSI_STL::map<_FSI_STL::string, _FSI_STL::list<CRange*> >::iterator mrIt = 
                                                   m_mapVarName2Ranges.begin();
    _FSI_STL::map<_FSI_STL::string, _FSI_STL::list<CRange*> >::iterator mrendIt = 
                                                   m_mapVarName2Ranges.end();
    _FSI_STL::list<CRange*>::iterator lrIt = NULL;
    _FSI_STL::list<CRange*>::iterator lrendIt = NULL;
    while (mrIt != mrendIt)
    {
        lrIt    = (*mrIt).second.begin();
        lrendIt = (*mrIt).second.end();
        while (lrIt != lrendIt)
        {
            delete (*lrIt);

            lrIt++;
        }
        (*mrIt).second.clear();

        mrIt++;
    }
    m_mapVarName2Ranges.clear();

    m_sync.Unlock();
}

void CLocalCommsSystemInterface::WriteData(CVariant* pVariant, 
                                           CVariableData* pVarData,
                                           long hParent)
{
    if (pVariant == NULL || pVarData == NULL)
    {
        return;
    }

    m_sync.Lock();
    _FSI_STL::string stlStrVariableName = pVarData->SimVarName();
    _FSI_STL::map<_FSI_STL::string, _FSI_STL::map<long, CVariant*> >::iterator mIt;
    _FSI_STL::list<CRange*>::iterator lrIt      = NULL;
    _FSI_STL::list<CRange*>::iterator lrendIt   = NULL;

    mIt = m_mapVarName2Variant.find(stlStrVariableName);

    // Find the variable in the map of variable names to 
    // variants.
    if (mIt != m_mapVarName2Variant.end())
    {
        if ((*mIt).second.find(hParent) != (*mIt).second.end())
        {
            if (((*mIt).second)[hParent] != NULL)
            {
                // Update the value.
                ((*mIt).second)[hParent]->Value((_FSI_STL::string)*pVariant); 
                ((*mIt).second)[hParent]->ChangeType(pVarData->Type());

                // Run through any attached ranges to see if the current value is
                // in one of the ranges.
                if (((*mIt).second)[hParent]->WasChanged() == true)
                {
                    if (m_mapVarName2Ranges.find((*mIt).first) != m_mapVarName2Ranges.end())
                    {
                        lrIt    = m_mapVarName2Ranges[(*mIt).first].begin();
                        lrendIt =  m_mapVarName2Ranges[(*mIt).first].end();

                        bool bDone = false;

                        while (lrIt != lrendIt && bDone == false) 
                        {
                            // Evaluate the range for the new value.
                            if ((*lrIt)->Evaluate(*((*mIt).second)[hParent]) == true &&
                                (*lrIt)->NewValidRange() == true)
                            {
                                if (CMessageLogAction::m_pLogSystemInterface != NULL)
                                {
                                    CString strMessage((*lrIt)->LogMessage().c_str());
                                    strMessage.MakeUpper();

                                    if (strMessage != "" && strMessage != "BLANK")
                                    {
                                        CMessageLogAction::m_pLogSystemInterface->AddMessage(_FSI_STL::string("Simulation"), 
                                                                                             (*lrIt)->LogMessage());
                                    }
                                }
                                bDone = true;
                            }
 
                            lrIt++;
                        }
                    }
                }

                _FSI_STL::map<_FSI_STL::string, _FSI_STL::list<CLocalCommsAction*> >::iterator mlIt;

                // Run through the list of all CLocalCommsActions attached
                // to the variant that was changed and tell them to update
                // themselves.
                mlIt = m_mapVarName2Comms.find(stlStrVariableName);
                if (mlIt != m_mapVarName2Comms.end())
                {
                    _FSI_STL::list<CLocalCommsAction*>::iterator lIt = 
                                                            (*mlIt).second.begin();
                    _FSI_STL::list<CLocalCommsAction*>::iterator lendIt = 
                                                            (*mlIt).second.end();
                    if (pVarData->ScreenDependent() == true)
                    {
                        // Screen dependent.  Only update the commsactions that
                        // are for the variant that go with hParent.
                        HWND hWnd = NULL;
                        while (lIt != lendIt)
                        {
                            hWnd = (*lIt)->ParentWidget()->MainFrameHwnd();

                            // If the framework parent's HWND matches hParent,
                            // then update.
                            if ((long)hWnd == hParent)
                            {
                                (*lIt)->OnUpdate();
                            }

                            lIt++;
                        }
                    }
                    else
                    {
                        // Update all of the comms actions because this
                        // variabl is not screen dependent.
                        while (lIt != lendIt)
                        {
                            (*lIt)->OnUpdate();

                            lIt++;
                        }
                    }
                }
            }
        }
    }

    m_sync.Unlock();
}
