/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : LocalCommsConfigPage.cpp
//
// Date             : 09 March 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.1 $
//
// Description      : LocalCommsConfigPage.cpp contains the implementation of the 
//                    CLocalCommsConfigPage class.  CLocalCommsConfigPage is 
//                    derived from Core::CBasePage.  This is 
//                    necesary because this property page is used to 
//                    select the comms protocol and set the IO source 
//                    datafile.  If either of these changes, then the 
//                    pointer will be needed to either delete the old 
//                    CLocalCommsSystemInterface derived class and create a 
//                    new one and to read the IO source datafile. The
//                    general purpose of this class is to read and write
//                    configuration data to the registry.  This page is
//                    displayed in the COptions dialog.  The standard 
//                    CBasePage framework methods--SetProperties and 
//                    UpdateProperties--are defined and implemented in
//                    Core::CIOActionPage.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : CString, Core::CBasePage.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3
//                                          Microsoft Windows NT 5.0
//
//                    Compiler(s) - Visual C++ 5.0 with VisC++ service pack 3
//                                  Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: LocalCommsConfigPage.cpp $
// Revision 1.1  1999/08/24 18:24:57  billyb
// Initial Revision
//
#include "..\core\stdafx.h"
#include "LocalCommsConfigPage.h"
#include "LocalCommsSystemInterface.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
//
// CLocalCommsConfigPage::CLocalCommsConfigPage()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 09 February 1999
//
// Engineer         : Billy Baker
//
// Description      : Default constructor.  Calls parent's constructor 
//                    passing the resource template ID for the property 
//                    page.  Sets the non-displayed name of the 
//                    property page.
//
/////////////////////////////////////////////////////////////////////////////
CLocalCommsConfigPage::CLocalCommsConfigPage() : CBasePage(CLocalCommsConfigPage::IDD)
{
	//{{AFX_DATA_INIT(CLocalCommsConfigPage)
	m_strVariablesFile = _T("");
	//}}AFX_DATA_INIT
    m_stlStrPageName = _FSI_STL::string("Local Comms Config");
}

/////////////////////////////////////////////////////////////////////////////
//
// CLocalCommsConfigPage::~CLocalCommsConfigPage()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 09 February 1999
//
// Engineer         : Billy Baker
//
// Description      : Default destructor.
//
/////////////////////////////////////////////////////////////////////////////
CLocalCommsConfigPage::~CLocalCommsConfigPage()
{
}

void CLocalCommsConfigPage::DoDataExchange(CDataExchange* pDX)
{
	CBasePage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CLocalCommsConfigPage)
	DDX_Text(pDX, IDC_LOCAL_VARIABLESFILE, m_strVariablesFile);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CLocalCommsConfigPage, CBasePage)
	//{{AFX_MSG_MAP(CLocalCommsConfigPage)
	ON_BN_CLICKED(IDC_LOCAL_VARIABLESFILE_BUTTON, OnVariablesfileButton)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
//
// CBasePage* CLocalCommsConfigPage::CreateObject()
//
// Inputs           : None.
//
// Return Values    : Address of a new instance of CLocalCommsConfigPage
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : CreateObject() is a common framework method that must be
//                    implemented by each CBasePage derived class.  The DLL
//                    that uses this page associates the name of this page with 
//                    this static CreateObject method so that a new object can be
//                    created without linking against the library that contains
//                    this class.
//
/////////////////////////////////////////////////////////////////////////////
CBasePage* CLocalCommsConfigPage::CreateObject()
{
    return new CLocalCommsConfigPage;
}

/////////////////////////////////////////////////////////////////////////////
//
// void CLocalCommsConfigPage::SetProperties()
//
// Inputs           : None.
//
// Return Values    : void* pWidget - for COptions property pages, pWidget
//                                    is the addrss of the name of the 
//                                    component whose configuration is being
//                                    changed or checked.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : SetProperties() is a common framework method that must be
//                    implemented by each CBasePage derived class. SetProperties
//                    is called after the property page has been created but
//                    before OnInitDialog().  Its purpose is to read the 
//                    registry for configuration data.
//
/////////////////////////////////////////////////////////////////////////////
void CLocalCommsConfigPage::SetProperties(void* pWidget)
{
    CString strComponentName = CString((char *)pWidget);
    HKEY hKey;

    // Open the registry.
    RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\FSISuite\\") + strComponentName, 0, KEY_READ, &hKey);

    if (hKey != NULL)
    {
		CString strValue;
		DWORD dwType, dwCount;

        // Get the name of the IO source datafile.
		LONG lResult = RegQueryValueEx(hKey, _T("LocalVariablesFile"), 
                                       NULL, &dwType, NULL, &dwCount);
		if (lResult == ERROR_SUCCESS)
		{
			ASSERT(dwType == REG_SZ);
			lResult = RegQueryValueEx(hKey, _T("LocalVariablesFile"), NULL, &dwType,
				            (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)),
                                      &dwCount);

			strValue.ReleaseBuffer();
		}

        m_strVariablesFile = strValue;

        RegCloseKey(hKey);
    }
}

/////////////////////////////////////////////////////////////////////////////
//
// void CLocalCommsConfigPage::UpdateProperties()
//
// Inputs           : None.
//
// Return Values    : void* pWidget - for COptions property pages, pWidget
//                                    is the addrss of the name of the 
//                                    component whose configuration is being
//                                    changed or checked.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : UpdateProperties() is a common framework method that must
//                    be implemented by each CBasePage derived class. 
//                    UpdateProperties is called after the Ok or Apply button
//                    on the COptions dialog has been pressed.  Its purpose is
//                    to write the copnfiguration data to the registry.  Special
//                    code here determines if the comms protocol changed and if
//                    so creates a new comms system interface.  Also, if the
//                    IO source datafile changed, then it is reread.
//
/////////////////////////////////////////////////////////////////////////////
void CLocalCommsConfigPage::UpdateProperties(void* pWidget)
{
    if (GetSafeHwnd() == NULL)
    {
        return;
    }

    CString strComponentName = CString((char *)pWidget);
    HKEY hKey;
    DWORD dw;

    // Open the registry.
    RegCreateKeyEx(HKEY_LOCAL_MACHINE, 
                 _T("Software\\FlightSafety\\FSISuite\\") + strComponentName, 0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, 
                 &hKey, &dw);

    if (hKey != NULL)
    {
        UpdateData(TRUE);

        // Write the path to the IO source datafile.
        RegSetValueEx(hKey, _T("LocalVariablesFile"), NULL, REG_SZ, 
                      (BYTE*)(LPCTSTR)m_strVariablesFile,
                      m_strVariablesFile.GetLength() + 1);

        RegCloseKey(hKey);
    }
}

/////////////////////////////////////////////////////////////////////////////
//
// void CLocalCommsConfigPage::OnVariablesButton()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 09 February 1999
//
// Engineer         : Billy Baker
//
// Description      : OnVariablesButton() handles clicks on the button 
//                    to browse for the name of the Variables file.  A 
//                    common file dialog is created and displayed.
//
/////////////////////////////////////////////////////////////////////////////
void CLocalCommsConfigPage::OnVariablesfileButton() 
{
    // Get all of the current data.
    UpdateData(TRUE);

    CFileDialog cfd(TRUE, "fml", m_strVariablesFile,
                    OFN_SHAREAWARE | OFN_PATHMUSTEXIST | OFN_HIDEREADONLY,
                    "Variables Description File (*.fml)|*.fml|All Files (*.*)|*.*||",
                    this);

    long int lRetVal = cfd.DoModal();

    // If ok was clicked, then update the name of the file.
    if (lRetVal == IDOK)
    {
        m_strVariablesFile = cfd.GetPathName();
        UpdateData(FALSE);
    }
	
}

/////////////////////////////////////////////////////////////////////////////
//
// BOOL CLocalCommsConfigPage::OnInitDialog()
//
// Inputs           : None.
//
// Return Values    : TRUE.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : OnInitDialog() is an override of the MFC common framework
//                    method by the same name for a CDialog derived class.  Its
//                    purpose is to fill the combobox of comms protocols with 
//                    the names of the protocols implemented in this DLL.
//
/////////////////////////////////////////////////////////////////////////////
BOOL CLocalCommsConfigPage::OnInitDialog() 
{
	CBasePage::OnInitDialog();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
