/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : LocalCommsActionPage.cpp
//
// Date             : 09 February 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.4 $
//
// Description      : LocalCommsActionPage.cpp contains the implementation of the 
//                    CLocalCommsActionPage class.  This class is used to 
//                    set the properties for a CLocalCommsAction object.  It 
//                    is derived from Core::CIOActionPage.  As with all 
//                    other CIOActionPage derived classes, a list of 
//                    variables from the IO source is shown as well as 
//                    the expected values of the parent grapical widget 
//                    so that a link can be made between what the 
//                    parent expects and what is available in the IO 
//                    source datafile.    This page is displayed in the
//                    CWidgetProps dialog.    The standard 
//                    CBasePage framework methods--SetProperties and 
//                    UpdateProperties--are defined and implemented in
//                    Core::CIOActionPage.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : CIOActionPage.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3
//                                          Microsoft Windows NT 5.0
//
//                    Compiler(s) - Visual C++ 5.0 with VisC++ service pack 3
//                                  Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: LocalCommsActionPage.cpp $
// Revision 1.4  2000/03/06 16:12:14  billyb
// Removed constructor parameter to base class.
// Revision 1.2  1999/11/04 19:56:37  billyb
// Changed for loop to while and added variable for map end()
// call to decrease calls to end().
//
#include "..\core\stdafx.h"
#include "LocalCommsActionPage.h"

#include "LocalCommsAction.h"

#include "..\core\Widget.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
//
// CLocalCommsActionPage::CLocalCommsActionPage()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 09 February 1999
//
// Engineer         : Billy Baker
//
// Description      : Default constructor.  The base class constructor 
//                    is also called with the resource template 
//                    identifier for the property page.  Since all 
//                    CIOActionPage classes share the same template, 
//                    the title of the property page is changed here.
//
/////////////////////////////////////////////////////////////////////////////
CLocalCommsActionPage::CLocalCommsActionPage() : CIOActionPage()
{
	//{{AFX_DATA_INIT(CLocalCommsActionPage)
	//}}AFX_DATA_INIT
    m_stlStrPageName = _FSI_STL::string("Local Comms Action");
    m_psp.dwFlags |= PSP_USETITLE;
    m_psp.pszTitle = _T("Local Comms Action");
}

/////////////////////////////////////////////////////////////////////////////
//
// CLocalCommsActionPage::~CLocalCommsActionPage()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 09 February 1999
//
// Engineer         : Billy Baker
//
// Description      : Default destructor.
//
/////////////////////////////////////////////////////////////////////////////
CLocalCommsActionPage::~CLocalCommsActionPage()
{
}

BEGIN_MESSAGE_MAP(CLocalCommsActionPage, CIOActionPage)
	//{{AFX_MSG_MAP(CLocalCommsActionPage)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
//
// CBasePage* CLocalCommsActionPage::CreateObject()
//
// Inputs           : None.
//
// Return Values    : Address of a new instance of CLocalCommsActionPage.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : CreateObject() is a common framework method that must be
//                    implemented by each CBasePage derived class.  The widget
//                    that uses this page associates the name of this page with 
//                    this static CreateObject method so that a new object can be
//                    created without linking against the library that contains
//                    this class.
//
/////////////////////////////////////////////////////////////////////////////
CBasePage* CLocalCommsActionPage::CreateObject()
{
    return new CLocalCommsActionPage;
}

/////////////////////////////////////////////////////////////////////////////
//
// BOOL CLocalCommsActionPage::OnInitDialog()
//
// Inputs           : None.
//
// Return Values    : TRUE.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : OnInitDialog() is an override of the MFC common framework
//                    method by the same name for a CDialog derived class.  Its
//                    purpose is to fill the list of variables from the IO
//                    source datafile.  The parent class will fill the list of
//                    the parent graphical element's expected variables.
//
/////////////////////////////////////////////////////////////////////////////
BOOL CLocalCommsActionPage::OnInitDialog() 
{
	CIOActionPage::OnInitDialog();
	
    m_ctrlVariableList.ResetContent();
    if (CLocalCommsAction::m_pLocalCommsSystemInterface != NULL)
    {
        _FSI_STL::map<_FSI_STL::string,  CVariableData*>::iterator mIt;
        mIt = CLocalCommsAction::m_pLocalCommsSystemInterface->m_mapVarName2Data.begin();
        _FSI_STL::map<_FSI_STL::string,  CVariableData*>::iterator mendIt;
        mendIt = CLocalCommsAction::m_pLocalCommsSystemInterface->m_mapVarName2Data.end();

        // Fill the combobox with the variables from the current 
        // CCommsSystemInterface derived class.
        while (mIt != mendIt) 
        {
            m_ctrlVariableList.AddString(CString((*mIt).first.c_str()));
            mIt++;
        }

        m_ctrlVariableList.SelectString(-1, m_strCommVariable);
    }

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

