/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : LocalCommsAction.h
//
// Date             : 02 April 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.3 $
//
// Description      : LocalCommsAction.h contains the definition 
//                    of the CLocalCommsAction class.  This class is 
//                    similar to the CCommsAction class.  As opposed to 
//                    calling a CCommsSystemInterface class WriteData 
//                    member, CLocalCommsAction updates the CVariant to 
//                    which this class has a pointer and then call 
//                    OnUpdate for each CLocalCommsAction also attached 
//                    to the same pointer. 
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : None.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3
//                                          Microsoft Windows NT 5.0
//
//                    Compiler(s) - Visual C++ 5.0 with VisC++ service pack 3
//                                  Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: LocalCommsAction.h $
// Revision 1.3  1999/11/15 18:34:31  billyb
// Deleted two unused methods.
// Revision 1.2  1999/10/20 18:35:29  billyb
// Exported class form DLL.  Added string for error message
// used in MsgThread method.  Changed OnLButtonUp to
// return an enum.
//
#if !defined(_LOCALCOMMSACTION_H_)
#define _LOCALCOMMSACTION_H_

#ifdef COMMS
#define COMMSAPI __declspec( dllexport )
#else
#define COMMSAPI __declspec( dllimport )
#endif

#include "..\core\ioaction.h"
#include "..\core\widget.h"
#include "CommsShared.h"

class COMMSAPI CLocalCommsAction : public CIOAction, public CWidget, public CCommsShared
{
protected:
    static _FSI_STL::string  m_stlStrError;

    static UINT MsgThread(LPVOID param);

public:
	CLocalCommsAction();
	virtual ~CLocalCommsAction();

    virtual void Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                            const long int lId, bool bEditMode);
    virtual void ResetProperties();
    static CWidget* CreateObject();

	virtual void OnLoad();
    virtual void OnUpdate();
	virtual enum LButtonUpReturn OnLButtonUp();
};

#endif