/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : LocalCommsAction.cpp
//
// Date             : 02 April 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.18 $
//
// Description      : LocalCommsAction.cpp contains the implementation 
//                    of the CLocalCommsAction class.  This class is 
//                    similar to the CCommsAction class.  As opposed to 
//                    calling a CCommsSystemInterface class WriteData 
//                    member, CLocalCommsAction updates the CVariant to 
//                    which this class has a pointer and then call 
//                    OnUpdate for each CLocalCommsAction also attached 
//                    to the same pointer. 
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : None.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3
//                                          Microsoft Windows NT 5.0
//
//                    Compiler(s) - Visual C++ 5.0 with VisC++ service pack 3
//                                  Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: LocalCommsAction.cpp $
// Revision 1.18  2000/06/08 06:51:16  billyb
// Revised locking scheme.
// Revision 1.17  2000/05/03 21:14:12  billyb
// Changed code dealing with screen dependent variables.
// Revision 1.16  2000/03/31 22:35:36  billyb
// Removed help text.
// Revision 1.15  2000/03/06 16:15:52  billyb
// Added const to references to eliminate warnings.
// Corrected other warnings.
// Revision 1.14  2000/02/04 17:31:56  billyb
// Reverted to previous version.
// Revision 1.12  2000/01/20 08:19:50  billyb
// Change to pass the parent frame HWND to WriteData as
// opposed to the view HWND.  Fixes a problem with double
// buffered views.
// Revision 1.11  1999/12/31 16:43:48  billyb
// Changed default name.
// Revision 1.10  1999/11/15 18:34:29  billyb
// Deleted two unused methods.
// Revision 1.9  1999/11/10 08:09:10  billyb
// Removed continuation in help text.
// Revision 1.8  1999/11/04 19:56:21  billyb
// Changed for loop to while and added variable for map end()
// call to decrease calls to end().  Changed size() call to empty()
// since size() is a calculation and empty() is an accessor for
// a member variable.
// Revision 1.7  1999/10/21 01:39:31  billyb
// Optimized for loops in OnUpdate.
// Revision 1.6  1999/10/20 18:36:20  billyb
// Added MsgThread method to display a range check invalid
// message box in a seperate thread.  Changed OnLButtonUp
// to return an enum.  Added range checking to OnLButtonUp.
// Revision 1.5  1999/09/24 17:21:33  billyb
// Added support for screen dependent variables.
// Added conversion to OnLButtonUp so that converted
// data will be unconverted before it is sent to the host.
// Revision 1.4  1999/09/02 20:01:06  billyb
// Moved include for FormatPage.h from IOAction.h to here.
// Revision 1.3  1999/09/02 17:13:15  billyb
// Made sure the initial data format member was initialized when
// using the page editor.
// Added using the data conversion information for new data in
// OnUpdate.
// Revision 1.2  1999/08/30 22:19:45  billyb
// Added FormatPage to list of property pages for the editor.  
// Changed the precision of the variant based on any precision 
// data specific to an instance of a LocalCommsAction.
//
#include "..\core\stdafx.h"
#include "LocalCommsAction.h"

#include "LocalCommsActionPage.h"
#include "..\core\RangePage.h"
#include "..\core\FormatPage.h"

#include "..\core\DataConversion.h"

_FSI_STL::string  CLocalCommsAction::m_stlStrError;

UINT CLocalCommsAction::MsgThread(LPVOID param)
{
    ::MessageBox(NULL, 
                 _T(m_stlStrError.c_str()), 
                 _T("Invalid Range"), 
                 MB_OK | MB_ICONERROR | MB_SYSTEMMODAL);
    return 0;
}

CLocalCommsAction::CLocalCommsAction()
{
    m_stlStrWidgetName = _FSI_STL::string("Local_Comms");

    m_listWidgetPropPages.push_back(CLocalCommsActionPage::CreateObject);
    m_listWidgetPropPages.push_back(CRangePage::CreateObject);
    m_listWidgetPropPages.push_back(CFormatPage::CreateObject);
}

/////////////////////////////////////////////////////////////////////////////
//
// CLocalCommsAction::~CLocalCommsAction
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : Default destructor.  If a CCommsSystemInterface derived
//                    class has been instaniated, then an attempt is made to
//                    remove this instance of CLocalCommsAction from the list of
//                    CLocalCommsAction instances managed by the 
//                    CCommsSystemInterface derived class.
//
/////////////////////////////////////////////////////////////////////////////
CLocalCommsAction::~CLocalCommsAction()
{
    if (m_pLocalCommsSystemInterface != NULL)
    {
        m_pLocalCommsSystemInterface->DeleteComms(this);
    }
}

/////////////////////////////////////////////////////////////////////////////
//
// void CLocalCommsAction::Initialize()
//
// Inputs           : CXMLWidget*& rpXMLWidget - pointer to return a new 
//                                               instance of a CXMLWidget.
//                    CWnd* pWnd - the parent of this widget.
//                    const long lId - the control ID.
//                    bool bEditMode - whether this widget is being created 
//                                     in the editor or the runtime.
//
// Return Values    : None.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : Initialize() is a common framework method that must be
//                    implemented by each CWidget derived class.  Besides 
//                    standard initialization code for a CAction and CWidget
//                    derived class, the CCommsSystemInterface derived class
//                    is started if it has not already been started. 
//
/////////////////////////////////////////////////////////////////////////////
void CLocalCommsAction::Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                                const long lId, bool bEditMode)
{
    // Set the help text.
    if (rpXMLWidget == NULL)
    {
        m_stlStrName = "LOCAL ";
    }

    // Call the base class.
    CWidget::Initialize(rpXMLWidget,pWnd, lId, bEditMode);

    m_pAction = this;
    m_pWidget = (CWidget*)this;

    if (rpXMLWidget != NULL)
    {
        m_pIOActionXMLWidget = m_pXMLWidget;
        ResetProperties();
    }

    OnLoad();
}

/////////////////////////////////////////////////////////////////////////////
//
// CWidget* CLocalCommsAction::CreateObject()
//
// Inputs           : None.
//
// Return Values    : Address of a new instance of CLocalCommsAction.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : CreateObject() is a common framework method that must be
//                    implemented by each CWidget derived class.  The main
//                    application associates the name of this widget with this
//                    static CreateObject method so that a new object can be
//                    created without linking against the library that contains
//                    this class.
//
/////////////////////////////////////////////////////////////////////////////
CWidget* CLocalCommsAction::CreateObject()
{
    return new CLocalCommsAction();
}

/////////////////////////////////////////////////////////////////////////////
//
// void CLocalCommsAction::ResetProperties()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : ResetProperties() is a common framework method that 
//                    should be implemented by each CWidget derived class.  
//                    ResetProperties is called when a new instance is created
//                    as well as when the widget props dialog is used to change
//                    properties. 
//
/////////////////////////////////////////////////////////////////////////////
void CLocalCommsAction::ResetProperties()
{
    m_sync.Lock();
    CWidget::ResetProperties();
    CIOAction::ResetProperties();

    if (m_bEditing == false && m_pLocalCommsSystemInterface != NULL)
    {
        m_pLocalCommsSystemInterface->AddComms(this);
    }
    else if (m_bEditing == true && m_pLocalCommsSystemInterface != NULL)
    {
        const _FSI_STL::string& stlStrName = Variable();

        // Make sure pCommsAction's variables are in the list of varaibles.
        if (m_pLocalCommsSystemInterface->m_mapVarName2Data.find(stlStrName) != 
                              m_pLocalCommsSystemInterface->m_mapVarName2Data.end())
        {
            if (m_pLocalCommsSystemInterface->m_mapVarName2Ranges.find(stlStrName) != 
                            m_pLocalCommsSystemInterface->m_mapVarName2Ranges.end())
            {
                _FSI_STL::list<CRange*>::iterator lIt = 
                   m_pLocalCommsSystemInterface->m_mapVarName2Ranges[stlStrName].begin();
                _FSI_STL::list<CRange*>::iterator lendIt = 
                   m_pLocalCommsSystemInterface->m_mapVarName2Ranges[stlStrName].end();

                while (lIt != lendIt) 
                {
                    AddRange((*lIt));
                    lIt++;
                }

            }

            m_lInitialDataFormat = m_pLocalCommsSystemInterface->m_mapVarName2Data[stlStrName]->InitialDataFormat();
        }
    }

    m_sync.Unlock();
}

/////////////////////////////////////////////////////////////////////////////
//
// enum LButtonUpReturn CLocalCommsAction::OnLButtonUp()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : OnLButtonUp() is a common framework method for CAction
//                    derived classes.  Its purpose is to perform a action 
//                    based on some user interaction with the graphical 
//                    element to which the instance of this class is attached.
//                    In this case, OnLButtonUp is used to get a value from
//                    the graphical element to then write to simulation.
//
/////////////////////////////////////////////////////////////////////////////
enum LButtonUpReturn CLocalCommsAction::OnLButtonUp()
{
    if (m_bCanWrite == false)
        return LBU_CAN_NOT_WRITE;

    if (m_bDeleting == true)
    {
        // Since memory is going away, the parent is probably
        // going away as well.  Let the parent think that
        // everything went ok.  Or, no write can take place
        return LBU_OK;
    }

    if (m_pLocalCommsSystemInterface == NULL)
        return LBU_NO_COMMS;

    CVariant variant;

    m_sync.Lock();

    // Make sure this instance is attached to a graphical element.
    if (CWidget::IsValidAddress(m_pParentWidget) != VALID )
    {
        m_sync.Unlock();
        return LBU_OK;
    }

    if (m_bUseSpecificRange == true && m_pRange != NULL)
    {
        variant = m_pRange->Lower();
    }
    else
    {
        // Get the value from the parent graphical element.
        CVariant  *pVariant   =  m_pParentWidget->GetValue(CString(m_stlStrElementVar.c_str()));

        if (pVariant != NULL)
            variant = *(pVariant);
        else
        {
            m_sync.Unlock();
            return LBU_OK;
        }
    }

    // Perform range check before data conversion because the parent widget
    // will have a high and low in terms of the convert type if a conversion
    // was desired.
    if (!m_vectRanges.empty())
    {
        variant.LimitFloating(m_bLimitFloating);
        variant.Precision(m_ucPrecision);
        if (m_pParentWidget->RangeLow(m_stlStrElementVar) > variant  ||
            m_pParentWidget->RangeHigh(m_stlStrElementVar) < variant)
        {
            CString  error;
            CString  data( (char *) ((_FSI_STL::string)variant).c_str() );
            CString  low(  (char *) ((_FSI_STL::string)(m_pParentWidget->RangeLow(m_stlStrElementVar))).c_str() );
            CString  high( (char *) ((_FSI_STL::string)(m_pParentWidget->RangeHigh(m_stlStrElementVar))).c_str() );
            error.Format("Sorry, %s is not a valid entry.\nThe valid range is %s to %s", data, low, high);
            m_stlStrError  =  (LPCTSTR)error;

            AfxBeginThread(MsgThread, (LPVOID)0);

            m_sync.Unlock();
            return   LBU_NOT_IN_RANGE;
        }
    }

    HWND hWnd = m_pParentWidget->MainFrameHwnd();

    m_sync.Unlock();

    // See the parent widget is using a converted data value.  If so,
    // then convert it back to the format in which it came form the host.
    if (m_lDataFormat != m_lInitialDataFormat &&
        m_lDataFormat != Generic_No_Conversions)
    {
        variant = CDataConversion::Convert(variant, 
                                           (DATA_FORMATS)m_lDataFormat,
                                           (DATA_FORMATS)m_lInitialDataFormat);
    }

    // Write the value to widgets after changing its type to the
    // correct type in the variable data.
    if (m_pLocalCommsSystemInterface->m_mapVarName2Data.find(m_stlStrVariableToWatch) !=
        m_pLocalCommsSystemInterface->m_mapVarName2Data.end())
    {
         CVariableData* pVarData = 
                     m_pLocalCommsSystemInterface->m_mapVarName2Data[m_stlStrVariableToWatch];
         variant.ChangeType(pVarData->Type());
         if (pVarData->ScreenDependent() == false)
         {
            m_pLocalCommsSystemInterface->WriteData(&variant, pVarData, 
                                                    INDEPENDENT_VARIABLE);
         }
         else
         {
             m_pLocalCommsSystemInterface->WriteData(&variant, pVarData, (long)hWnd);
         }
    }

    return LBU_OK;
}

/////////////////////////////////////////////////////////////////////////////
//
// void CLocalCommsAction::OnUpdate()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : OnUpdate() is a common framework method for CAction
//                    derived classes.  Its purpose is to send a new value
//                    to its parent graphical widget.  OnUpdate should 
//                    generally be called by some other class than the parent 
//                    graphical element.
//
/////////////////////////////////////////////////////////////////////////////
void CLocalCommsAction::OnUpdate()
{
    // Make sure there is a Variant will a value to send to the parent
    // graphical widget.
    if (m_pVariant == NULL)
        return;

    // Depending on the read_mode--read always, read changed, read never, 
    // or read_once-- update the parent graphical widget.  Also, if a read
    // has not been performed once and the read_mode is not read never, then
    // go ahead and get an initial value. 
    if (((m_bReadOnce    == true  && m_bRead == false) ||
         (m_bReadChanged == true  && m_pVariant->WasChanged() == true) ||
         (m_bReadAlways  == true) || 
         (m_bInitialRead == true)) && 
        (m_bReadOnce == true || m_bReadChanged == true || m_bReadAlways == true))
    {
        CString strElementVar(m_stlStrElementVar.c_str());
        CVariant variant(*m_pVariant);
;

/*
        // The following code should be used if the m_lElement value
        // becomes usable with local comms variables.  As of this writing,
        // 22 Oct 2000, local comms variables did not support arrays with
        // the LENGTH attribute.  The CLocalCommsSystemInterface::LoadVariables
        // would have to parse this as well as all of the other changes needed
        // to work with individual array elements.  Right now, the only arrays
        // are VAR_STRING.
        if (m_pVariant->Length() == 1 || m_lElement == -1)
            variant = *m_pVariant;
        else
            variant = (*m_pVariant)[m_lElement];
*/

        // Run through any attached ranges to see if the current value is
        // in one of the ranges.
        int nRangeSize = m_vectRanges.size();
        if (nRangeSize > 0 && m_bUseGenericRange == true)
        {
            int nRangeStep = 0;
            bool bDone = false;
            while (nRangeStep < nRangeSize)
            {
                // Evaluate the range for the value pointed to by m_pVariant.
                if (m_vectRanges[nRangeStep]->Evaluate(*m_pVariant) == true)
                {
                    // The range evaluated to true.  Reset m_ChangeValue to 
                    // match the range that was true.
                    m_ChangeValue.Text(m_vectRanges[nRangeStep]->TextTrue());
                    m_ChangeValue.Background(m_vectRanges[nRangeStep]->BackgroundTrue());
                    m_ChangeValue.Foreground(m_vectRanges[nRangeStep]->ForegroundTrue());
                    bDone = true;
                    break;
                }

                nRangeStep++;
            }

            m_ChangeValue.TrueOrFalseValue(bDone);
        }
        else if (m_bUseSpecificRange == true && m_pRange != NULL)
        {
            if (m_pRange->Evaluate(*m_pVariant) == true)
            {
                // The range evaluated to true.  Reset m_ChangeValue to 
                // match the range that was true.
                m_ChangeValue.Text(m_pRange->TextTrue());
                m_ChangeValue.Background(m_pRange->BackgroundTrue());
                m_ChangeValue.Foreground(m_pRange->ForegroundTrue());
                m_ChangeValue.TrueOrFalseValue(true);
            }
            else
            {
                // The range evaluated to true.  Reset m_ChangeValue to 
                // match the range that was true.
                m_ChangeValue.Text(m_pRange->TextFalse());
                m_ChangeValue.Background(m_pRange->BackgroundFalse());
                m_ChangeValue.Foreground(m_pRange->ForegroundFalse());
                m_ChangeValue.TrueOrFalseValue(false);
            }
        }

        // Send the new value to the parent graphical widget.
        // m_bUseRange will tell the parent whether to use the m_pVariant
        // value of the data for colors and text.
        m_ChangeValue.UseRange(m_bUseRange);

        m_sync.Lock();

        // Make sure there is a parent graphical widget.
        if (!(CWidget::IsValidAddress(m_pParentWidget) != VALID))
        {
            if (m_lDataFormat != m_lInitialDataFormat &&
                m_lDataFormat != Generic_No_Conversions)
            {
                CVariant varConverted;

                varConverted = CDataConversion::Convert(variant, 
                                                        (DATA_FORMATS)m_lInitialDataFormat,
                                                        (DATA_FORMATS)m_lDataFormat);
                m_ChangeValue.Variant(&varConverted);

                varConverted.LimitFloating(m_bLimitFloating);
                varConverted.Precision(m_ucPrecision);

                // Put here so that varConverted will still be in scope.
                m_pParentWidget->ChangeValue(strElementVar, &m_ChangeValue);
            }
            else
            {
                m_ChangeValue.Variant(&variant);

                variant.LimitFloating(m_bLimitFloating);
                variant.Precision(m_ucPrecision);

                m_pParentWidget->ChangeValue(strElementVar, &m_ChangeValue);
            }

            if (m_pCommsSystemInterface != NULL)
                m_pCommsSystemInterface->ToRefresh(m_pParentWidget);

            // If this is a read once initializer, then mark as being read.
            if (m_bReadOnce == true)
                m_bRead = true;

            m_bInitialRead = false;
        }

        m_sync.Unlock();
    }
}

/////////////////////////////////////////////////////////////////////////////
//
// void CLocalCommsAction::OnLoad()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 16 February 1999
//
// Engineer         : Billy Baker
//
// Description      : OnLoad() is a common framework method for CAction
//                    derived classes.  Its purpose is to initialize
//                    its parent graphical widget.  
//
/////////////////////////////////////////////////////////////////////////////
void CLocalCommsAction::OnLoad()
{
    OnUpdate();
}
