#ifndef	__IOSHOSTCOMMANDS_H__
#define __IOSHOSTCOMMANDS_H__

/*
 * Limits.
 */

#define	MAX_COMMAND_DATA			12000
#define	MAX_PLOT_BUFFERS			4
#define	MAX_PLOT_DATA				50
#define	MAX_SYMBOLS					10000

/*
 * nType fields.
 *
 * Notes :
 *
 *	Variable types are specified by iosRt in the variable nType that is transmitted
 * through the IOSRT_COMMAND_SET_READ_POINTERS and IOSRT_COMMAND_SET_WRITE_POINTERS
 * commands.  The bit assignments in this variable are specified here.
 */

#define	DATA_TYPE_BITS				0x0000000f
#define	PLOT_BIT					0x00000010
#define	PLOT_BUFFER_NUMBER_LSB		5
#define	PLOT_BUFFER_NUMBER_BITS		(MAX_PLOT_BUFFERS - 1)

/*
 * Plotting.
 */

	typedef	struct
	{
		void *				pAddress;
		int					nCount;
		int					nType;
		int					nTypeDWords;
		unsigned int		uHostTick;
		int					nArray[MAX_PLOT_DATA << 1];
	}						HostPlot;

	#define	HOST_PLOT_HEADER_SIZE	(sizeof(void*) + (sizeof(int) * 3) + sizeof(unsigned int))

/*
 * Read, write pointers.
 */

	enum
	{
		IOSRT_CHAR,						/* 1 byte  */
		IOSRT_LOGICAL,					/* 4 bytes */
		IOSRT_SHORT,					/* 2 bytes */
		IOSRT_USHORT,					/* 2 bytes */
		IOSRT_INT,						/* 4 bytes */
		IOSRT_UINT,						/* 4 bytes */
		IOSRT_FLOAT,					/* 4 bytes */
		IOSRT_DOUBLE,					/* 8 bytes */
	};

	/*
	 * Structure.
	 */

	typedef	struct
	{
		int					nPointerType;
		unsigned int		pPointer;
	}						iosRtPointer;

/*
 * Command types.
 */

enum
{
	/*
	 * Host to IosRt commands.
	 */

	HOST_FIRST_COMMAND = (int)('Z' << 24) + (int)('C' << 16) + (int)('T' << 8),

	HOST_COMMAND_NULL = HOST_FIRST_COMMAND,
	HOST_COMMAND_READ_RETURN,
	HOST_COMMAND_NO_READ_POINTERS,
	HOST_COMMAND_READ_OUT_OF_RANGE,
	HOST_COMMAND_TOO_MANY_READ_POINTERS,
	HOST_COMMAND_NO_WRITE_POINTERS,
	HOST_COMMAND_WRITE_OUT_OF_RANGE,
	HOST_COMMAND_TOO_MANY_WRITE_POINTERS,
	HOST_COMMAND_PLOT,

	HOST_LAST_COMMAND = HOST_COMMAND_PLOT,

	/* 
	 * IosRt to Host commands.
	 */

	IOSRT_FIRST_COMMAND,

	IOSRT_COMMAND_NULL = IOSRT_FIRST_COMMAND,
	IOSRT_COMMAND_SET_READ_POINTERS,
	IOSRT_COMMAND_SET_WRITE_POINTERS,
	IOSRT_COMMAND_WRITE,
	IOSRT_COMMAND_READ,

	IOSRT_LAST_COMMAND = IOSRT_COMMAND_READ,
};

/*
 * Host commands.
 */

	/*
	 * HOST_COMMAND_PLOT
	 */

	typedef	struct
	{
		void *				pAddress;
		int					nCount;
		int					nType;
		int					nTypeDWords;
		unsigned int		uHostTick;
		int					nArray[MAX_PLOT_DATA << 1];
	}						PlotParams;

	#define HOST_COMMAND_PLOT_HEADER_SIZE (sizeof(void*) + (sizeof(int) * 3) + sizeof(unsigned int))

	/*
	 * HOST_COMMAND_READ_RETURN
	 */

	typedef	struct
	{
		int					nCount;
		int					nTag;
		unsigned int		dwData[MAX_COMMAND_DATA];
	}						ReadReturnParams;

	#define HOST_COMMAND_READ_RETURN_HEADER_SIZE (2 * sizeof(int))

/*
 * IosRt commands.
 */

	/*
	 * IOSRT_COMMAND_READ.
	 */

	typedef struct
	{
		int					nCount;
		unsigned int		rdData[MAX_COMMAND_DATA];
	}						ReadParams;

	#define IOSRT_COMMAND_READ_HEADER_SIZE (sizeof(int))

	/*
	 * IOSRT_COMMAND_SET_READ_POINTERS.
	 */

	typedef	struct
	{
		int					nPointers;
		int					nTag;
		iosRtPointer		pPointers[MAX_COMMAND_DATA];
	}						SetReadPointerParams;

	#define IOSRT_COMMAND_SET_READ_POINTERS_HEADER_SIZE (2 * sizeof(int))

	/*
	 * IOSRT_COMMAND_SET_WRITE_POINTERS.
	 */

	typedef struct
	{
		int					nPointers;
		iosRtPointer		pPointers[MAX_COMMAND_DATA];
	}						SetWritePointerParams;

	#define IOSRT_COMMAND_SET_WRITE_POINTERS_HEADER_SIZE (sizeof(int))

	/*
	 * IOSRT_COMMAND_WRITE
	 */

	typedef struct
	{
		int					nCount;
		unsigned int		wrData[MAX_COMMAND_DATA];
	}						WriteParams;

	#define IOSRT_COMMAND_WRITE_HEADER_SIZE (sizeof(int))

/*
 * Command buffers.
 */

	/*
	 * Host command buffer.
	 */

	typedef	struct HOSTCOMMAND
	{
		int			volatile nCommand;
		int			volatile nCommandSize;
		union
		{
					PlotParams				Plot;
					ReadReturnParams		ReadReturn;
		}			Command;
	}				HostCommand;

	#define	HOST_COMMAND_HEADER_SIZE	(sizeof(int) * 2)
	#define HOST_COMMAND_MAX_SIZE		(sizeof(HostCommand))

	/*
	 * IosRt command buffer.
	 */

	typedef	struct
	{
		int			volatile nCommand;
		int			volatile nCommandSize;
		union
		{
					ReadParams				Read;
					SetReadPointerParams	SetReadPointers;
					SetWritePointerParams	SetWritePointers;
					WriteParams				Write;
		}			Command;
	}				iosRtCommand;

	#define	IOSRT_COMMAND_HEADER_SIZE	(sizeof(int) * 2)
	#define IOSRT_COMMAND_MAX_SIZE		(sizeof(iosRtCommand))

/*
 * Symbols.
 */

	#define	MAX_SYMBOL_NAME_LENGTH	80

	/*
	 * FSI symbol types.
	 */

	enum
	{
		IOS_INTEGER,
		IOS_FLOAT,
		IOS_DOUBLE,
		IOS_LOGICAL,
		IOS_SHORT,
		IOS_CHAR,
		IOS_USHORT,
	};

	/*
	 * FSI symbol structure.
	 */

	typedef	struct
	{
		unsigned int		nNameOffset;
		unsigned int		nType;
		unsigned int		nValue;
	}						ios_symbol_entry;

	/*
	 * FSI symbol file structure.
	 */

	typedef	struct
	{
		int					nCount;
		ios_symbol_entry *	pSymbolEntries;
		char *				pSymbolNames;
	}						ios_symbols_hdr;

#endif /* __IOSHOSTCOMMANDS_H__ */
