#ifndef __IOSCOMMSSOCKET_H__
#define __IOSCOMMSSOCKET_H__

/////////////////////////////////////////////////////////////////////////////
// CIosCommsSocket class

class	CMainFrame;

#include <afxsock.h>
#include <afxmt.h>

class CIosCommsSocket : public CAsyncSocket
{
// Construction.
public:
	CIosCommsSocket();

// Attributes
public:
	BOOL				m_bAbort;
	BOOL				m_bClosed;
	BOOL				m_bConnected;
	BOOL				m_bError;
	CEvent				m_evReceive;
	CEvent				m_evSend;

// Operations
public:
	void				SocketAbort(void);
	BOOL				SocketCreate(void);
	BOOL				SocketHasError(void);
	BOOL				SocketIsAborted(void);
	BOOL				SocketIsClosed(void);
	BOOL				SocketIsConnected(void);
	BOOL				SocketRead(char * chBuffer, int nCount);
	BOOL				SocketSend(char * chBuffer, int nCount);

// Implementation
public:
	virtual				~CIosCommsSocket();
	virtual void		OnClose(int nErrorCode);
	virtual void		OnConnect(int nErrorCode);
	virtual void		OnReceive(int nErrorCode);
	virtual void		OnSend(int nErrorCode);
};

#endif // __IOSCOMMSSOCKET_H__