// iosCommsSocket.cpp : implementation file
//
// IOS Runtime Comms Socket class.
//
// Copyright (c) 1997 by ZCT Systems Group, Inc.
// All Rights Reserved.
//
// Notes :
//
//	This file contains the IOS Runtime comms Socket class.  This class is designed to
// provide the TCP/IP interface between IosRt and the host using the MFC CAsyncSocket
// class.
//

#include "..\core\stdafx.h"
#include "iosCommsSocket.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//
// CIosCommsSocket::CIosCommsSocket
// CIosCommsSocket constructor.
// Entry   : nothing
// Returns : nothing
//

CIosCommsSocket::CIosCommsSocket()
{
    WSADATA wsaData;
    WORD wVersionRequested;
    wVersionRequested = MAKEWORD( 2, 2 );
    WSAStartup(wVersionRequested, &wsaData);
	m_bAbort = m_bClosed = m_bConnected = m_bError = FALSE;
}

//
// CIosCommsSocket::CIosCommsSocket
// CIosCommsSocket destruct.
// Entry   : nothing
// Returns : nothing
//

CIosCommsSocket::~CIosCommsSocket()
{
    WSACleanup();
}

/////////////////////////////////////////////////////////////////////////////
// CIosCommsSocket message handlers

//
// CIosCommsSocket::OnClose
// Close the socket
// Entry   : error code
// Returns : nothing
//

void CIosCommsSocket::OnClose(int nErrorCode)
{
	// Attempt to close the socket.

	CAsyncSocket::OnClose(nErrorCode);

	if(nErrorCode)
	{
		// Attempt failed, send error message to CMainFrame.

		switch(nErrorCode)
		{
			case WSAENETDOWN:
//				printf("CIosCommsSocket : close error, WSAEENETDOWN");
			break;

			case WSAECONNRESET:
//				printf("CIosCommsSocket : close error, WSAECONNRESET");
			break;

			case WSAECONNABORTED:
//				printf("CIosCommsSocket : close error, WSAECONNABORTED");
			break;

			default:
//				printf("CIosCommsSocket : unknown");
			break;
		}

		// Set the error flag.

		m_bError = TRUE;
	}
	else
	{
		// Attempt succeeded.

		m_bConnected = FALSE;
		m_bClosed = TRUE;
	}
}

//
// CIosCommsSocket::OnConnect
// Called when a connection is made
// Entry   : error code
// Returns : nothing
//

void CIosCommsSocket::OnConnect(int nErrorCode)
{
	// Attempt to connect the socket.

	CAsyncSocket::OnConnect(nErrorCode);

	if(nErrorCode)
	{
		// Attempt failed, send error message to CMainFrame.
#if 0
		switch(nErrorCode)
		{
			case WSAEADDRINUSE:
				printf("CIosCommsSocket : connect error, WSAEADDRINUSE");
			break;

			case WSAEADDRNOTAVAIL:
				printf("CIosCommsSocket : connect error, WSAEADDRNOTAVAIL");
			break;

			case WSAEAFNOSUPPORT:
				printf("CIosCommsSocket : connect error, WSAEAFNOSUPPORT");
			break;

			case WSAECONNREFUSED:
				printf("CIosCommsSocket : connect error, WSAECONNREFUSED");
			break;

			case WSAEDESTADDRREQ:
				printf("CIosCommsSocket : connect error, WSAEDESTADDREQ");
			break;

			case WSAEFAULT:
				printf("CIosCommsSocket : connect error, WSAEFAULT");
			break;

			case WSAEINVAL:
				printf("CIosCommsSocket : connect error, WSAEINVAL");
			break;

			case WSAEISCONN:
				printf("CIosCommsSocket : connect error, WSAEISCONN");
			break;

			case WSAEMFILE:
				printf("CIosCommsSocket : connect error, WSAEMFILE");
			break;

			case WSAENETUNREACH:
				printf("CIosCommsSocket : connect error, WSAENETUNREACH");
			break;

			case WSAENOBUFS:
				printf("CIosCommsSocket : connect error, WSAENOBUFS");
			break;

			case WSAENOTCONN:
				printf("CIosCommsSocket : connect error, WSAENOTCONN");
			break;

			case WSAENOTSOCK:
				printf("CIosCommsSocket : connect error, WSAENOTSOCK");
			break;

			case WSAETIMEDOUT:
				printf("CIosCommsSocket : connect error, WSAETIMEDOUT");
			break;

			default:
				printf("CIosCommsSocket : connect error, unknown");
			break;
		}
#endif
		// Set the error flag.

		m_bError = TRUE;
	}
	else
	{
		// Attempt succeeded.

		m_bConnected = TRUE;
	}
}

//
// CIosCommsSocket::OnReceive
// Called when data is received
// Entry   : error code
// Returns : nothing
//

void CIosCommsSocket::OnReceive(int nErrorCode)
{
	// Attempt base class OnReceive.

	CAsyncSocket::OnReceive(nErrorCode);

	if(nErrorCode)
	{
		// Attempt failed, send error message to CMainFrame.
#if 0
		switch(nErrorCode)
		{
			case WSAENETDOWN:
				printf("CIosCommsSocket : on receive error, WSAENETDOWN");
			break;

			default:
				printf("CIosCommsSocket : on receive error, unknown");
			break;
		}
#endif
		// Set the error flag.

		m_bError = TRUE;
	}
	else
	{
		// Attempt succeeded, resume SocketReceive().

		m_evReceive.SetEvent();
	}
}

//
// CIosCommsSocket::OnSend
// Called when ok to send data
// Entry   : error code
// Returns : nothing
//

void CIosCommsSocket::OnSend(int nErrorCode)
{
	// Attempt base class OnSend.

	CAsyncSocket::OnSend(nErrorCode);

	if(nErrorCode)
	{
		// Attempt failed, send error message to CMainFrame.
#if 0
		switch(nErrorCode)
		{
			case WSAENETDOWN:
				printf("CIosCommsSocket : on send error, WSAENETDOWN");
			break;

			default:
				printf("CIosCommsSocket : on send error, unknown");
			break;
		}
#endif
		// Set the error flag.

		m_bError = TRUE;
	}
	else
	{
		// Attempt succeeded, resume SocketSend().

		m_evSend.SetEvent();
	}
}

/////////////////////////////////////////////////////////////////////////////
// CIosCommsSocket functions

//
// CIosCommsSocket::SocketAbort
// Set the socket m_bAbort flag, clear the socket connected flag
// Entry   : nothing
// Returns : nothing
//

void	CIosCommsSocket::SocketAbort()
{
	m_bAbort = TRUE;
	m_bConnected = FALSE;
	m_evReceive.SetEvent();
	m_evSend.SetEvent();
    Close();
}

//
// CIosCommsSocket::SocketCreate
// Create a socket
// Entry   : nothing
// Returns : TRUE if successful, FALSE if not
//

BOOL	CIosCommsSocket::SocketCreate()
{
	// Base class.

	if(Create() == 0)
	{
		// Socket creation failed, send error message to CMainFrame.
#if 1
		switch(GetLastError())
		{
			case WSANOTINITIALISED:
				printf("CIosComms Error :  socket create failed, WSANOTINITIALISED");
			break;

			case WSAENETDOWN:
				printf("CIosComms Error :  socket create failed, WSAENETDOWN");
			break;

			case WSAEAFNOSUPPORT:
				printf("CIosComms Error :  socket create failed, WSAEAFNOSUPPORT");
			break;

			case WSAEINPROGRESS:
				printf("CIosComms Error :  socket create failed, WSAEINPROGRESS");
			break;

			case WSAEMFILE:
				printf("CIosComms Error :  socket create failed, WSAEMFILE");
			break;

			case WSAENOBUFS:
				printf("CIosComms Error :  socket create failed, WSAENOBUFS");
			break;

			case WSAEPROTONOSUPPORT:
				printf("CIosComms Error :  socket create failed, WSAEPROTONOSUPPORT");
			break;

			case WSAEPROTOTYPE:
				printf("CIosComms Error :  socket create failed, WSAEPROTOTYPE");
			break;

			case WSAESOCKTNOSUPPORT:
				printf("CIosComms Error :  socket create failed, WSAESOCKTNOSUPPORT");
			break;

			default:
				printf("CIosComms Error :  socket create failed, unknown");
			break;
		}
#endif
		// Return failed.

		return FALSE;
	}
	else
	{
		// Return succeeded.

		return TRUE;
	}
}

//
// CIosCommsSocket::SocketHasError()
// Return the m_bError flag
// Entry   : nothing
// Returns : TRUE if error, FALSE if not
//

BOOL	CIosCommsSocket::SocketHasError()
{
	return m_bError;
}

//
// CIosCommsSocket::SocketIsAborted
// Return the m_bAbort flag
// Entry   : nothing
// Returns : TRUE if aborted, FALSE if not
//

BOOL	CIosCommsSocket::SocketIsAborted()
{
	return m_bAbort;
}

//
// CIosCommsSocket::SocketIsClosed
// Return the m_bClosed flag
// Entry   : nothing
// Returns : TRUE if closed, FALSE if not
//

BOOL	CIosCommsSocket::SocketIsClosed()
{
	return m_bClosed;
}

//
// CIosCommsSocket::SocketIsConnected
// Return the m_bConnect flag
// Entry   : nothing
// Returns : TRUE if connected, FALSE if not
//

BOOL	CIosCommsSocket::SocketIsConnected()
{
	return m_bConnected;
}

/////////////////////////////////////////////////////////////////////////////
// CIosCommsSocket CIosComms thread support functions

//
// CIosCommsSocket::SocketRead
// Perform a socket read
// Entry   : pointer to destination buffer, byte count
// Returns : TRUE if successful, FALSE if not
// Notes   :
//
//	This function should ONLY be called by CIosComms::ThreadReceive().
//

BOOL	CIosCommsSocket::SocketRead(char * chBuffer, int nCount)
{
	// Read data from the socket.

	int		nBytesReceived;
	char *	pBuffer = chBuffer;
	int		nRemaining = nCount;

	while(nRemaining)
	{
		// See if reading should continue.

		if(m_bAbort)
		{
			// No, return not successful.

			return FALSE;
		}

		// Yes, see if any more data has been received.

		if((nBytesReceived = Receive(pBuffer, nRemaining, 0)) == SOCKET_ERROR)
		{
			// Error on receive, see why.

			int	nError = GetLastError();

			if(nError == WSAEWOULDBLOCK)
			{
				// Not an error, simply no data yet, suspend until OnReceive()
				// or SocketAbort().

				m_evReceive.Lock();
				continue;
			}
			else
			{
				// Error, send error message to CMainFrame.
#if 0
				switch(nError)
				{
					case WSANOTINITIALISED:
						printf("CIosCommsSocket : receive error, WSANOTINITIALISED");
					break;

					case WSAENETDOWN:
						printf("CIosCommsSocket : receive error, WSAEENETDOWN");
					break;

					case WSAENOTCONN:
						printf("CIosCommsSocket : receive error, WSAENOTCONN");
					break;

					case WSAEINPROGRESS:
						printf("CIosCommsSocket : receive error, WSAEINPROGRESS");
					break;
					
					case WSAENOTSOCK:
						printf("CIosCommsSocket : receive error, WSAENOTSOCK");
					break;

					case WSAEOPNOTSUPP:
						printf("CIosCommsSocket : receive error, WSAEOPNOTSUPP");
					break;

					case WSAESHUTDOWN:
						printf("CIosCommsSocket : receive error, WSAESHUTDOWN");
					break;

					case WSAEMSGSIZE:
						printf("CIosCommsSocket : receive error, WSAEMSGSIZE");
					break;

					case WSAEINVAL:
						printf("CIosCommsSocket : receive error, WSAEINVAL");
					break;

					case WSAECONNABORTED:
						printf("CIosCommsSocket : receive error, WSAECONNABORTED");
					break;

					case WSAECONNRESET:
						printf("CIosCommsSocket : receive error, WSAECONNRESET");
					break;

					default:
						printf("CIosCommsSocket : receive error, unknown");
					break;
				}
#endif
				// Set the error flag.

				m_bError = TRUE;

				// Return error.

				return FALSE;
			}
		}
		else
		{
			// Data received, update the receive parameters.

			if(nBytesReceived > nRemaining)
			{
				// For some reason the socket returned more data than
				// was requested, send error message to CMainFrame.

//				AfxGetMainWnd()->SendMessage(WM_IOSRT_MESSAGE, MESSAGE_ERROR, (LPARAM)"CIosCommsSocket : socket read more data than requested.");

				// Set the error flag.

				m_bError = TRUE;

				// Return error.

				return FALSE;
			}
			else
			{
				// Received no more bytes from socket than was
				// asked for, update receive parameters.

				nRemaining -= nBytesReceived;
				pBuffer += nBytesReceived;
			}
		}
	}

	// End.

	return TRUE;
}

//
// CIosCommsSocket::SocketSend
// Perform a socket send
// Entry   : pointer to source buffer, byte count
// Returns : TRUE if successful, FALSE if not
// Notes   :
//
//	This function should ONLY be called by CIosComms::ThreadSend().
//

BOOL	CIosCommsSocket::SocketSend(char * chBuffer, int nCount)
{
	// Send data to socket.

	int				nBytesSent;
	char*			pBuffer = (char *)chBuffer;
	int				nRemaining = nCount;

	while(nRemaining)
	{
		// See if sending should continue.

		if(m_bAbort)
		{
			// No, return not successful.

			return FALSE;
		}

		// Yes, attempt send.

		if((nBytesSent = Send(pBuffer, nRemaining, 0)) == SOCKET_ERROR)
		{
			// Send failed, see why.

			int		nError;

			if((nError = GetLastError()) == WSAEWOULDBLOCK)
			{
				// Not an error, socket is busy sending, suspend until OnSend()
				// or SocketAbort().

				m_evSend.Lock();
				continue;
			}
			else
			{
				// Error, send error message to CMainFrame.
#if 0
				switch(nError)
				{
					case WSANOTINITIALISED:
						printf("CIosCommsSocket : send error, WSANOTINITIALISED");
					break;

					case WSAENETDOWN:
						printf("CIosCommsSocket : send error, WSAEENETDOWN");
					break;

					case WSAEACCES:
						printf("CIosCommsSocket : send error, WSAEACCES");
					break;

					case WSAEINPROGRESS:
						printf("CIosCommsSocket : send error, WSAEINPROGRESS");
					break;

					case WSAEFAULT:
						printf("CIosCommsSocket : send error, WSAEFAULT");
					break;

					case WSAENETRESET:
						printf("CIosCommsSocket : send error, WSAENETRESET");
					break;

					case WSAENOBUFS:
						printf("CIosCommsSocket : send error, WSAENOBUFS");
					break;

					case WSAENOTCONN:
						printf("CIosCommsSocket : send error, WSAENOTCONN");
					break;

					case WSAENOTSOCK:
						printf("CIosCommsSocket : send error, WSAENOTSOCK");
					break;

					case WSAEOPNOTSUPP:
						printf("CIosCommsSocket : send error, WSAEOPNOTSUPP");
					break;

					case WSAESHUTDOWN:
						printf("CIosCommsSocket : send error, WSAESHUTDOWN");
					break;

					case WSAEMSGSIZE:
						printf("CIosCommsSocket : send error, WSAEMSGSIZE");
					break;

					case WSAEINVAL:
						printf("CIosCommsSocket : send error, WSAEINVAL");
					break;

					case WSAECONNABORTED:
						printf("CIosCommsSocket : send error, WSAECONNABORTED");
					break;

					case WSAECONNRESET:
						printf("CIosCommsSocket : send error, WSAECONNRESET");
					break;

					default:
						printf("CIosCommsSocket : send error, unknown");
					break;
				}
#endif				
				// Set the error flag.

				m_bError = TRUE;

				// Return error.

				return FALSE;
			}
		}
		else
		{
			// Update the send parameters.

			if(nBytesSent > nRemaining)
			{
				// Error, for some reason the socket sent more than it
				// was asked to, send error message to CMainFrame.
				
//				AfxGetMainWnd()->SendMessage(WM_IOSRT_MESSAGE, MESSAGE_ERROR, (LPARAM)"CIosCommsSocket : socket read more data than requested.");

				// Set the error flag.

				m_bError = TRUE;

				// Return error.

				return FALSE;
			}
			else
			{
				// Sent no more bytes from socket than was asked
				// to, update send parameters.

				pBuffer += nBytesSent;
				nRemaining -= nBytesSent;
			}
		}
	}

	// End.

	return TRUE;
}