#ifndef __IOSCOMMSOBJECT_H__
#define __IOSCOMMSOBJECT_H__

// iosCommsObject.h : header file
//

// Comms object access modes.

enum
{
	COMMS_READ,
	COMMS_WRITE,
	COMMS_READ_WRITE,
	COMMS_HOST_PLOT,
};

// Data structure.

typedef	struct
{
	union
	{
		char		Char;
		short		Short;
		unsigned short	UnsignedShort;
		int			Integer;
		UINT		UnsignedInteger;
		UINT		Logical;
		float		Float;
		double		Double;
		HostPlot	Plot;
	}	Type;
}		CommsData;

/////////////////////////////////////////////////////////////////////////////
// CIosCommsObject

class CIosCommsObject : public CObject
{
// Construction
public:
	CIosCommsObject();

// Attributes
private:

public:
	int						m_nDWords;						// number of dwords required to store the objects data
	CString					m_csLink;						// name of host variable to link to
	int						m_pLinkOffset;					// offset of host variable to link to in host
	BOOL					m_bLinked;						// TRUE if linked, FALSE if not
	int						m_nLinkType;					// type of host variable to link to in the host
	BOOL					m_bLocal;			// local variable
	BOOL					m_bRead;						// object is a read object
	LPVOID					m_pReadPointer;					// pointer to where to read from in IosRt
	int						m_nSymbolTableNumber;
	BOOL					m_bWrite;						// object is a write object
	LPVOID					m_pWritePointer;				// pointer to where to read from in IosRt

// Operations
private:
//	BOOL					AddLocal(void);
	BOOL					Read(LPVOID pDestination);
	void					CommsRead(LPVOID pDestination, LPVOID pSource);
	void					CommsWrite(LPVOID pDestination, LPVOID pSource);
public:
	int						DataType(void);
	void					Detach(void);
	BOOL					Initialize(CString csLink, int nMode);
	BOOL					Read(CommsData * pDestination);
	BOOL					Read(double * pDestination);
	BOOL					Read(float * pDestination);
	BOOL					Read(HostPlot * pDestination);
	BOOL					Read(int * pDestination);
	BOOL					Write(LPVOID pSource);
	BOOL					Write(double * pSource);
	BOOL					Write(float * pSource);
	BOOL					Write(int * pSource);

	// Implementation
public:
	virtual ~CIosCommsObject();
};

/////////////////////////////////////////////////////////////////////////////

#endif // __IOSCOMMSOBJECT_H__