// iosCommsObject.cpp : implementation file
//
// IOS Runtime Comms Object class.
//
// Copyright (c) 1997 by ZCT Systems Group, Inc.
// All Rights Reserved.
//
// Notes :
//
//	This file contains the IOS Runtime comms Object class.  This class is designed to
// provide the interface between the graphical objects and the CIosComms class.
//

#include "..\core\stdafx.h"
#include "ioscomms.h"
#include "iosCommsObject.h"
#include "iosHostComms.h"
#include "ZCTCommsSystemInterface.h"
#include "..\core\VariableData.h"

#include <winsock2.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CIosCommsObject

//
// CIosCommsObject::CIosCommsObject()
// Constructor
// Entry   : nothing
// Returns : nothing
//

CIosCommsObject::CIosCommsObject()
{
	// Initialize the link parameters.

	m_csLink = "";
	m_pLinkOffset = NULL;
	m_nLinkType = IOSRT_INT;
	m_bLinked = m_bLocal = m_bRead = m_bWrite = FALSE;
	m_pReadPointer = m_pWritePointer = NULL;
}

//
// CIosCommsObject::~CIosCommsObject()
// Destructor
// Entry   : nothing
// Returns : nothing
//

CIosCommsObject::~CIosCommsObject()
{
}


/////////////////////////////////////////////////////////////////////////////
// CIosCommsObject functions.

//
// CIosCommsObject::AddLocal
// Add comms object to local variable list
// Entry   : nothing
// Returns : TRUE if successful, FALSE if not
//
#if 0
BOOL	CIosCommsObject::AddLocal()
{
	// Attempt to add the local symbol.

	iosRtSymbolLocal*	pSymbol;
	if((pSymbol = symSymbolsLocal.Add((char *)(m_csLink.operator LPCTSTR()))) != NULL)
	{
		// Succeeded, set the link type and data size.

		m_nLinkType = pSymbol->nType;
		switch(m_nLinkType & DATA_TYPE_BITS)
		{
			case IOSRT_DOUBLE:
			{
				// Double data size is 2 dwords (64 bits = 8 bytes)

				m_nDWords = 2;
			}
			break;

			default:
			{
				// Default data size is 1 dword (32 bits = 4 bytes).

				m_nDWords = 1;
			}
			break;
		}

		// Set the storage address.

		m_pReadPointer = m_pWritePointer = (LPVOID)& pSymbol->chStorage;

		// Set the symbol table number.  Note when the CIosSymbolsLocal.Delete()
		// method is called, its m_nSymbolTableNumber member variable is incremented.
		// When this occurs, the CIosCommsObject read method knows to relink to the
		// new symbol table.

		m_nSymbolTableNumber = symSymbolsLocal.m_nSymbolTableNumber;

		// End.

		m_bLinked = TRUE;
		return TRUE;
	}
	else
	{
		// Failed.

		m_bLinked = m_bRead = m_bWrite = FALSE;
		m_pReadPointer = m_pWritePointer = NULL;

		// End.

		return FALSE;
	}
}
#endif
//
// CIosCommsObject::CommsRead
// Comms read
// Entry   : pointer to destination, pointer to source
// Returns : nothing
//

void	CIosCommsObject::CommsRead(LPVOID pDestination, LPVOID pSource)
{
	if(m_nLinkType & PLOT_BIT)
	{
		// Plot variable, copy the header.

		memcpy(pDestination, pSource, HOST_PLOT_HEADER_SIZE);

		// Initialize the destination and source pointers.

		HostPlot*	pDst = (HostPlot*)pDestination;
		HostPlot*	pSrc = (HostPlot*)pSource;

		// Copy the data.

		int			nCopyCount = pSrc->nCount;
		int			nCount;
		
		switch(pSrc->nType)
		{
			case IOSRT_DOUBLE:
			{
				// For doubles, copy 64 bit quantities with Intel byte
				// swapping as necessary.

				for(nCount = 0; nCount < (nCopyCount << 1); nCount += 2)
				{
					int nTemp = ntohl(pSrc->nArray[nCount]);
					pDst->nArray[nCount] = ntohl(pSrc->nArray[nCount + 1]);
					pDst->nArray[nCount + 1] = nTemp;
				}
			}
			break;

			default:
			{
				// For all else, copy 32 bit quantities with Intel byte
				// swapping as necessary.

				for(nCount = 0; nCount < nCopyCount; nCount ++)
				{
					pDst->nArray[nCount] = ntohl(pSrc->nArray[nCount]);
				}
			}
			break;
		}

		// Reset the count.

		pSrc->nCount = 0;
	}
	else
	{
		// Copy a data variable.

		switch(m_nLinkType & DATA_TYPE_BITS)
		{
			case IOSRT_CHAR:
			{
				// Billy Baker
				// 12 June 1998
				//
				// Changed (char)* (char *)pDestination = (char)*(char *)pSource;
				// to the code below after several days of work on the 777.  ZCT
				// code created a problem with IOS_USHORT being inserted in ioshostcomms.h
				// before IOS_CHAR.  The old ios_comms.h on the host side which is
				// used for symbol table creation does not have a USHORT.  After this was
				// fixed, information coming from simulation was ok but the assigment
				// was not.  Thus, the memcpy was added.
				memcpy(pDestination,pSource,1); 
			}
			break;

			case IOSRT_SHORT:
			{
				* (short *)pDestination = (short)ntohl(* (int *)pSource);
			}
			break;

			case IOSRT_USHORT:
			{
				* (unsigned short *)pDestination = (unsigned short)ntohl(* (unsigned int *)pSource);
			}
			break;

			case IOSRT_INT:
			case IOSRT_UINT:
			case IOSRT_LOGICAL:
			case IOSRT_FLOAT:
			{
				* (int *)pDestination = ntohl(* (int *)pSource);
			}
			break;

			case IOSRT_DOUBLE:
			{
				((int *)pDestination)[0] = ntohl(((int *)pSource)[0]);
				((int *)pDestination)[1] = ntohl(((int *)pSource)[1]);
			}
			break;
		}
	}
}

//
// CIosCommsObject::CommsWrite
// Comms write
// Entry   : pointer to destination, pointer to source
// Returns : nothing
//

void	CIosCommsObject::CommsWrite(LPVOID pDestination, LPVOID pSource)
{
	// Copy a data variable.

	switch(m_nLinkType & DATA_TYPE_BITS)
	{
		case IOSRT_CHAR:
		{
			* (int *)pDestination = * (char *)pSource;
		}
		break;

		case IOSRT_SHORT:
		{
			* (int *)pDestination = htonl(* (short *)pSource);
		}
		break;

		case IOSRT_USHORT:
		{
			* (unsigned int *)pDestination = htonl(* (unsigned short *)pSource);
		}
		break;

		case IOSRT_INT:
		case IOSRT_UINT:
		case IOSRT_LOGICAL:
		case IOSRT_FLOAT:
		{
			* (int *)pDestination = htonl(* (int *)pSource);
		}
		break;

		case IOSRT_DOUBLE:
		{
			((int *)pDestination)[0] = htonl(((int *)pSource)[0]);
			((int *)pDestination)[1] = htonl(((int *)pSource)[1]);
		}
		break;
	}
}

//
// CIosCommsObject::DataType
// Return the data type associated with the comms object
// Entry   : nothing
// Returns : IOSRT_<data type>
//

int		CIosCommsObject::DataType()
{
	return	m_nLinkType & DATA_TYPE_BITS;
}

//
// CIosCommsObject::Detach
// Detach a comms object
// Entry   : nothing
// Returns : nothing
//

void	CIosCommsObject::Detach()
{
	m_pReadPointer = NULL;
}

//
// CIosCommsObject::Initialize
// Called to initialize a comms object
// Entry   : link name, read and write flags
// Returns : TRUE if successful, FALSE if not
// Notes   :
//
//	This function initializes a comms object by obtaining the host address of
// the variable specified by csLink, setting the read and write attributes
// specified by nMode, and setting the variable type specified by the value in
// the symbol table for the variable.  If after calling this function the value
// m_bLinked = FALSE, the variable name was not located in the symbol table thus
// the comms object is not allowed to communicate with the host.
//

BOOL	CIosCommsObject::Initialize(CString csLink, int nMode)
{
	// Check the link address.

	if(m_bLinked)
	{
		// Object already has a link address.

		if(m_nLinkType & PLOT_BIT)
		{
			// Plot type comms objects can re-initialize.

//			CommandsFlush();
		}
		else
		{
			// All other type comms objects cannot re-initialize.

			return FALSE;
		}
	}

	// Initialize the read, write flags.

	switch(nMode)
	{
		case COMMS_READ:
		{
			m_bRead = TRUE;
		}
		break;

		case COMMS_WRITE:
		{
			m_bWrite = TRUE;
		}
		break;

		case COMMS_READ_WRITE:
		{
			m_bRead = m_bWrite = TRUE;
		}
		break;

		case COMMS_HOST_PLOT:
		{
			m_bRead = TRUE;
		}
		break;

		default:
		{
			return FALSE;
		}
		break;
	}

	// Attempt to obtain the host link address from the symbol table.

///	iosRtSymbol*	pSymbol;
	m_csLink = csLink;
	m_bLocal = ((m_csLink[0] == '!') ? TRUE : FALSE);

	if(m_bLocal)
	{
		// Link to a local symbol
        return FALSE;
//		return AddLocal();
	}
	else
	{
		// Link to a host symbol.

//		iosRtSymbol*	pSymbol;
        CVariableData* pVarData = NULL;

//		int	nElement = 0;
//		CIosrtApp* pApp = (CIosrtApp*)AfxGetApp();
		// Billy Baker
		// 3 June 1998
		// 
		// 1.0.3 moved SymbolNameAndElement to CIosSymbols.
#if 1
        if (CZCTCommsSystemInterface::m_mapVarName2Data.find((LPCTSTR)m_csLink) != 
            CZCTCommsSystemInterface::m_mapVarName2Data.end())
        {
            pVarData = (CVariableData*)CZCTCommsSystemInterface::m_mapVarName2Data[(LPCTSTR)m_csLink];
        }
		if(pVarData != NULL)
		{
			// Symbol found, set the link address, type and size of storage required.

			m_pLinkOffset = pVarData->Address();
		    switch(pVarData->Type())
		    {
			    case VAR_LONG_INT:
			    {
    			    m_nLinkType = IOSRT_INT;
			    }
			    break;

			    case VAR_FLOAT:
			    {
    			    m_nLinkType = IOSRT_FLOAT;
			    }
			    break;

			    case VAR_DOUBLE:
			    {
    			    m_nLinkType = IOSRT_DOUBLE;
			    }
			    break;

			    case VAR_BOOL:
			    {
    			    m_nLinkType = IOSRT_LOGICAL;
			    }
			    break;

			    case VAR_SHORT_INT:
			    {
    			    m_nLinkType = IOSRT_SHORT;
			    }
			    break;

			    case VAR_UNSIGNED_SHORT_INT:
			    {
    			    m_nLinkType = IOSRT_USHORT;
			    }
			    break;

			    case VAR_CHAR:
			    {
    			    m_nLinkType = IOSRT_CHAR;
			    }
			    break;

			    default:
			    {
    			    m_nLinkType = IOSRT_INT;
			    }
			    break;
		    }
			switch(m_nLinkType & DATA_TYPE_BITS)
			{
				case VAR_DOUBLE:
				{
					// Double data size is 2 dwords (64 bits = 8 bytes)

					m_nDWords = 2;
				}
				break;

				default:
				{
					// Default data size is 1 dword (32 bits = 4 bytes).

					m_nDWords = 1;
				}
				break;
			}

			if(nMode == COMMS_HOST_PLOT)
			{
				m_nLinkType |= PLOT_BIT;
			}

			if(m_bRead)
			{
				// Attach comms object to comms read.

				CZCTCommsSystemInterface::commsComms->CommsObjectAttachRead(this);
			}

			// End.

			m_bLinked = TRUE;

			return TRUE;
		}
		else
		{
			// Symbol not found, comms object cannot have read or write attributes.

			m_bLinked = m_bRead = m_bWrite = FALSE;
			// Make sure that a symbol table has been read.
//			if (pApp->m_bSymbolsLoaded != false)
//			{

//				pApp->LogMessage(CString("Symbol Not Found:\t" + m_csLink + "\t" + 
//											csCurrentDocumentName),
//								IDB_ERROR);
//			}

			// End.

			return FALSE;
		}
#endif
	}
}

//
// CIosCommsObject::Read
// Read data
// Entry   : pointer to location to deposit data being read
// Returns : TRUE if successful, FALSE if not
// Notes   :
//
//	There are four reasons why this function will return false :
//
//		1) The comms object does not have a link address.  This could occur for
//		   two reasons; the Initialize() function was not called for this comms
//		   object, or the Initialize() function was called but the symbol name
//		   was not found.
//
//		2) The comms object does not have a read attribute.  This could occur for
//		   three reasons; the Initialize() function was not called for this comms
//		   object, the Initialize() function was called but the symbol name was
//		   not found, or the Initialize() function was called and the read attribute
//		   was set to FALSE.
//
//		3) There are too many comms objects.  When CIosComms::CommsObjectAttachRead()
//		   was called, the number of comms objects was greater than or equal to
//		   MAX_COMMAND_DATA.  To solve this, change the value of MAX_COMMAND_DATA,
//		   located in the file "..\iosHost\iosHostCommands.h" to a higher value then
//		   recompile both iosHost and iosRt.
//
//		4) The comms object data has not been read.
//

BOOL	CIosCommsObject::Read(LPVOID pDestination)
{
	if((m_bLinked) && (m_bRead))
	{
#if 0
        if((m_bLocal) && (m_nSymbolTableNumber != symSymbolsLocal.m_nSymbolTableNumber))
		{
			// This comms object is communicating with a local symbol, and the symbol
			// table has changed, thus a re-link is necessary.

			if(AddLocal() == FALSE)
			{
				// The re-link failed.

				return FALSE;
			}
		}
#endif
		// Have a host address and read attribute.

		if(m_pReadPointer == NULL)
		{
			// Attach comms object to comms read.

			if(m_bLocal == FALSE)
				CZCTCommsSystemInterface::commsComms->CommsObjectAttachRead(this);

			// Return no read.

			return FALSE;
		}

		else if((CZCTCommsSystemInterface::commsComms->m_nReadReturnTag != CZCTCommsSystemInterface::commsComms->m_nSetReadPointersTag) &&
				(!(m_nLinkType & PLOT_BIT)) &&
				(!(m_bLocal)))

		{
			// The data for this object has yet to be read.  Note plot variables
			// are received outside of the normal read return channels thus they
			// are excluded from this test.

			return FALSE;
		}

		else if(m_pReadPointer)
		{
			// Have a read pointer, read.

			CommsRead(pDestination, m_pReadPointer);

			// Return read.

			return	TRUE;
		}
	}

	// Return no read.

	return FALSE;
}

//
// CIosCommsObject::Read
// Read data, convert to CommsData structure
// Entry   : pointer to CommsData
// Returns : TRUE if successful, FALSE if not
//

BOOL	CIosCommsObject::Read(CommsData * pDestination)
{
	return	Read((LPVOID) pDestination);
}

//
// CIosCommsObject::Read
// Read data, convert to double
// Entry   : pointer to double
// Returns : TRUE if successful, FALSE if not
//

BOOL	CIosCommsObject::Read(double * pDestination)
{
	CommsData		cdRead;

	if(Read(& cdRead))
	{
		// Read successful, convert to double.

		switch(DataType())
		{
			case IOSRT_CHAR:
				* pDestination = (double)cdRead.Type.Char;
			break;

			case IOSRT_SHORT:
				* pDestination = (double)cdRead.Type.Short;
			break;

			case IOSRT_USHORT:
				* pDestination = (double)cdRead.Type.UnsignedShort;
			break;

			case IOSRT_INT:
				* pDestination = (double)cdRead.Type.Integer;
			break;

			case IOSRT_UINT:
			case IOSRT_LOGICAL:
				* pDestination = (double)cdRead.Type.UnsignedInteger;
			break;

			case IOSRT_FLOAT:
				* pDestination = (double)cdRead.Type.Float;
			break;

			case IOSRT_DOUBLE:
				* pDestination = cdRead.Type.Double;
			break;

			default:
				return FALSE;
			break;
		}

		// Read successful.

		return TRUE;
	}
	else
	{
		// Read failed.

		return FALSE;
	}
}

//
// CIosCommsObject::Read
// Read data, convert to float
// Entry   : pointer to float
// Returns : TRUE if successful, FALSE if not
//

BOOL	CIosCommsObject::Read(float * pDestination)
{
	CommsData		cdRead;

	if(Read(& cdRead))
	{
		// Read successful, convert to float.

		switch(DataType())
		{
			case IOSRT_CHAR:
				* pDestination = (float)cdRead.Type.Char;
			break;

			case IOSRT_SHORT:
				* pDestination = (float)cdRead.Type.Short;
			break;

			case IOSRT_USHORT:
				* pDestination = (double)cdRead.Type.UnsignedShort;
			break;

			case IOSRT_INT:
				* pDestination = (float)cdRead.Type.Integer;
			break;

			case IOSRT_UINT:
			case IOSRT_LOGICAL:
				* pDestination = (float)cdRead.Type.UnsignedInteger;
			break;

			case IOSRT_FLOAT:
				* pDestination = cdRead.Type.Float;
			break;

			case IOSRT_DOUBLE:
				* pDestination = (float)cdRead.Type.Double;
			break;

			default:
				return FALSE;
			break;
		}

		// Read successful.

		return TRUE;
	}
	else
	{
		// Read failed.

		return FALSE;
	}
}

//
// CIosCommsObject::Read
// Read data, convert to HostPlot structure
// Entry   : pointer to HostPlot
// Returns : TRUE if successful, FALSE if not
//

BOOL	CIosCommsObject::Read(HostPlot * pDestination)
{
	return	Read((LPVOID) pDestination);
}

//
// CIosCommsObject::Read
// Read data, convert to int
// Entry   : pointer to int
// Returns : TRUE if successful, FALSE if not
//

BOOL	CIosCommsObject::Read(int * pDestination)
{
	CommsData		cdRead;

	if(Read((CommsData *)&cdRead))
	{
		// Read successful, convert to int.

		switch(DataType())
		{
			case IOSRT_CHAR:
				* pDestination = (int)cdRead.Type.Char;
			break;

			case IOSRT_SHORT:
				* pDestination = (int)cdRead.Type.Short;
			break;

			case IOSRT_USHORT:
				* pDestination = (double)cdRead.Type.UnsignedShort;
			break;

			case IOSRT_INT:
				* pDestination = (int)cdRead.Type.Integer;
			break;

			case IOSRT_UINT:
			case IOSRT_LOGICAL:
				* pDestination = (int)cdRead.Type.UnsignedInteger;
			break;

			case IOSRT_FLOAT:
				* pDestination = (int)cdRead.Type.Float;
			break;

			case IOSRT_DOUBLE:
				* pDestination = (int)cdRead.Type.Double;
			break;

			default:
				return FALSE;
			break;
		}

		// Read successful.

		return TRUE;
	}
	else
	{
		// Read failed.

		return FALSE;
	}
}

//
// CIosCommsObject::Write
// Write data
// Entry   : pointer to location of data being written
// Returns : TRUE if successful, FALSE if not
// Notes   :
//
//	There are three reasons why this function will return false :
//
//		1) The comms object does not have a link address.  This could occur for
//		   two reasons; the Initialize() function was not called for this comms
//		   object, or the Initialize() function was called but the symbol name
//		   was not found.
//
//		2) The comms object does not have a write attribute.  This could occur for
//		   three reasons; the Initialize() function was not called for this comms
//		   object, the Initialize() function was called but the symbol name was
//		   not found, or the Initialize() function was called and the write attribute
//		   was set to FALSE.
//
//		3) There are too many comms objects.  When CIosComms::CommsObjectAttachWrite()
//		   was called, the number of comms objects was greater than or equal to
//		   MAX_COMMAND_DATA.  To solve this, change the value of MAX_COMMAND_DATA,
//		   located in the file "..\iosHost\iosHostCommands.h" to a higher value then
//		   recompile both iosHost and iosRt.

BOOL	CIosCommsObject::Write(LPVOID pSource)
{
	if((m_bLinked) && (m_bWrite))
	{
		// Have a host address and write attribute, get a write pointer.

		if(m_bLocal)
        {}
//			AddLocal();
		else
			CZCTCommsSystemInterface::commsComms->CommsObjectAttachWrite(this);

		if(m_pWritePointer)
		{
			// Obtained a write pointer, write.

			CommsWrite(m_pWritePointer, pSource);

			// Have comms write.

			if(m_bLocal == FALSE)
				CZCTCommsSystemInterface::commsComms->m_bUpdateWrite = TRUE;

			// Finished with the pointer.

			if(m_bLocal == FALSE)
				m_pWritePointer = NULL;


			// Return write.

			return	TRUE;
		}
	}

	// Return no write.

	return FALSE;
}

//
// CIosCommsObject::Write
// Write double
// Entry   : pointer to location of double being written
// Returns : TRUE if successful, FALSE if not
//

BOOL	CIosCommsObject::Write(double * pSource)
{
	if((m_bLinked) && (m_bWrite))
	{
		// Have a host address and write attribute, get a write pointer.

		if(m_bLocal)
        {}
//			AddLocal();
		else
			CZCTCommsSystemInterface::commsComms->CommsObjectAttachWrite(this);

		if(m_pWritePointer)
		{
			// Obtained a write pointer, write

			switch(DataType())
			{
				case IOSRT_CHAR:
				{
					char	chSource = (char)* pSource;
					CommsWrite(m_pWritePointer, & chSource);
				}
				break;

				case IOSRT_SHORT:
				{
					short	sSource = (short)* pSource;
					CommsWrite(m_pWritePointer, & sSource);
				}
				break;

				case IOSRT_USHORT:
				{
					unsigned short	sSource = (unsigned short)* pSource;
					CommsWrite(m_pWritePointer, & sSource);
				}
				break;

				case IOSRT_INT:
				{
					int		nSource = (int)* pSource;
					CommsWrite(m_pWritePointer, & nSource);
				}
				break;

				case IOSRT_UINT:
				case IOSRT_LOGICAL:
				{
					UINT	uSource = (UINT)* pSource;
					CommsWrite(m_pWritePointer, & uSource);
				}
				break;

				case IOSRT_FLOAT:
				{
					float	fSource = (float)* pSource;
					CommsWrite(m_pWritePointer, & fSource);
				}
				break;

				case IOSRT_DOUBLE:
				{
					CommsWrite(m_pWritePointer, pSource);
				}
				break;

				default:
					m_pWritePointer = NULL;
					return FALSE;
				break;
			}

			// Have comms write.

			if(m_bLocal == FALSE)
				CZCTCommsSystemInterface::commsComms->m_bUpdateWrite = TRUE;

			// Finished with the pointer.

			if(m_bLocal == FALSE)
				m_pWritePointer = NULL;

			// Return write.

			return	TRUE;
		}
	}

	// Return no write.

	return FALSE;
}

//
// CIosCommsObject::Write
// Write float
// Entry   : pointer to location of float being written
// Returns : TRUE if successful, FALSE if not
//

BOOL	CIosCommsObject::Write(float * pSource)
{
	if((m_bLinked) && (m_bWrite))
	{
		// Have a host address and write attribute, get a write pointer.

		if(m_bLocal)
        {}
//			AddLocal();
		else
			CZCTCommsSystemInterface::commsComms->CommsObjectAttachWrite(this);

		if(m_pWritePointer)
		{
			// Obtained a write pointer, write

			switch(DataType())
			{
				case IOSRT_CHAR:
				{
					char	chSource = (char)* pSource;
					CommsWrite(m_pWritePointer, & chSource);
				}
				break;

				case IOSRT_SHORT:
				{
					short	sSource = (short)* pSource;
					CommsWrite(m_pWritePointer, & sSource);
				}
				break;

				case IOSRT_USHORT:
				{
					unsigned short	sSource = (unsigned short)* pSource;
					CommsWrite(m_pWritePointer, & sSource);
				}
				break;

				case IOSRT_INT:
				{
					int		nSource = (int)* pSource;
					CommsWrite(m_pWritePointer, & nSource);
				}
				break;

				case IOSRT_UINT:
				case IOSRT_LOGICAL:
				{
					UINT	uSource = (UINT)* pSource;
					CommsWrite(m_pWritePointer, & uSource);
				}
				break;

				case IOSRT_FLOAT:
				{
					CommsWrite(m_pWritePointer, pSource);
				}
				break;

				case IOSRT_DOUBLE:
				{
					double	dSource = (double)* pSource;
					CommsWrite(m_pWritePointer, & dSource);
				}
				break;

				default:
					m_pWritePointer = NULL;
					return FALSE;
				break;
			}

			// Have comms write.

			if(m_bLocal == FALSE)
				CZCTCommsSystemInterface::commsComms->m_bUpdateWrite = TRUE;

			// Finished with the pointer.

			if(m_bLocal == FALSE)
				m_pWritePointer = NULL;

			// Return write.

			return	TRUE;
		}
	}

	// Return no write.

	return FALSE;
}

//
// CIosCommsObject::Write
// Write int
// Entry   : pointer to location of int being written
// Returns : TRUE if successful, FALSE if not
//

BOOL	CIosCommsObject::Write(int * pSource)
{
	if((m_bLinked) && (m_bWrite))
	{
		// Have a host address and write attribute, get a write pointer.

		if(m_bLocal)
        {}
//			AddLocal();
		else
            CZCTCommsSystemInterface::commsComms->CommsObjectAttachWrite(this);

		if(m_pWritePointer)
		{
			// Obtained a write pointer, write

			switch(DataType())
			{
				case IOSRT_CHAR:
				{
					char	chSource = (char)* pSource;
					CommsWrite(m_pWritePointer, & chSource);
				}
				break;

				case IOSRT_SHORT:
				{
					short	sSource = (short)* pSource;
					CommsWrite(m_pWritePointer, & sSource);
				}
				break;

				case IOSRT_USHORT:
				{
					unsigned short	sSource = (unsigned short)* pSource;
					CommsWrite(m_pWritePointer, & sSource);
				}
				break;

				case IOSRT_INT:
				{
					CommsWrite(m_pWritePointer, pSource);
				}
				break;

				case IOSRT_UINT:
				case IOSRT_LOGICAL:
				{
					UINT	uSource = (UINT)* pSource;
					CommsWrite(m_pWritePointer, & uSource);
				}
				break;

				case IOSRT_FLOAT:
				{
					float	fSource = (float)* pSource;
					CommsWrite(m_pWritePointer, & fSource);
				}
				break;

				case IOSRT_DOUBLE:
				{
					double	dSource = (double)* pSource;
					CommsWrite(m_pWritePointer, & dSource);
				}
				break;

				default:
					m_pWritePointer = NULL;
					return FALSE;
				break;
			}

			// Have comms write.

			if(m_bLocal == FALSE)
				CZCTCommsSystemInterface::commsComms->m_bUpdateWrite = TRUE;

			// Finished with the pointer.

			if(m_bLocal == FALSE)
				m_pWritePointer = NULL;

			// Return write.

			return	TRUE;
		}
	}

	// Return no write.

	return FALSE;
}
