#ifndef __IOSCOMMS_H__
#define __IOSCOMMS_H__

#include <afxmt.h>
#include "iosHostComms.h"

class	CIosCommsObject;
class	CIosCommsSocket;

#define	MAX_QUEUED_COMMANDS	8

// iosComms.h : header file
//
#include <afxtempl.h>
typedef CTypedPtrList<CPtrList, CIosCommsObject*> CIosCommsList;
typedef CTypedPtrList<CPtrList, iosRtCommand*> CIosRtCommandList;

/////////////////////////////////////////////////////////////////////////////
// CIosComms

class CIosComms : public CObject
{
// Construction
public:
	CIosComms();

// Attributes
public:
	iosRtCommand			m_cmdCommandNull;
	iosRtCommand			m_cmdCommandRead;
	HostCommand				m_cmdCommandReadReturn;
	int						m_nCommandReadReturnPosition;
	iosRtCommand			m_cmdCommandQueueSend[MAX_QUEUED_COMMANDS];
	CIosRtCommandList		m_pCommandQueueSend;
	int						m_nCommandQueueSendPosition;
	iosRtCommand			m_cmdCommandSetReadPointers;
	int						m_nCommandSetReadPointersPosition;
	iosRtCommand			m_cmdCommandSetWritePointers;
	int						m_nCommandSetWritePointersPosition;
	CRITICAL_SECTION		m_csCommandsLock;
	iosRtCommand			m_cmdCommandWrite;
	int						m_nCommandWritePosition;
	CString					m_csHostName;
	int						m_nHostPlots;
	HostPlot				m_hpHostPlots[MAX_PLOT_BUFFERS];
	int						m_nHostPort;
	CIosCommsList			m_commsReadObjects;
	int						m_nReadReturnTag;
	BOOL					m_bSendReadCommand;
	int						m_nSendReadCommandDelay;
	int						m_nSetReadPointersTag;
	CIosCommsSocket*		m_pSocket;
	CWinThread*				m_pThreadReceive;
	CWinThread*				m_pThreadSend;
	CEvent					m_evThreadSend;
	BOOL					m_bUpdateReadPointers;
	BOOL					m_bUpdateWrite;
	BOOL					m_bUpdateWritePointers;
	bool					m_bDisplayDialog;
	bool					m_bTryToConnect;

    CString                 m_strMachineName;
    unsigned long int       m_ulPort;

// Operations
public:
	void					Close(void);
	BOOL					CommandBufferAdd(iosRtCommand* piosRtCommand);
	void					CommandBufferFlush(void);
	void					CommandsFlush(void);
	void					CommandsInitialize(void);
	void					CommandsLock(void);
	void					CommandsUnlock(void);
	BOOL					CommsObjectAttachRead(CIosCommsObject* pComms);
	BOOL					CommsObjectAttachWrite(CIosCommsObject* pComms);
	void					Delete(void);
	static UINT				ThreadReceive(LPVOID pParam);
	static UINT				ThreadSend(LPVOID pParam);
	void					Update(void);
	CString					VarIntTypeToString(int nVarType);
	int						VarStringToVarIntType(const CString& strVarTypeName);
	int						VarIntTypeToOleVarType(int nVarType);

	// Implementation
public:
	virtual ~CIosComms();
};

/////////////////////////////////////////////////////////////////////////////

#endif // __IOSCOMMS_H__