/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : HostVarNameLocalCommsAction.cpp
//
// Date             : 17 January 2000
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.6 $
//
// Description      : HostVarNameLocalCommsAction.cpp contains the implementation 
//                    of the CHostVarNameLocalCommsAction class.  This class is 
//                    similar to the CCommsAction class.  As opposed to 
//                    calling a CCommsSystemInterface class WriteData 
//                    member, CHostVarNameLocalCommsAction updates the CVariant to 
//                    which this class has a pointer and then call 
//                    OnUpdate for each CHostVarNameLocalCommsAction also attached 
//                    to the same pointer. 
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : None.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3
//                                          Microsoft Windows NT 5.0
//
//                    Compiler(s) - Visual C++ 5.0 with VisC++ service pack 3
//                                  Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: HostVarNameLocalCommsAction.cpp $
// Revision 1.6  2000/06/08 06:50:54  billyb
// Revised locking scheme.
// Revision 1.5  2000/03/31 22:29:18  billyb
// Removed help text.
// Revision 1.4  2000/02/01 19:54:33  billyb
// Change validation to look for the variable name as an
// IOS alias and as a host var name.  Error message for
// not found will now show up to 6 IOS aliases and up to
// 6 host var names that are close to the entered text.
// Revision 1.3  2000/01/27 07:54:43  billyb
// Changed error message to have both IOS alias and simulation
// variable names.
// Revision 1.2  2000/01/20 08:18:51  billyb
// Changed from VarName to HostVarName since the class
// looks up a host variable name.
/////////////////////////////////////////////////////////////////////////////
#include "..\core\stdafx.h"
#include "HostVarNameLocalCommsAction.h"

#include "..\core\DataConversion.h"

_FSI_STL::string  CHostVarNameLocalCommsAction::m_stlStrError;

UINT CHostVarNameLocalCommsAction::MsgThread(LPVOID param)
{
    ::MessageBox(NULL, 
                 _T(m_stlStrError.c_str()), 
                 _T("Invalid Range"), 
                 MB_OK | MB_ICONERROR | MB_SYSTEMMODAL);
    return 0;
}

CHostVarNameLocalCommsAction::CHostVarNameLocalCommsAction()
{
    m_stlStrWidgetName = _FSI_STL::string("Host_Variable_Name_Lookup");
}

/////////////////////////////////////////////////////////////////////////////
//
// CHostVarNameLocalCommsAction::~CHostVarNameLocalCommsAction
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 17 January 2000
//
// Engineer         : Billy Baker
//
// Description      : Default destructor.  If a CCommsSystemInterface derived
//                    class has been instaniated, then an attempt is made to
//                    remove this instance of CHostVarNameLocalCommsAction from the list of
//                    CHostVarNameLocalCommsAction instances managed by the 
//                    CCommsSystemInterface derived class.
//
/////////////////////////////////////////////////////////////////////////////
CHostVarNameLocalCommsAction::~CHostVarNameLocalCommsAction()
{
}

/////////////////////////////////////////////////////////////////////////////
//
// CWidget* CHostVarNameLocalCommsAction::CreateObject()
//
// Inputs           : None.
//
// Return Values    : Address of a new instance of CHostVarNameLocalCommsAction.
//
// Date             : 17 January 2000
//
// Engineer         : Billy Baker
//
// Description      : CreateObject() is a common framework method that must be
//                    implemented by each CWidget derived class.  The main
//                    application associates the name of this widget with this
//                    static CreateObject method so that a new object can be
//                    created without linking against the library that contains
//                    this class.
//
/////////////////////////////////////////////////////////////////////////////
CWidget* CHostVarNameLocalCommsAction::CreateObject()
{
    return new CHostVarNameLocalCommsAction();
}

/////////////////////////////////////////////////////////////////////////////
//
// void CHostVarNameLocalCommsAction::Initialize()
//
// Inputs           : CXMLWidget*& rpXMLWidget - pointer to return a new 
//                                               instance of a CXMLWidget.
//                    CWnd* pWnd - the parent of this widget.
//                    const long lId - the control ID.
//                    bool bEditMode - whether this widget is being created 
//                                     in the editor or the runtime.
//
// Return Values    : None.
//
// Date             : 17 January 2000
//
// Engineer         : Billy Baker
//
// Description      : Initialize() is a common framework method that must be
//                    implemented by each CWidget derived class.  Besides 
//                    standard initialization code for a CAction and CWidget
//                    derived class, the CCommsSystemInterface derived class
//                    is started if it has not already been started. 
//
/////////////////////////////////////////////////////////////////////////////
void CHostVarNameLocalCommsAction::Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                                const long lId, bool bEditMode)
{
    // Set the help text.
    if (rpXMLWidget == NULL)
    {
        m_stlStrName = "HOST VAR NAME LOOKUP ";
    }

    // Call the base class.
    CWidget::Initialize(rpXMLWidget,pWnd, lId, bEditMode);

    m_pAction = this;
    m_pWidget = (CWidget*)this;

    if (rpXMLWidget != NULL)
    {
        m_pIOActionXMLWidget = m_pXMLWidget;
        ResetProperties();
    }

    OnLoad();
}

/////////////////////////////////////////////////////////////////////////////
//
// enum LButtonUpReturn CHostVarNameLocalCommsAction::OnLButtonUp()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 17 January 2000
//
// Engineer         : Billy Baker
//
// Description      : OnLButtonUp() is a common framework method for CAction
//                    derived classes.  Its purpose is to perform a action 
//                    based on some user interaction with the graphical 
//                    element to which the instance of this class is attached.
//                    In this case, OnLButtonUp is used to get a value from
//                    the graphical element to then write to simulation.
//
/////////////////////////////////////////////////////////////////////////////
enum LButtonUpReturn CHostVarNameLocalCommsAction::OnLButtonUp()
{
    if (m_bCanWrite == false)
    {
        return LBU_CAN_NOT_WRITE;
    }

    if (m_bDeleting == true)
    {
        // Since memory is going away, the parent is probably
        // going away as well.  Let the parent think that
        // everything went ok.  Or, no write can take place
        return LBU_OK;
    }

    if (m_pLocalCommsSystemInterface == NULL)
    {
        return LBU_NO_COMMS;
    }

    CVariant variant;

    m_sync.Lock();

    // Make sure this instance is attached to a graphical element.
    if (CWidget::IsValidAddress(m_pParentWidget) != VALID )
    {
        m_sync.Unlock();
        return LBU_OK;
    }

    if (m_bUseSpecificRange == true && m_pRange != NULL)
    {
        variant = m_pRange->Lower();
    }
    else
    {
        // Get the value from the parent graphical element.
        CVariant  *pVariant   =  m_pParentWidget->GetValue(CString(m_stlStrElementVar.c_str()));

        if (pVariant != NULL)
            variant = *(pVariant);
        else
        {
            m_sync.Unlock();
            return LBU_OK;
        }
    }

    CWnd* pWnd = m_pParentWidget->FrameworkParent();

    m_sync.Unlock();

    // Perform range check before data conversion because the parent widget
    // will have a high and low in terms of the convert type if a conversion
    // was desired.
    if (m_pCommsSystemInterface != NULL)
    {
        _FSI_STL::string stlStrVariant = (_FSI_STL::string)variant;
        _FSI_STL::map<_FSI_STL::string, CVariableData*>::iterator mIt = 
            m_pCommsSystemInterface->m_mapVarName2Data.find(stlStrVariant);

        _FSI_STL::map<_FSI_STL::string, _FSI_STL::string>::iterator mHostIt =
            m_pCommsSystemInterface->m_mapHostToIOSAlias.find(stlStrVariant);

        // A host name and not an IOS alias.  Other cases would be neither
        // which would be not found, IOS alias and not host name, and both.
        if (mHostIt != m_pCommsSystemInterface->m_mapHostToIOSAlias.end() &&
            mIt == m_pCommsSystemInterface->m_mapVarName2Data.end())
        {
            variant.Value((*mHostIt).second);
        }

        if (mIt == m_pCommsSystemInterface->m_mapVarName2Data.end() &&
            mHostIt == m_pCommsSystemInterface->m_mapHostToIOSAlias.end())
        {
            // Add name to host variable name map.
            m_pCommsSystemInterface->m_mapHostToIOSAlias[stlStrVariant] = 
                                                        _FSI_STL::string("");
            mHostIt = 
              m_pCommsSystemInterface->m_mapHostToIOSAlias.find(stlStrVariant);

            // Add name to map with ios alias as key.
            m_pCommsSystemInterface->m_mapVarName2Data[stlStrVariant] = NULL;

            mIt = 
              m_pCommsSystemInterface->m_mapVarName2Data.find(stlStrVariant);

            _FSI_STL::map<_FSI_STL::string, CVariableData*>::iterator tmIt = mIt;
            _FSI_STL::map<_FSI_STL::string, _FSI_STL::string>::iterator tmHostIt = mHostIt;

            // Get IOS aliases before inserted name.
            CString strCloseMatches = "";
            int nCount = 0;
            while (nCount != 3 && tmIt != m_pCommsSystemInterface->m_mapVarName2Data.begin())
            {
                tmIt--;
                CString str((*tmIt).first.c_str());
                strCloseMatches = str + "\n" + strCloseMatches;
                nCount++;
                if (tmIt == m_pCommsSystemInterface->m_mapVarName2Data.begin())
                {
                    nCount = 3;
                }
            }

            // Get host names before inserted name.
            CString strCloseHostMatches = "";
            nCount = 0;
            while (nCount != 3 && tmHostIt != m_pCommsSystemInterface->m_mapHostToIOSAlias.begin())
            {
                tmHostIt--;
                CString str((*tmHostIt).first.c_str());
                strCloseHostMatches = str + "\n" + strCloseHostMatches;
                nCount++;
                if (tmHostIt == m_pCommsSystemInterface->m_mapHostToIOSAlias.begin())
                {
                    nCount = 3;
                }
            }

            // Get host names after the inserted name.
            tmHostIt    = mHostIt;
            tmHostIt++;
            nCount  = 0;
            while (nCount != 3 && tmHostIt != m_pCommsSystemInterface->m_mapHostToIOSAlias.end())
            {
                CString str((*tmHostIt).first.c_str());
                strCloseHostMatches = strCloseHostMatches + str + "\n";
                tmHostIt++;
                nCount++;
            }

            // Get IOS aliases after inserted name.
            tmIt    = mIt;
            tmIt++;
            nCount  = 0;
            while (nCount != 3 && tmIt != m_pCommsSystemInterface->m_mapVarName2Data.end())
            {
                CString str((*tmIt).first.c_str());
                strCloseMatches = strCloseMatches + str + "\n";
                tmIt++;
                nCount++;
            }

            m_pCommsSystemInterface->m_mapVarName2Data.erase(mIt);

            m_stlStrError = (_FSI_STL::string)variant + " is not a valid entry.\n" 
                            "For the variable " +
                            m_stlStrVariableToWatch +
                            ", possible matches are:\n" 
                            "IOS Aliases\n\n" + 
                            _FSI_STL::string((LPCTSTR)strCloseMatches) +
                            "\nHost Variable Names\n\n" + 
                            _FSI_STL::string((LPCTSTR)strCloseHostMatches);
            AfxBeginThread(MsgThread, (LPVOID)0);

            return LBU_NOT_IN_RANGE;
        }
    }

    // See if the parent widget is using a converted data value.  If so,
    // then convert it back to the format in which it came form the host.
    if (m_lDataFormat != m_lInitialDataFormat &&
        m_lDataFormat != Generic_No_Conversions)
    {
        variant = CDataConversion::Convert(variant, 
                                           (DATA_FORMATS)m_lDataFormat,
                                           (DATA_FORMATS)m_lInitialDataFormat);
    }

    // Write the value to widgets after changing its type to the
    // correct type in the variable data.
    if (m_pLocalCommsSystemInterface->m_mapVarName2Data.find(m_stlStrVariableToWatch) !=
        m_pLocalCommsSystemInterface->m_mapVarName2Data.end())
    {
         CVariableData* pVarData = 
                     m_pLocalCommsSystemInterface->m_mapVarName2Data[m_stlStrVariableToWatch];
         variant.ChangeType(pVarData->Type());
         if (pVarData->ScreenDependent() == false)
         {
            m_pLocalCommsSystemInterface->WriteData(&variant, pVarData, 
                                                    INDEPENDENT_VARIABLE);
         }
         else
         {
            if (pWnd != NULL)
            {
                pWnd = pWnd->GetParentFrame();
                m_pLocalCommsSystemInterface->WriteData(&variant, pVarData, (long)(pWnd->GetSafeHwnd()));
            }
         }
    }

    return LBU_OK;
}

