/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : FSISuiteCommsSystemInterface.h
//
// Date             : 09 February 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.4 $
//
// Description      : FSISuiteCommsSystemInterface.h contains the 
//                    definition of the CFSISuiteCommsSystemInterface 
//                    class.  This class is derived from 
//                    CCommsSystemInterface.  It should serve as the 
//                    primary communications model for FSISuite jobs 
//                    but doesn't have to.  As per the definition of 
//                    the base class, Start, WriteData, and 
//                    LoadVariables are implemented here.  ReadData is 
//                    used to get the data from simulation and 
//                    eventually pass it along to the graphical 
//                    elements.  An override of Stop is also defined.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : CCommsSystemInterface, string, CVariant, CXMLParser.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3
//                                          Microsoft Windows NT 5.0
//
//                    Compiler(s) - Visual C++ 5.0 with VisC++ service pack 3
//                                  Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: FSISuiteCommsSystemInterface.h $
// Revision 1.4  2000/05/03 21:13:49  billyb
// Added ResetStatistics.
// Revision 1.3  2000/03/06 16:19:12  billyb
// Changed function signatures to eliminate warnings.
// Added methods for dynamically adding and deleting
// variables from the data from the host.
// Revision 1.2  1999/11/16 07:30:57  billyb
// Removed commented static.
//
#if !defined(_FSISUITECOMMSSYSTEMINTERFACE_H_)
#define _FSISUITECOMMSSYSTEMINTERFACE_H_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "CommsSystemInterface.h"

class CFSISuiteCommsSocket;

class CFSISuiteCommsSystemInterface : public CCommsSystemInterface  
{
private:
 
protected:
    static UINT                   ThreadFunc(LPVOID lParam);
    static _FSI_STL::map<void*, long int>  m_mapWriteData;
    static CCriticalSection       m_syncWriteData;

    static void Decode(char* pcData, unsigned int nBufferSize);

public:
	CFSISuiteCommsSystemInterface();
	virtual ~CFSISuiteCommsSystemInterface();

    static CCommsSystemInterface* CreateComms();

    virtual void LoadVariables(const _FSI_STL::string& rstlStrVariablesFile);

    void ReadData();
    static  void ResetStatistics();

    virtual void AddVariable(const _FSI_STL::string& stlStrVariable, 
                             CVariableData& varData, 
                             _FSI_STL::list<CRange>& listRanges);
    virtual void AddData(CVariableData* pVarData);
    virtual void WriteData(CVariant* pVariant, CVariableData* pVarData);
    virtual void Start();
    virtual void Stop();

    static  CString m_DebriefMarkFile;
};

#endif // !defined(_FSISUITECOMMSSYSTEMINTERFACE_H_)
