/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : FSISuiteCommsSystemInterface.h
//
// Date             : 09 February 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.23 $
//
// Description      : FSISuiteCommsSystemInterface.h contains the 
//                    definition of the CFSISuiteCommsSystemInterface 
//                    class.  This class is derived from 
//                    CCommsSystemInterface.  It should serve as the 
//                    primary communications model for FSISuite jobs 
//                    but doesn't have to.  As per the definition of 
//                    the base class, Start, WriteData, and 
//                    LoadVariables are implemented here.  ReadData is 
//                    used to get the data from simulation and 
//                    eventually pass it along to the graphical 
//                    elements.  An override of Stop is also defined.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : CCommsSystemInterface, string, CVariant, CXMLParser.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3
//                                          Microsoft Windows NT 5.0
//
//                    Compiler(s) - Visual C++ 5.0 with VisC++ service pack 3
//                                  Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: FSISuiteCommsSystemInterface.cpp $
// Revision 1.23  2000/07/05 03:07:28  billyb
// Added virtual lock for receive buffer.
// Revision 1.22  2000/06/16 20:49:07  billyb
// Changed printfs to OutputDebugString.  Reorded code in
// ThreadFunc to not connect until after all DLLs have been
// loaded.  Fix type problems with ArrayOffset.  Removed
// check for host error in debrief writing.  
// Revision 1.21  2000/06/08 06:53:24  billyb
// Prevented communicating with host until all DLLs have been
// loaded to fix problem with dynamically adding variables.  Fixed
// writing beyond the bounds of the debrief structure.
// Revision 1.20  2000/05/30 16:41:57  billyb
// Fix for auto overlays not coming up after the first time.
// The fix makes sure that all ranges update their last state
// data rather than updating only those until a true condition
// is found.
// Revision 1.19  2000/05/26 16:28:22  billyb
// Fix offset calculation for dynamically adding variables to get
// from the host.  Fixed conditionals for finding the correct variable
// index for setting the host error value.
// Revision 1.18  2000/05/18 20:54:14  billyb
// Added parsing of FAILURE_TYPE and FAILURE_DATA>
// Revision 1.17  2000/05/03 21:28:50  billyb
// Added ResetStatistics for reconnections.
// Made CVariants exist for every variable all of the time.
// Fixed problems created by having CVariants always exist.
// Revision 1.16  2000/04/07 05:20:58  billyb
// Fixed 2D write problem.  Fixed reading of reading of non-
// character arrays.
// Revision 1.14  2000/03/06 16:22:15  billyb
// Changed function signatures to eliminate warnings.
// Made socket non-blocking for connect.  Corrected
// reading arrays.  Added methods for dynamically adding
// and deleting data from the host.
// Revision 1.13  2000/02/14 09:25:02  billyb
// Changed WriteData to write a second int at the end of
// CHANGE_VARIABLE commands for a second dimension.
// Revision 1.12  2000/02/09 19:58:09  billyb
// Changed length of data to host from char to short.  Changed
// WriteData to write single elements or entire arrays to the host.
// Revision 1.11  2000/02/01 19:53:21  billyb
// Added IOS alias and host var name to new map.
// Revision 1.10  2000/01/27 20:05:39  billyb
// Removed memsets.
// Revision 1.9  2000/01/27 08:02:16  billyb
// Added timeouts for send and recv.  Added parsing of LENGTH
// for arrays.  Added parsing for ACTION_TYPE and ACTION_DATA.
// Changed connect to bundle reset with the first block of ADD_VARIABLE
// commands.  Added messages for connection.
// Revision 1.8  1999/11/26 18:49:28  billyb
// Added decoding of size mismatch error data.
// Revision 1.7  1999/11/16 07:35:13  billyb
// Added statistics and handling of DIAGNOSTICS from host.
// Removed old unused error code for errors from the host.
// Made sure that ReadData would not step beyond buffer.
// Added multiple ADD_VARIABLE commands to one buffer.
// Revision 1.6  1999/11/10 23:00:22  billyb
// Added conditional in while(1) recv loop to check for a return
// value of 0 from recv which would mean that the TCP connection
// has been closed.
// Revision 1.5  1999/11/04 19:56:07  billyb
// Changed for loop to while and added variable for map end()
// call to decrease calls to end().  Changed size() call to empty()
// since size() is a calculation and empty() is an accessor for
// a member variable.  Delete XMLPage after variables are read.
// Revision 1.4  1999/10/14 19:18:57  billyb
// Changed call to ParseFile to use the class member for an
// IXMLDocument.
// Revision 1.3  1999/09/02 17:11:29  billyb
// Initialized the initial data format member of CVariableData
// when the variables file is read.
// Revision 1.2  1999/08/24 21:30:32  billyb
// Added debrief header to debrief file when it is first opened.
//
#include "..\core\stdafx.h"
#include <winsock2.h>
#include "FSISuiteCommsSystemInterface.h"
#include "..\core\XMLParser5.h"

#include "CommsAction.h"

#include "..\HostComms\Protocol.h"
#include "..\HostComms\IOSProtocol.h"

static _FSI_STL::string stlStrLog("IOS");

// SEND sizes are for host.  Reverse for client.
// RECEIVE sizes are for host.  Reverse for client.
static char     m_CommandReceive[IOS_MAX_SEND_BUFFER];
static char     m_CommandSend[IOS_MAX_RECEIVE_BUFFER];

static SOCKET   socketConnect       = INVALID_SOCKET;
static int      nSocketTimeout          = 1000;

_FSI_STL::map<void*, long int>  CFSISuiteCommsSystemInterface::m_mapWriteData;
CCriticalSection           CFSISuiteCommsSystemInterface::m_syncWriteData;

SOCKADDR_IN		soiAddressServer;

CString  CFSISuiteCommsSystemInterface::m_DebriefMarkFile;

/////////////////////////////////////////////////////////////////////////////
//
// CFSISuiteCommsSystemInterface::CFSISuiteCommsSystemInterface()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 09 February 1999
//
// Engineer         : Billy Baker
//
// Description      : Default constructor.
//
/////////////////////////////////////////////////////////////////////////////
CFSISuiteCommsSystemInterface::CFSISuiteCommsSystemInterface() : 
                                CCommsSystemInterface()
{
    m_bInitComplete = false;
    ResetStatistics();
}

/////////////////////////////////////////////////////////////////////////////
//
// CFSISuiteCommsSystemInterface::~CFSISuiteCommsSystemInterface()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 09 February 1999
//
// Engineer         : Billy Baker
//
// Description      : Default destructor.
//
/////////////////////////////////////////////////////////////////////////////
CFSISuiteCommsSystemInterface::~CFSISuiteCommsSystemInterface()
{
}

/////////////////////////////////////////////////////////////////////////////
//
// CCommsSystemInterface* CFSISuiteCommsSystemInterface::CreateComms()
//
// Inputs           : None.
//
// Return Values    : address of a new instance of 
//                    CFISSuiteCommsSystemInterface.
//
// Date             : 09 February 1999
//
// Engineer         : Billy Baker
//
// Description      : CreateComms() creates a new instance of
//                    CFSISuiteCommsSystemInterface.  Each CCommsSystemInterface
//                    derived class must implement CreateComms so that the
//                    comms protocol can be dynamically changed during 
//                    operation.  A name, like FSISuite, is associated with
//                    a pointer to this method.  By storing pointers to 
//                    CreateComms methods, a large switch statement is not
//                    needed.
//
/////////////////////////////////////////////////////////////////////////////
CCommsSystemInterface* CFSISuiteCommsSystemInterface::CreateComms()
{
    return new CFSISuiteCommsSystemInterface;
}

/////////////////////////////////////////////////////////////////////////////
//
// void CFSISuiteCommsSystemInterface::LoadVariables()
//                    
//
// Inputs           : string& rstlStrVariablesFile - the name of the file
//                                                   to read.
//
// Return Values    : None.
//
// Date             : 10 February 1999
//
// Engineer         : Billy Baker
//
// Description      : LoadVariables() is a abstract virtual method 
//                    defined in CCommsSystemInterface.  Its purpose is 
//                    to read a data file(s) to obtain information 
//                    about the variables on the simulation side.  For 
//                    the FSISuite comms system interface, an XML file 
//                    is used without data about the address of the 
//                    variable on the simulation side.  Other data that 
//                    might be used include variable ID, variable type, 
//                    simulation variable name, alias name, and range 
//                    information.
//
/////////////////////////////////////////////////////////////////////////////
void CFSISuiteCommsSystemInterface::LoadVariables(const _FSI_STL::string& rstlStrVariablesFile)
{
    m_ulDebriefBufferSize = 0;

    CVariant variant;

    if (rstlStrVariablesFile != _FSI_STL::string(""))
    {
        CXMLParser5 xmlParser(rstlStrVariablesFile.c_str());

        // Clean up old file.
        if (m_pXMLVariablesPage != NULL)
        {
            delete m_pXMLVariablesPage;
            m_pXMLVariablesPage = NULL;
        }

        // Parse the new file.
        m_pXMLVariablesPage = new CXMLPage;
        xmlParser.ParseFile(m_pXMLVariablesPage, m_pXMLDoc);

        ELEMENT_LIST::iterator elIt = NULL;
        if (m_pXMLVariablesPage->FindElement(elIt, 
                                             _FSI_STL::string("SECONDARY_FILE")) == true)
        {
            m_stlStrSecondaryFile = (*elIt)->ElementValue();
        }

        elIt = NULL;
        STRING2STRING_MAP::iterator s2sIt;
        CVariableData* pVarData;
        while (m_pXMLVariablesPage->FindElement(elIt, 
                                             _FSI_STL::string("COMMS_VARIABLE")) == true)
        {
            // Get the alias name.
            _FSI_STL::string stlStrVarName((*elIt)->ElementValue().c_str());
            pVarData = new CVariableData;

            // Get the ID.
            if ((*elIt)->FindAttribute(s2sIt,_FSI_STL::string("ID")) == true)
            {
                if (pVarData != NULL)
                {
                    pVarData->ID(atoi((*s2sIt).second.c_str()));
                }
            }

            // Get the simulation variable name.
            if ((*elIt)->FindAttribute(s2sIt,_FSI_STL::string("SIM_VAR_NAME")) == true)
            {
                m_mapHostToIOSAlias[(*s2sIt).second] = stlStrVarName;
                if (m_mapVarName2Variant.find(stlStrVarName) != m_mapVarName2Variant.end())
                {
                    delete m_mapVarName2Variant[stlStrVarName];
                }

                m_mapVarName2Variant[stlStrVarName] = new CVariant();

                if (pVarData != NULL)
                {
                    pVarData->SimVarName((*s2sIt).second);
                }
            }

            // Get the type.
            if ((*elIt)->FindAttribute(s2sIt,_FSI_STL::string("TYPE")) == true)
            {
                if (pVarData != NULL)
                {
                    pVarData->Type(atoi((*s2sIt).second.c_str()));
                }
            }

            // Get the format.
            if ((*elIt)->FindAttribute(s2sIt,_FSI_STL::string("FORMAT")) == true)
            {
                if (pVarData != NULL)
                {
                    pVarData->InitialDataFormat(atoi((*s2sIt).second.c_str()));
                }
            }

            // Get any array length
            if ((*elIt)->FindAttribute(s2sIt, _FSI_STL::string("LENGTH")) == true)
            {
                if (pVarData != NULL)
                {
                    long int lLength = atoi((*s2sIt).second.c_str());

                    if (lLength < 1)
                    {
                        lLength = 1;
                    }

                    pVarData->ArrayLength(lLength);
                }
            }

            // Get any failure type and data
            if ((*elIt)->FindAttribute(s2sIt, _FSI_STL::string("FAILURE_TYPE")) == true)
            {
                if (pVarData != NULL)
                {
                    _FSI_STL::string stlStrFailureType = (*s2sIt).second;
                    _FSI_STL::string stlStrFailureData;
                    if ((*elIt)->FindAttribute(s2sIt, _FSI_STL::string("FAILURE_DATA")) == true)
                    {
                        stlStrFailureData = (*s2sIt).second;
                        pVarData->FailureData(stlStrFailureData);
                    }

                    pVarData->FailureType(CFailureSummarySystemInterface::ToFailureType((*s2sIt).second));
                    if (m_mapVarName2Variant.find(stlStrVarName) !=
                        m_mapVarName2Variant.end())
                    {
                        CFailureSummarySystemInterface::AddFailureVariable(stlStrFailureType, 
                                                                            stlStrFailureData,
                                                                            m_mapVarName2Variant[stlStrVarName]);
                    }
                }
            }

            // Get whether this variable is to be recorded for debriefing.
            // Check debrief last to make sure that you get all of the data
            // to compute sizes.
            if ((*elIt)->FindAttribute(s2sIt,_FSI_STL::string("DEBRIEF")) == true)
            {
                if (pVarData != NULL)
                {
                    CString strValue((*s2sIt).second.c_str());
                    strValue.MakeUpper();
                    if (strValue == "YES")
                    {
                        pVarData->Debrief(true);

                        if (m_bRecordDebrief == true)
                        {
                            // Since this variable is listed as being
                            // a debrief variable, add it to the map of
                            // debrief data.
                            if (m_mapVarName2Debrief.find(stlStrVarName) != 
                                                    m_mapVarName2Debrief.end())
                            {
                                m_mapVarName2Debrief.erase(m_mapVarName2Debrief.find(stlStrVarName));
                            }

                            m_mapVarName2Debrief[stlStrVarName] = pVarData;
                            m_ulDebriefBufferSize += 
                                                variant.Size(pVarData->Type()) *
                                                pVarData->ArrayLength();
                        }
                    }
                    else
                    {
                        pVarData->Debrief(false);
                    }
                }
            }

            // If one already exists, delete and replace.
            if (m_mapVarName2Data.find(stlStrVarName) != m_mapVarName2Data.end())
            {
                delete (*(m_mapVarName2Data.find(stlStrVarName))).second;
            }

            m_mapVarName2Data[stlStrVarName] = pVarData;
/*
            // If the variable is persistant, then create a special 
            // CCommsAction here that will not be destroyed until
            // the commssytem is stopped.
            if ((*elIt)->FindAttribute(s2sIt,_FSI_STL::string("PERSIST")) == true)
            {
                if (pVarData != NULL)
                {
                    pVarData->Persist((*s2sIt).second);
                    if ((*s2sIt).second == "YES")
                    {
                        unsigned long int ulReadType = 0;

                        // Get any read mode for the CCommsAction.
                        if ((*elIt)->FindAttribute(s2sIt,_FSI_STL::string("READ_MODE")) == true)
                        {
                            ulReadType = atoi((*s2sIt).second.c_str());
                        }

                        pVarData->ReadMode(ulReadType);

                        CCommsAction* pCommsAction = new CCommsAction;
                        CXMLWidget* pXMLWidget = NULL;
                        pCommsAction->Initialize(pXMLWidget, NULL, 0, false);
                        pCommsAction->ReadType(ulReadType);
                        pCommsAction->Variable(stlStrVarName);
                        m_listXMLWidgetsPersist.push_back(pXMLWidget);
                    }
                }
            }

*/
            // Get any size value for a list of variants.
            if ((*elIt)->FindAttribute(s2sIt,_FSI_STL::string("SIZE")) == true)
            {
                if (pVarData != NULL)
                {
                    unsigned long int ulSize = atoi((*s2sIt).second.c_str());

                    pVarData->ListSize(ulSize);

                    if (ulSize > 0)
                    {
                        if (m_mapVarName2Variant.find(stlStrVarName) != 
                            m_mapVarName2Variant.end())
                        {
//                            m_mapVarName2Variant[stlStrVarName]->List(true);
                            m_mapVarName2Variant[stlStrVarName]->MaxSize(ulSize);
                        }
                    }
                }
            }

            // Move to next element.
            elIt++;
        }

        elIt = NULL;
        while (m_pXMLVariablesPage->FindElement(elIt, _FSI_STL::string("RANGE")) == true)
        {

            // Get the log message.
            _FSI_STL::string stlStrLogMessage((*elIt)->ElementValue().c_str());

            // Get the alias name.
            if ((*elIt)->FindAttribute(s2sIt,_FSI_STL::string("VAR")) == true)
            {
                if (m_mapVarName2Data.find((*s2sIt).second) != m_mapVarName2Data.end())
                {
                    CVariableData* pVarData = m_mapVarName2Data[(*s2sIt).second];
                    CRange* pRange = new CRange;
                    if (pRange != NULL)
                    {
                        CString strMessage(stlStrLogMessage.c_str());
                        strMessage.MakeUpper();
                        if (strMessage == "BLANK")
                        {
                            pRange->LogMessage((*s2sIt).second + " - " + 
                                               stlStrLogMessage);
                        }
                        else
                        {
                            pRange->LogMessage(stlStrLogMessage);
                        }
                    }
                    m_mapVarName2Ranges[(*s2sIt).second].push_back(pRange);

                    if ((*elIt)->FindAttribute(s2sIt,_FSI_STL::string("ID")) == true)
                    {
                        if (pRange != NULL)
                        {
                            pRange->ID(atoi((*s2sIt).second.c_str()));
                        }
                    }

                    if ((*elIt)->FindAttribute(s2sIt,_FSI_STL::string("LOW")) == true)
                    {
                        if (pRange != NULL)
                        {
                            CVariant var;
                            var.Value((*s2sIt).second);
                            var.ChangeType(pVarData->Type());
                            pRange->Lower(var);
                        }
                    }

                    if ((*elIt)->FindAttribute(s2sIt,_FSI_STL::string("HIGH")) == true)
                    {
                        if (pRange != NULL)
                        {
                            CVariant var;
                            var.Value((*s2sIt).second);
                            var.ChangeType(pVarData->Type());
                            pRange->Upper(var);
                        }
                    }

                    if ((*elIt)->FindAttribute(s2sIt,_FSI_STL::string("BACK_TRUE")) == true)
                    {
                        if (pRange != NULL)
                        {
                            CColor color(CString((*s2sIt).second.c_str()));
                            pRange->BackgroundTrue(color);
                        }
                    }

                    if ((*elIt)->FindAttribute(s2sIt,_FSI_STL::string("FORE_TRUE")) == true)
                    {
                        if (pRange != NULL)
                        {
                            CColor color(CString((*s2sIt).second.c_str()));
                            pRange->ForegroundTrue(color);
                        }
                    }

                    if ((*elIt)->FindAttribute(s2sIt,_FSI_STL::string("TEXT_TRUE")) == true)
                    {
                        if (pRange != NULL)
                        {
                            pRange->TextTrue((*s2sIt).second);
                        }
                    }

                    if ((*elIt)->FindAttribute(s2sIt,_FSI_STL::string("BACK_FALSE")) == true)
                    {
                        if (pRange != NULL)
                        {
                            CColor color(CString((*s2sIt).second.c_str()));
                            pRange->BackgroundFalse(color);
                        }
                    }

                    if ((*elIt)->FindAttribute(s2sIt,_FSI_STL::string("FORE_FALSE")) == true)
                    {
                        if (pRange != NULL)
                        {
                            CColor color(CString((*s2sIt).second.c_str()));
                            pRange->ForegroundFalse(color);
                        }
                    }

                    if ((*elIt)->FindAttribute(s2sIt,_FSI_STL::string("TEXT_FALSE")) == true)
                    {
                        if (pRange != NULL)
                        {
                            pRange->TextFalse((*s2sIt).second);
                        }
                    }

                    if ((*elIt)->FindAttribute(s2sIt,_FSI_STL::string("LOWER_COND")) == true)
                    {
                        if (pRange != NULL)
                        {
                            pRange->LowerConditional(atoi((*s2sIt).second.c_str()));
                        }
                    }

                    if ((*elIt)->FindAttribute(s2sIt,_FSI_STL::string("UPPER_COND")) == true)
                    {
                        if (pRange != NULL)
                        {
                            pRange->UpperConditional(atoi((*s2sIt).second.c_str()));
                        }
                    }

                    // Get the action type that might display an overlay.
                    if ((*elIt)->FindAttribute(s2sIt,_FSI_STL::string("ACTION_TYPE")) == true)
                    {
                        if (pRange != NULL)
                        {
                            pRange->ActionType(atoi((*s2sIt).second.c_str()));
                        }
                    }

                    // Get any data that goes with the action type like a file to display.
                    if ((*elIt)->FindAttribute(s2sIt,_FSI_STL::string("ACTION_DATA")) == true)
                    {
                        if (pRange != NULL)
                        {
                            pRange->ActionData((*s2sIt).second.c_str());
                        }
                    }
                }
            }


            // Move to next element.
            elIt++;
        }

        if (m_pXMLVariablesPage != NULL)
        {
            delete m_pXMLVariablesPage;
            m_pXMLVariablesPage = NULL;
        }
    }

    // Compute all of the offsets for the data in the block
    // sent from simulation.
    unsigned long int ulOffset = 0;
    _FSI_STL::map<_FSI_STL::string, CVariableData*>::iterator mIt = 
                                                    m_mapVarName2Data.begin();
    _FSI_STL::map<_FSI_STL::string, CVariableData*>::iterator mendIt = 
                                                    m_mapVarName2Data.end();
    while (mIt != mendIt)
    {
        (*mIt).second->Offset(ulOffset);
        ulOffset += variant.Size((*mIt).second->Type()) * (*mIt).second->ArrayLength();
        mIt++;
    }
}

UINT CFSISuiteCommsSystemInterface::ThreadFunc(LPVOID lParam)
{
    long             dwNoNagle              = 1;
    long             size                   = 0;
    char*            pcSendBuffer           = m_CommandSend;
    struct sockaddr* pAddr                  = (struct sockaddr*)lParam;
    short            shID                   = 0;
    short            shAddCommandsToSend    = 0;
    short            shVarsAdded            = 0;
    short            shVarsDeleted          = 0;

    DWORD            dwData                 = 0;
    DWORD            dwBytesRead;
    DWORD            dwBytesLeft;
    DWORD            dwBytesLeftMsg;

    int              dwNoBlocking = TRUE;

    bool             bReconnect             = true;
    bool             bWaitForSelect         = false;
    short            shAddErrors            = 0;

    bool             bAddVariables          = false;
    bool             bResetNeeded           = false;
    short            shTimeout              = 0;

    bool             bDebriefSet            = false;

    CVariant         var;

    struct sockaddr  sockAddr;

    WSABUF           bufS;
    WSABUF           bufR;

    _FSI_STL::map<_FSI_STL::string, CVariableData*>::iterator mIt = m_mapVarName2Data.end();

    unsigned long int ulOffset = 0;
    _FSI_STL::map<_FSI_STL::string, CVariableData*>::iterator moffIt;
    _FSI_STL::map<_FSI_STL::string, CVariableData*>::iterator moffendIt;
    CVariant variant;

    memcpy(&sockAddr, pAddr, sizeof(SOCKADDR));

	socketConnect = socket(AF_INET, SOCK_STREAM, 0);

    memset(m_CommandSend, 0, sizeof(m_CommandSend));

    // Diable the Nagle algorithm
    linger lng;
    lng.l_onoff     = 1;
    lng.l_linger    = 0;
    while (1)
    {
        while (!m_bInitComplete)
        {
            Sleep(1000);
            ulOffset    = 0;
            moffIt      = m_mapVarName2Data.begin();
            moffendIt   = m_mapVarName2Data.end();
            while (moffIt != moffendIt)
            {
                (*moffIt).second->Offset(ulOffset);
                ulOffset += variant.Size((*moffIt).second->Type()) * (*moffIt).second->ArrayLength();
                moffIt++;
            }
        }

        if (!bDebriefSet)
        {
            if (!m_mapVarName2Debrief.empty())
            {
                if (m_pcDebriefData != NULL)
                {
                    delete [] m_pcDebriefData;
                }

                m_pcDebriefData = new char[m_ulDebriefBufferSize];
                memset(m_pcDebriefData, 0, m_ulDebriefBufferSize);

                
                CString  m_DebriefFileName("debrief.dat");
                HKEY  hKey;
                RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\FSISuite\\Comms"), 0, KEY_READ, &hKey);

                if (hKey != NULL)
                {
                    // get SWS name
                    CString   strValue;
                    DWORD     dwType, dwCount;
                    LONG      lResult;
                    lResult   =  RegQueryValueEx(hKey,      _T("DebriefOutput"), NULL, &dwType, NULL, &dwCount);
                    if (lResult  == ERROR_SUCCESS)
                    {
                        ASSERT(dwType  == REG_SZ);
                        lResult  =  RegQueryValueEx(hKey,   _T("DebriefOutput"), NULL, &dwType, (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)), &dwCount);
                        strValue.ReleaseBuffer();
                    }
                    m_DebriefFileName =  strValue;

                    RegCloseKey(hKey);
                }
               
                try
                {
                    m_fileDebrief.Open((LPCTSTR)m_DebriefFileName, CFile::modeCreate | CFile::modeWrite | CFile::typeBinary);
                    m_fileDebrief.Write(cDebriefHeader, ucDebriefHeaderSize);
                }
                catch (...)
                {
                   CString errMsg;
                   errMsg.Format("Debrief Error: trying to open [%s] for writing.", m_DebriefFileName);
                   AfxMessageBox(errMsg);
                }
                m_DebriefMarkFile   =  m_DebriefFileName.Left(m_DebriefFileName.ReverseFind('.') + 1) +  "ini";
                WritePrivateProfileString("Debrief Marks",  "Mark 1 ",        "0",  m_DebriefMarkFile);
                WritePrivateProfileString("Debrief Marks",  "Mark 2",         "0",  m_DebriefMarkFile);
                WritePrivateProfileString("Debrief Marks",  "Mark 3",         "0",  m_DebriefMarkFile);
                WritePrivateProfileString("Debrief Marks",  "Mark 4",         "0",  m_DebriefMarkFile);
                WritePrivateProfileString("Debrief Marks",  "Mark 5",         "0",  m_DebriefMarkFile);
                WritePrivateProfileString("Debrief Marks",  "Mark 6",         "0",  m_DebriefMarkFile);
                WritePrivateProfileString("Debrief Marks",  "Mark 7",         "0",  m_DebriefMarkFile);
                WritePrivateProfileString("Debrief Marks",  "Mark 8",         "0",  m_DebriefMarkFile);
                WritePrivateProfileString("Debrief Marks",  "Mark 9",         "0",  m_DebriefMarkFile);
                WritePrivateProfileString("Debrief Marks",  "Mark 10",        "0",  m_DebriefMarkFile);

                WritePrivateProfileString("Debrief Marks",  "Mark 1 Valid",   "0",  m_DebriefMarkFile);
                WritePrivateProfileString("Debrief Marks",  "Mark 2 Valid",   "0",  m_DebriefMarkFile);
                WritePrivateProfileString("Debrief Marks",  "Mark 3 Valid",   "0",  m_DebriefMarkFile);
                WritePrivateProfileString("Debrief Marks",  "Mark 4 Valid",   "0",  m_DebriefMarkFile);
                WritePrivateProfileString("Debrief Marks",  "Mark 5 Valid",   "0",  m_DebriefMarkFile);
                WritePrivateProfileString("Debrief Marks",  "Mark 6 Valid",   "0",  m_DebriefMarkFile);
                WritePrivateProfileString("Debrief Marks",  "Mark 7 Valid",   "0",  m_DebriefMarkFile);
                WritePrivateProfileString("Debrief Marks",  "Mark 8 Valid",   "0",  m_DebriefMarkFile);
                WritePrivateProfileString("Debrief Marks",  "Mark 9 Valid",   "0",  m_DebriefMarkFile);
                WritePrivateProfileString("Debrief Marks",  "Mark 10 Valid",  "0",  m_DebriefMarkFile);
            }

            bDebriefSet = true;
        }

        // Check the pipe to see if a shutdown has been sent.
        PeekNamedPipe(m_hPipeRead, &dwData, sizeof(dwData), &dwBytesRead, 
                      &dwBytesLeft, &dwBytesLeftMsg);

        if (dwData == 1)
        {
            CloseHandle(m_hPipeRead);
            break;
        }

        if (bReconnect)
        {
            UpdateComms();
            shTimeout += 1000 / m_fRate;
            Sleep(1000 / m_fRate);

            if (shTimeout > nSocketTimeout)
            {
                bWaitForSelect = false;
                shTimeout = 0;
                shutdown(socketConnect, SD_BOTH);
                closesocket(socketConnect);
                m_bConnected = false;
                m_syncWriteData.Lock();
                if (!m_mapWriteData.empty())
                {
                    _FSI_STL::map<void*, long int>::iterator mwdIt = m_mapWriteData.begin();

                    while(mwdIt != m_mapWriteData.end()) 
                    {
                        delete [] (*mwdIt).first;
                        m_mapWriteData.erase(mwdIt);
                        mwdIt = m_mapWriteData.begin();
                    }
                }
                m_syncWriteData.Unlock();
                ResetStatistics();

                socketConnect = socket(AF_INET, SOCK_STREAM, 0);

                ulOffset    = 0;
                moffIt      = m_mapVarName2Data.begin();
                moffendIt   = m_mapVarName2Data.end();
                while (moffIt != moffendIt)
                {
                    (*moffIt).second->Offset(ulOffset);
                    ulOffset += variant.Size((*moffIt).second->Type()) * (*moffIt).second->ArrayLength();
                    moffIt++;
                }
            }

            if (false == bWaitForSelect)
            {
                // Disable the Nagle algorithm
                if(setsockopt(socketConnect, IPPROTO_TCP, TCP_NODELAY, 
                              (char *)&dwNoNagle, sizeof(int)))
                {
	                OutputDebugString("FSISuite :  TCP_NODELAY error.");
                }

                // SEND sizes are for host.  Reverse for client.
                size = IOS_SEND_BUFFER_CACHE * IOS_MAX_SEND_BUFFER;
                if (setsockopt(socketConnect, SOL_SOCKET, SO_RCVBUF, (char *)&size, sizeof(size)))
                {
	                OutputDebugString("FSISuite :  Receive buffer change error.");
                }

                if(setsockopt(socketConnect, SOL_SOCKET, SO_LINGER, 
                          (char *)&lng, sizeof(lng)))
                {
	                OutputDebugString("FSISuite :  SO_LINGER error.");
                }

                dwNoBlocking = TRUE;
	            if(ioctlsocket(socketConnect, FIONBIO, (unsigned long*)&dwNoBlocking))
                {
	                OutputDebugString("FSISuite :  Non-blocking error.");
                }

                // RECEIVE sizes are for host.  Reverse for client.
                size = IOS_RECEIVE_BUFFER_CACHE * IOS_MAX_RECEIVE_BUFFER;
                if (setsockopt(socketConnect, SOL_SOCKET, SO_SNDBUF, (char *)&size, sizeof(size)))
                {
	                OutputDebugString("FSISuite :  Send buffer change error.");
                }

                if (connect(socketConnect, &sockAddr, sizeof(SOCKADDR)) == SOCKET_ERROR)
                {
                    if (GetLastError() == WSAEWOULDBLOCK)
                        bWaitForSelect = true;
                    else
                        m_bConnected = true;
                }
            }
            else
            {
                struct timeval timeout;
                fd_set setWrite;
                fd_set setRead;

                FD_ZERO(&setWrite);
                FD_SET(socketConnect, &setWrite);
                setRead = setWrite;

                timeout.tv_sec = 0L;
                timeout.tv_usec = 0L;

                if (select(-1, &setRead, &setWrite, NULL, &timeout) != 0)
                {
                    if (FD_ISSET(socketConnect, &setRead) || 
                        FD_ISSET(socketConnect, &setWrite))
                    {
                        bWaitForSelect = false;

                        dwNoBlocking = FALSE;
	                    if(ioctlsocket(socketConnect, FIONBIO, (unsigned long*)&dwNoBlocking))
                        {
	                        OutputDebugString("FSISuite :  Non-blocking error.");
                        }

                        if(setsockopt(socketConnect, SOL_SOCKET, SO_SNDTIMEO, 
                                  (char *)&nSocketTimeout, sizeof(nSocketTimeout)))
                        {
	                        OutputDebugString("FSISuite :  SO_SNDTIMEO error.");
                        }

                        if(setsockopt(socketConnect, SOL_SOCKET, SO_RCVTIMEO, 
                                  (char *)&nSocketTimeout, sizeof(nSocketTimeout)))
                        {
	                        OutputDebugString("FSISuite :  SO_RCVTIMEO error.");
                        }

                        if (CCommsShared::m_pLogSystemInterface != NULL)
                        {
                            CCommsShared::m_pLogSystemInterface->AddMessage(_FSI_STL::string("IOS"),
                                _FSI_STL::string("IOS communications established."));
                        }

                        memset(m_CommandSend, 0, sizeof(m_CommandSend));
                        pcSendBuffer        = m_CommandSend;

                        bReconnect          = false;
                        bResetNeeded        = true;

                        shAddCommandsToSend = m_mapVarName2Data.size();
                        shVarsAdded         = 0;
                        shVarsDeleted       = 0;
                        shAddErrors         = 0;
                        mIt                 = m_mapVarName2Data.begin();
                        bAddVariables       = true;
                        m_bConnected        = true;
                    }
                }
            }
        }

        if (bAddVariables == true && shAddCommandsToSend > 0 && !bWaitForSelect)
        {
            if (m_bWritePending == false)
            {
                short shIndex;
                unsigned short ushLength;
                unsigned short ushSize;

                // Send a command to add the next variable.
                m_bWritePending = true;

                memset(m_CommandSend, 0, sizeof(m_CommandSend));
                pcSendBuffer = m_CommandSend;

                if (bResetNeeded)
                {
                    // Send a reset message.
                    shID = RESET;
                    shID = htons(shID);
                    *(short *)pcSendBuffer = shID;
                    pcSendBuffer    += 2;
                    bResetNeeded    = false;
                }

                shID = ADD_VARIABLE;
                shID = htons(shID);

                while (1)
                {
                    *(short *)pcSendBuffer = shID;
                    pcSendBuffer += 2;

                    // Index
                    shIndex = m_mapVarName2Data.size() - shAddCommandsToSend;
                    (*mIt).second->ID(shIndex);
                    shIndex = htons(shIndex);
                    *(short *)pcSendBuffer = shIndex;
                    pcSendBuffer += 2;

                    // length of symbol name
                    ushLength = strlen((*mIt).second->SimVarName().c_str());
                    ushLength = htons(ushLength);
                    *(unsigned short *)pcSendBuffer = ushLength;
                    pcSendBuffer += 2;
                
                    // symbol name
                    memcpy(pcSendBuffer, (*mIt).second->SimVarName().c_str(), 
                           strlen((*mIt).second->SimVarName().c_str()));
                    pcSendBuffer += strlen((*mIt).second->SimVarName().c_str());

                    // size that the IOS expects
                    ushSize = var.Size((*mIt).second->Type()) * (*mIt).second->ArrayLength();
                    ushSize = htons(ushSize);
                    *(unsigned short *)pcSendBuffer = ushSize;
                    pcSendBuffer += sizeof(ushSize);

                    shAddCommandsToSend--;
                    shVarsAdded++;
                    mIt++;

                    if (shAddCommandsToSend == 0) 
                    {
                        bAddVariables = false;
                        break;
                    }

                    // size of currently added data + size of next add variable command
                    if (pcSendBuffer - m_CommandSend + 
                        8 + strlen((*mIt).second->SimVarName().c_str()) >= IOS_MAX_RECEIVE_BUFFER)
                    {
                        break;
                    }
                }
            }
        }
        else
        {
            bAddVariables = false;
        }

        if (!bReconnect)
        {
            if (m_bWritePending != true && shAddCommandsToSend == 0)
            {
                bufR.buf = m_CommandReceive;
                memset(bufR.buf, 0, sizeof(m_CommandReceive));
                bufR.len = IOS_MAX_SEND_BUFFER;
                int nBytesRead = 0;
                VirtualLock(m_CommandReceive, IOS_MAX_SEND_BUFFER);
                while (1)
                {
                    if ((nBytesRead = recv(socketConnect, bufR.buf, 
                                                bufR.len, 0)) == SOCKET_ERROR)
                    {
                        int nLastSocketError = WSAGetLastError();
                        shutdown(socketConnect, SD_BOTH);
                        closesocket(socketConnect);
                        m_bConnected = false;
                        m_syncWriteData.Lock();
                        if (!m_mapWriteData.empty())
                        {
                            _FSI_STL::map<void*, long int>::iterator mwdIt = m_mapWriteData.begin();

                            while(mwdIt != m_mapWriteData.end()) 
                            {
                                delete [] (*mwdIt).first;
                                m_mapWriteData.erase(mwdIt);
                                mwdIt = m_mapWriteData.begin();
                            }
                        }
                        m_syncWriteData.Unlock();
                        ResetStatistics();

                        bReconnect = true;
                	    socketConnect = socket(AF_INET, SOCK_STREAM, 0);

                        ulOffset    = 0;
                        moffIt      = m_mapVarName2Data.begin();
                        moffendIt   = m_mapVarName2Data.end();
                        while (moffIt != moffendIt)
                        {
                            (*moffIt).second->Offset(ulOffset);
                            ulOffset += variant.Size((*moffIt).second->Type()) * (*moffIt).second->ArrayLength();
                            moffIt++;
                        }


                        if (CCommsShared::m_pLogSystemInterface != NULL)
                        {
                            CString SocketErrorString;
                            SocketErrorString.Format("IOS communications closed - recv socket error %d.",
                                                              nLastSocketError);
                            CCommsShared::m_pLogSystemInterface->AddMessage(_FSI_STL::string("IOS"),
                                                             _FSI_STL::string(SocketErrorString));
                        }

                        break;
                    }

                    if (nBytesRead == 0)
                    {
                        // Hey, TCP recv returned zero bytes.  The host must
                        // be down.  But, it it is UDP, well, that's another 
                        // story.
                        shutdown(socketConnect, SD_BOTH);
                        closesocket(socketConnect);
                        m_bConnected = false;
                        m_syncWriteData.Lock();
                        if (!m_mapWriteData.empty())
                        {
                            _FSI_STL::map<void*, long int>::iterator mwdIt = m_mapWriteData.begin();

                            while(mwdIt != m_mapWriteData.end()) 
                            {
                                delete [] (*mwdIt).first;
                                m_mapWriteData.erase(mwdIt);
                                mwdIt = m_mapWriteData.begin();
                            }
                        }
                        m_syncWriteData.Unlock();
                        ResetStatistics();

                        bReconnect = true;
                	    socketConnect = socket(AF_INET, SOCK_STREAM, 0);

                        ulOffset    = 0;
                        moffIt      = m_mapVarName2Data.begin();
                        moffendIt   = m_mapVarName2Data.end();
                        while (moffIt != moffendIt)
                        {
                            (*moffIt).second->Offset(ulOffset);
                            ulOffset += variant.Size((*moffIt).second->Type()) * (*moffIt).second->ArrayLength();
                            moffIt++;
                        }

                        if (CCommsShared::m_pLogSystemInterface != NULL)
                        {
                            CCommsShared::m_pLogSystemInterface->AddMessage(_FSI_STL::string("IOS"),
                                _FSI_STL::string("IOS communications closed - no data from recv."));
                        }

                        break;
                    }

                    bufR.len -= nBytesRead;
                    if (bufR.len <= 0)
                    {
                        // Update the CCommsActions if everything was read and the parent
                        // comms pointer is not NULL.  ReadData follows the same calling
                        // convention as the other timer-based ReadData member methods but
                        // none of the parameters are used.
                        char *pcBuf = m_CommandReceive;
                        short shCount;
                        shCount = *(short *)pcBuf;
                        shCount = ntohs(shCount);
                        pcBuf += 2;

                        // If we received everything, the number of variables sent
                        // is greater than zero, the number sent is equal to the number
                        // added minus those deleted, then update the local copies of
                        // the simulation variables.
                        if (shCount > 0)
//                            &&
//                            shCount == (shVarsAdded - shAddErrors - shVarsDeleted))
                        {
                            if (CCommsAction::m_pCommsSystemInterface != NULL)
                            {
                                ((CFSISuiteCommsSystemInterface*)CCommsAction::m_pCommsSystemInterface)->ReadData();
                            }
                        }

                        if (shCount < 0)
                        {
                            switch (shCount)
                            {
                            case DIAGNOSTICS:
                                {
                                    // Diagnostics were sent.  This data buffer
                                    // should be immediately followed by a
                                    // buffer of real data.
                                    if (IOS_MAX_SEND_BUFFER <= 16)
                                    {
                                        break;
                                    }

                                    short sh;
                                    CString str;

                                    shAddErrors = *(short *)pcBuf;
                                    shAddErrors = ntohs(shAddErrors);
                                    pcBuf += 2;
                                    str.Format("%d", shAddErrors);
                                    m_mapStatistics["Unique Errors"] = _FSI_STL::string((LPCTSTR)str);

                                    sh = *(short *)pcBuf;
                                    sh = ntohs(sh);
                                    pcBuf += 2;
                                    str.Format("%d", sh);
                                    m_mapStatistics["Variables Found on Host"] = _FSI_STL::string((LPCTSTR)str);

                                    sh = *(short *)pcBuf;
                                    sh = ntohs(sh);
                                    pcBuf += 2;
                                    str.Format("%d", sh);
                                    m_mapStatistics["Variables Not Found on Host"] = _FSI_STL::string((LPCTSTR)str);

                                    sh = *(short *)pcBuf;
                                    sh = ntohs(sh);
                                    pcBuf += 2;
                                    str.Format("%d", sh);
                                    m_mapStatistics["Duplicate Variables Sent to Host"] = _FSI_STL::string((LPCTSTR)str);

                                    sh = *(short *)pcBuf;
                                    sh = ntohs(sh);
                                    pcBuf += 2;
                                    str.Format("%d", sh);
                                    m_mapStatistics["Variables Exceeded Buffer"] = _FSI_STL::string((LPCTSTR)str);

                                    sh = *(short *)pcBuf;
                                    sh = ntohs(sh);
                                    pcBuf += 2;
                                    str.Format("%d", sh);
                                    m_mapStatistics["Variables Exceeded Max Variables"] = _FSI_STL::string((LPCTSTR)str);

                                    sh = *(short *)pcBuf;
                                    sh = ntohs(sh);
                                    pcBuf += 2;
                                    str.Format("%d", sh);
                                    m_mapStatistics["Variables Size Mismatch"] = _FSI_STL::string((LPCTSTR)str);

                                    int i = 0;
                                    int j = 0;
                                    unsigned char ucError;
                                    _FSI_STL::map<_FSI_STL::string, CVariableData*>::iterator merrIt;
                                    while (i < shAddErrors && 
                                           (pcBuf + 3 - m_CommandReceive) < IOS_MAX_SEND_BUFFER)
                                    {
                                        sh = *(short *)pcBuf;
                                        sh = ntohs(sh);
                                        pcBuf += 2;

                                        ucError = *(unsigned char *)pcBuf;
                                        pcBuf++;

                                        if (sh < m_mapVarName2Data.size())
                                        {
                                            merrIt = m_mapVarName2Data.begin();
                                            while ((*merrIt).second->ID() != sh && 
                                                   merrIt != m_mapVarName2Data.end())
                                            {
                                                merrIt++;
                                            }

                                            if (merrIt != m_mapVarName2Data.end())
                                            {
                                                (*merrIt).second->HostError(ucError);

                                                if ((ucError & NOT_FOUND) > 0)
                                                {
                                                    m_mapStatistics["NF - " + (*merrIt).first] = _FSI_STL::string("Not Found");
                                                }

                                                if ((ucError & BUFFER_EXCEEDED) > 0)
                                                {
                                                    m_mapStatistics["BE - " + (*merrIt).first] = _FSI_STL::string("> Buffer");
                                                }

                                                if ((ucError & MAX_VAR_EXCEEDED) > 0)
                                                {
                                                    m_mapStatistics["MVE - " + (*merrIt).first] = _FSI_STL::string("> Max Var");
                                                }

                                                if ((ucError & DUPLICATE_VARIABLE) > 0)
                                                {
                                                    m_mapStatistics["DUP - " + (*merrIt).first] = _FSI_STL::string("Duplicate");
                                                }

                                                if ((ucError & SIZE_MISMATCH) > 0)
                                                {
                                                    m_mapStatistics["SZM - " + (*merrIt).first] = _FSI_STL::string("Size !=");
                                                }
                                            }
                                        }

                                        i++;
                                    }
                                }
                                break;
                            default:
                                {
                                }
                                break;
                            };
                        }

                        // Break out of recv loop.
                        break;
                    }
                    else
                    {
                        bufR.buf += nBytesRead;
                    }                    
                }
                VirtualUnlock(m_CommandReceive, IOS_MAX_SEND_BUFFER);
            }

            if (m_bWritePending == true || !m_mapWriteData.empty())
            {
                bufS.buf = m_CommandSend;
                bufS.len = IOS_MAX_RECEIVE_BUFFER;
                int nBytesSent = 0;

                m_syncWriteData.Lock();
                if (!m_mapWriteData.empty() && m_bWritePending == false)
                {
                    memset(m_CommandSend, 0, sizeof(m_CommandSend));
                    pcSendBuffer = m_CommandSend;
                    _FSI_STL::map<void*, long int>::iterator mwdIt = m_mapWriteData.begin();
                    long int lSize = 0;

                    while(mwdIt != m_mapWriteData.end() && 
                          (lSize + (*mwdIt).second) <= IOS_MAX_RECEIVE_BUFFER) 
                    {
                        memcpy(pcSendBuffer, (*mwdIt).first, (*mwdIt).second);

                        pcSendBuffer += (*mwdIt).second;
                        lSize += (*mwdIt).second;

                        delete [] (*mwdIt).first;
                        m_mapWriteData.erase(mwdIt);
                        mwdIt = m_mapWriteData.begin();
                    }
                }
                m_syncWriteData.Unlock();

                while (1)
                {
                    if ((nBytesSent = send(socketConnect, bufS.buf, 
                                                bufS.len, 0)) == SOCKET_ERROR)
                    {
                        shutdown(socketConnect, SD_BOTH);
                        closesocket(socketConnect);
                        m_bConnected = false;
                        m_syncWriteData.Lock();
                        if (!m_mapWriteData.empty())
                        {
                            _FSI_STL::map<void*, long int>::iterator mwdIt = m_mapWriteData.begin();

                            while(mwdIt != m_mapWriteData.end()) 
                            {
                                delete [] (*mwdIt).first;
                                m_mapWriteData.erase(mwdIt);
                                mwdIt = m_mapWriteData.begin();
                            }
                        }
                        m_syncWriteData.Unlock();
                        ResetStatistics();

                        bReconnect = true;
                	    socketConnect = socket(AF_INET, SOCK_STREAM, 0);

                        ulOffset    = 0;
                        moffIt      = m_mapVarName2Data.begin();
                        moffendIt   = m_mapVarName2Data.end();
                        while (moffIt != moffendIt)
                        {
                            (*moffIt).second->Offset(ulOffset);
                            ulOffset += variant.Size((*moffIt).second->Type()) * (*moffIt).second->ArrayLength();
                            moffIt++;
                        }

                        if (CCommsShared::m_pLogSystemInterface != NULL)
                        {
                            CCommsShared::m_pLogSystemInterface->AddMessage(_FSI_STL::string("IOS"),
                                _FSI_STL::string("IOS communications closed - send socket error."));
                        }

                        break;
                    }

                    if (nBytesSent == 0)
                    {
                        break;
                    }

                    bufS.len -= nBytesSent;

                    if (bufS.len <= 0)
                    {
                        m_bWritePending = false;
                        memset(m_CommandSend, 0, sizeof(m_CommandSend));
                        break;
                    }
                    else
                    {
                        bufS.buf += nBytesSent;
                    }
                }
            }
        }
    }

    return 0;
}

/////////////////////////////////////////////////////////////////////////////
//
// void CFSISuiteCommsSystemInterface::Decode()
//
// Inputs           : char* pcData - pointer to the data to decode.
//                    unsigned int nBufferSize - the amount of data pointer to
//                          by pcData.
//
// Return Values    : None.
//
// Date             : 21 October 2000
// 
// Engineer         : Billy Baker
//
// Description      : Decode() was added so that the common code in 
//                    CFSISuiteCommsSystemInterface::ReadData and
//                    CDebriefCommsSysteInterface::ReadData could be combined.
//                    The purpose of the method is to take network byte data
//                    and change it to the machine ordering.  8 byte values
//                    are not treated as two 4 but as a full 8.
//
/////////////////////////////////////////////////////////////////////////////
void CFSISuiteCommsSystemInterface::Decode(char* pcData, unsigned int nBufferSize)
{
    CVariableData* pVarData = NULL;
    CVariant* pVariant;

    _FSI_STL::map<_FSI_STL::string, CVariant*>::iterator mvIt = NULL;
    _FSI_STL::map<_FSI_STL::string, CVariant*>::iterator mvendIt = NULL;
    _FSI_STL::map<_FSI_STL::string, CVariableData*>::iterator mIt = NULL;
    _FSI_STL::map<_FSI_STL::string, CVariableData*>::iterator mendIt = NULL;
    _FSI_STL::list<CRange*>::iterator lrIt = NULL;
    _FSI_STL::list<CRange*>::iterator lrendIt = NULL;

    int nOffset;
    int nArrayLength;
    int nType;

    // Step through only the CVariants and give the value
    // from simulation to the CVariant.
    mvIt    = m_mapVarName2Variant.begin();
    mvendIt = m_mapVarName2Variant.end();
    unsigned short ushSize          = 0;
    unsigned char  ucElementSize    = 0;
    while (mvIt != mvendIt)
    {
        pVarData        = m_mapVarName2Data[(*mvIt).first];
        if ((*mvIt).second          != NULL && 
            pVarData->HostError()   == 0)
        {
            // There is a CVariant and there was not 
            // a host error for the variable.
            nOffset         = pVarData->Offset();
            nArrayLength    = pVarData->ArrayLength();

            nType           = pVarData->Type();

            pVariant        = (*mvIt).second;
            ucElementSize   = pVariant->Size(nType);

            ushSize         = ucElementSize * nArrayLength;

            if ((nOffset + ushSize) <= nBufferSize)
            {
                // There was enough data passed to this method
                // to allow reading of ushSize at an offset of
                // nOffset.
                if (nArrayLength == 1)
                {
                    // Not an array.  Copy the data to
                    // the correct sized variable.  Change
                    // the byte ordering and then give the
                    // data to a CVariant.
                   switch (ucElementSize)
                   {
                   case 2:
                       {
                           short sh;
                           sh = *(short *)(&(pcData[nOffset]));
                           sh = ntohs(sh);
                           pVariant->Value((char*)&sh, nType, 1);
                       }
                       break;
                   case 4:
                       {
                           long l;
                           l = *(long *)(&(pcData[nOffset]));
                           l = ntohl(l);
                           pVariant->Value((char*)&l, nType, 1);
                       }
                       break;
                   case 8:
                       {
                           char cN[8];
                           char cH[8];

                           *(double *)cN = *(double *)(&(pcData[nOffset]));
                           *(double *)cH = *(double *)(&(pcData[nOffset]));

                           cH[0] = cN[7];
                           cH[1] = cN[6];
                           cH[2] = cN[5];
                           cH[3] = cN[4];
                           cH[4] = cN[3];
                           cH[5] = cN[2];
                           cH[6] = cN[1];
                           cH[7] = cN[0];

                           pVariant->Value(cH, nType, 1);
                       }
                       break;
                   default:
                       {
                            pVariant->Value(&(pcData[nOffset]),
                                                  nType, 1);
                       }
                       break;
                   }
                }
                else
                {
                    // An array.  For each element of the array
                    // convert it and then copy it back into the
                    // passed buffer so as not to need a lot
                    // of extra memory.
                    char* pcStart = &(pcData[nOffset]);
                    char* pcArray = pcStart;
                    unsigned char ucSize =  ushSize / nArrayLength;
                    switch (ucSize)
                    {
                    case 2:
                        {
                            short sh;
                            long lAddress = (long)pcStart;
                            while (lAddress - (long)pcStart < ushSize)
                            {
                                sh = *(short *)(lAddress);

                                sh = ntohs(sh);

                                *(short *)pcArray = sh;

                                lAddress += 2;
                                pcArray  += 2;
                            }
                        }
                        break;
                    case 4:
                        {
                            long l;
                            long lAddress = (long)pcStart;
                            while (lAddress - (long)pcStart < ushSize)
                            {
                                l = *(long *)(lAddress);

                                l = ntohl(l);

                                *(long *)pcArray = l;

                                lAddress += 4;
                                pcArray  += 4;
                            }
                        }
                        break;
                    case 8:
                        {
                            char cN[8];
                            char cH[8];

                            long lAddress = (long)pcStart;
                            while (lAddress - (long)pcStart < ushSize)
                            {
                                *(double *)cN = *(double *)lAddress;
                                *(double *)cH = *(double *)lAddress;

                                cH[0] = cN[7];
                                cH[1] = cN[6];
                                cH[2] = cN[5];
                                cH[3] = cN[4];
                                cH[4] = cN[3];
                                cH[5] = cN[2];
                                cH[6] = cN[1];
                                cH[7] = cN[0];

                                *(double *)pcArray = *(double *)cH;

                                lAddress += 8;
                                pcArray  += 8;
                            }
                        }
                        break;
                    };

                    // Set the variant with the converted data in the passed
                    // buffer.
                    pVariant->Value(pcStart, nType, nArrayLength);
                }

                // If the variant is marked as a list, then add the
                // value to the variant's list.  This was originally used
                // for lat/lon etc data before the tolerance data class came
                // along.  It may not be needed any longer.
                if (pVariant->List() == true)
                    pVariant->AddValue(pVariant);

                // If the value of the variant changed...
                if (pVariant->WasChanged() == true)
                {
                    // And the variable has range data...
                    if (m_mapVarName2Ranges.find((*mvIt).first) != m_mapVarName2Ranges.end())
                    {
                        // Then run through the ranges evaluate each one.
                        // If a range is true then perform any action
                        // associated with the range (displaying cnia comes to
                        // mind).  If there is a logging class and the range
                        // also has a message, then add it to the log (switches
                        // being thrown).
                        lrIt    = m_mapVarName2Ranges[(*mvIt).first].begin();
                        lrendIt = m_mapVarName2Ranges[(*mvIt).first].end();

                        while (lrIt != lrendIt) 
                        {
                            if ((*lrIt)->Evaluate(*pVariant)  == true &&
                                (*lrIt)->NewValidRange()            == true)
                            {
                                if ((*lrIt)->ActionType() != NO_ACTION)
                                {
                                    (*lrIt)->PerformAction();
                                }

                                if (CCommsShared::m_pLogSystemInterface != NULL)
                                {
                                    if (!(*lrIt)->LogMessage().empty())
                                    {
                                        CCommsShared::m_pLogSystemInterface->AddMessage(_FSI_STL::string("IOS"), 
                                                                                        (*lrIt)->LogMessage());
                                    }
                                }
                            }

                            lrIt++;
                        }
                    }
                }
            }
        }

        mvIt++;
    }
}


/////////////////////////////////////////////////////////////////////////////
//
// void CFSISuiteCommsSystemInterface::ReadData()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 09 February 1999
// 
// Engineer         : Billy Baker
//
// Description      : ReadData() is a generic name used for a timer callback
//                    function.  Each comms system interface derived class
//                    should have a method used for passing data from 
//                    simulation on to the CVariants.  Then UpdateComms should
//                    be called to get the CCommsActions to update the
//                    graphical elements.  Be sure to use the CCriticalSection
//                    m_sync with Lock and Unlock to prevent a page change from
//                    deleting memory that needs to be written to.
//
/////////////////////////////////////////////////////////////////////////////
void CFSISuiteCommsSystemInterface::ReadData()
{
    // Read all of the data.
    m_sync.Lock();

    char *m_cReceiveBuffer = m_CommandReceive;
    m_cReceiveBuffer += 2;

    _FSI_STL::map<_FSI_STL::string, CVariableData*>::iterator mIt = NULL;
    _FSI_STL::map<_FSI_STL::string, CVariableData*>::iterator mendIt = NULL;

    char* pPos              = m_pcDebriefData;
    CVariableData* pVarData = NULL;
    int nAmountOfData;

    // If this is a pass that should record debrief data,
    // then step though the list of debrief variables and 
    // place each simulation variable into the data block to
    // be recorded.
    if (m_ucDebriefUpdatePass >= m_ucDebriefRatio && 
        !m_mapVarName2Debrief.empty()  && m_bRecordDebrief)
    {
        mIt     = m_mapVarName2Debrief.begin();
        mendIt  = m_mapVarName2Debrief.end();
        memset(m_pcDebriefData, 0, m_ulDebriefBufferSize);
        while (mIt != mendIt)
        {
            // Get the variable data.
            pVarData = (*mIt).second;

            // Compute the size of data to copy from the buffer
            // to the debrief buffer.
            nAmountOfData = CVariant::Size(pVarData->Type()) * pVarData->ArrayLength();

            // Copy the data to the debrief buffer.
            memcpy(pPos, m_cReceiveBuffer + pVarData->Offset(), nAmountOfData);

            // Move the debrief pointer to the next starting point
            // to copy data.
            pPos += nAmountOfData;

            mIt++;
        }

        if (m_fileDebrief.m_hFile != CFile::hFileNull)
            m_fileDebrief.Write(m_pcDebriefData, m_ulDebriefBufferSize);

         CVariant CVar_mark;
         CCommsShared::GetLocalValue(CVar_mark,  _FSI_STL::string("mark"));
         bool  mark     =  (bool)CVar_mark;
         long  old_type =  CVar_mark.Type();
         CVar_mark.Value((bool)0);
         CVar_mark.ChangeType(old_type);
         CCommsShared::SetLocalValue(CVar_mark,  _FSI_STL::string("mark"), 0);

         if (mark)
         {
            static   int   which_mark  =  1;

            CVariant CVar_mission_time;
            CCommsShared::GetHostValue(CVar_mission_time,   _FSI_STL::string("mission_time"));
            long  mission_time   =  (long)CVar_mission_time;
            CString  CStr_mission_time;
            CStr_mission_time.Format("%d", mission_time);

            switch (which_mark)
            {
               case   1:
                  WritePrivateProfileString("Debrief Marks",   "Mark 1",         CStr_mission_time,   m_DebriefMarkFile);
                  WritePrivateProfileString("Debrief Marks",   "Mark 1 Valid",   "1",                 m_DebriefMarkFile);
                  break;

               case   2:
                  WritePrivateProfileString("Debrief Marks",   "Mark 2",         CStr_mission_time,   m_DebriefMarkFile);
                  WritePrivateProfileString("Debrief Marks",   "Mark 2 Valid",   "1",                 m_DebriefMarkFile);
                  break;

               case   3:
                  WritePrivateProfileString("Debrief Marks",   "Mark 3",         CStr_mission_time,   m_DebriefMarkFile);
                  WritePrivateProfileString("Debrief Marks",   "Mark 3 Valid",   "1",                 m_DebriefMarkFile);
                  break;

               case   4:
                  WritePrivateProfileString("Debrief Marks",   "Mark 4",         CStr_mission_time,   m_DebriefMarkFile);
                  WritePrivateProfileString("Debrief Marks",   "Mark 4 Valid",   "1",                 m_DebriefMarkFile);
                  break;

               case   5:
                  WritePrivateProfileString("Debrief Marks",   "Mark 5",         CStr_mission_time,   m_DebriefMarkFile);
                  WritePrivateProfileString("Debrief Marks",   "Mark 5 Valid",   "1",                 m_DebriefMarkFile);
                  break;

               case   6:
                  WritePrivateProfileString("Debrief Marks",   "Mark 6",         CStr_mission_time,   m_DebriefMarkFile);
                  WritePrivateProfileString("Debrief Marks",   "Mark 6 Valid",   "1",                 m_DebriefMarkFile);
                  break;

               case   7:
                  WritePrivateProfileString("Debrief Marks",   "Mark 7",         CStr_mission_time,   m_DebriefMarkFile);
                  WritePrivateProfileString("Debrief Marks",   "Mark 7 Valid",   "1",                 m_DebriefMarkFile);
                  break;

               case   8:
                  WritePrivateProfileString("Debrief Marks",   "Mark 8",         CStr_mission_time,   m_DebriefMarkFile);
                  WritePrivateProfileString("Debrief Marks",   "Mark 8 Valid",   "1",                 m_DebriefMarkFile);
                  break;

               case   9:
                  WritePrivateProfileString("Debrief Marks",   "Mark 9",         CStr_mission_time,   m_DebriefMarkFile);
                  WritePrivateProfileString("Debrief Marks",   "Mark 9 Valid",   "1",                 m_DebriefMarkFile);
                  break;

               case   10:
                  WritePrivateProfileString("Debrief Marks",   "Mark 10 ",       CStr_mission_time,   m_DebriefMarkFile);
                  WritePrivateProfileString("Debrief Marks",   "Mark 10 Valid",  "1",                 m_DebriefMarkFile);

                  // Disable the mark button.
                  CVariant  CVar_mark_enabled;
                  CCommsShared::GetLocalValue(CVar_mark_enabled,  _FSI_STL::string("mark_enabled"));
                  bool   mark  =  (bool)CVar_mark_enabled;
                  old_type     =  CVar_mark_enabled.Type();
                  CVar_mark_enabled.Value((bool)0);
                  CVar_mark_enabled.ChangeType(old_type);
                  CCommsShared::SetLocalValue(CVar_mark_enabled,  _FSI_STL::string("mark_enabled"), 0);
                  break;
            }
            which_mark++;
         }

        m_ucDebriefUpdatePass = 1;
    }
    else
        ++m_ucDebriefUpdatePass;

    // This must be after the copies from the receive buffer because
    // Decode will decode some data back into the receive buffer.
    Decode(m_cReceiveBuffer, IOS_MAX_SEND_BUFFER);

    // Invoke all of the callback functions.
    m_syncUpdateCallback.Lock();

    _FSI_STL::list<UpdateCallback>::iterator lucIt = m_listUpdateCallbacks.begin();
    while (lucIt != m_listUpdateCallbacks.end())
    {
        (*lucIt)();
        lucIt++;
    }
    m_syncUpdateCallback.Unlock();

    // See about sending the CVariant values to the grapical elements.
    UpdateComms();

    m_sync.Unlock();
}

/////////////////////////////////////////////////////////////////////////////
//
// void CFSISuiteCommsSystemInterface::WriteData()
//
// Inputs           : CVariant* pVariant - the value to write to simulation.
//                    string& rstlStrVariableName - the variable name to write
//                                                  the value to.
//
// Return Values    : None.
//
// Date             : 09 February 1999
//
// Engineer         : Billy Baker
//
// Description      : WriteData() will be called from 
//                    CCommsAction::OnLButtonUp() which is called whenever a
//                    user action is performed on a graphical element--mouse
//                    click, space bar press, enter key press, etc.
//
/////////////////////////////////////////////////////////////////////////////
void CFSISuiteCommsSystemInterface::WriteData(CVariant* pVariant, 
                                              CVariableData* pVarData)
{
    if (pVariant == NULL)
    {
        return;
    }

    if (pVarData == NULL)
    {
        return;
    }

    char *pcSendBuffer = new char[IOS_MAX_RECEIVE_BUFFER];
    memset(pcSendBuffer, 0, IOS_MAX_RECEIVE_BUFFER);
    long int lSize = 0;

    // Fill the commandSend buffer
    short shID = CHANGE_VARIABLE;
    shID = htons(shID);
    *(short *)pcSendBuffer = shID;
    lSize += sizeof(short);

    // Put the ID of the variable to change
    unsigned short ushIndex = pVarData->ID();
    ushIndex = htons(ushIndex);
    *(unsigned short *)(pcSendBuffer + lSize) = ushIndex;
    lSize += sizeof(unsigned short);

    // Basic type size 
    unsigned short ushLength        = pVariant->Size(pVarData->Type());

    // Will have actual length of variant data
    unsigned short ushVariantLength = ushLength;

    // Size of one element
    unsigned char ucElementSize     = ushLength;

    long int lOffset = 0;
    if (pVarData->ArrayOffset() == -1)
    {
        // A full array is going to the host. 
        // Increase the length of data to the host by multiplying
        // by the array length as set in the variables file.
        // Increase the length of the data in the variant
        // by the length of the variant.  Necessary because,
        // for example, a string/character array may not have 4
        // characters when the array is 16.  Thus, only the 4
        // characters need to be copied to the buffer with the
        // rest of the space being 0.
        ushLength           *= pVarData->ArrayLength();
        ushVariantLength    *= pVariant->Length();
    }
    else
    {
        // A single value.  Get the offset from the beginning
        // of the array that will be changed.
        lOffset = pVarData->ArrayOffset();
    }

    // The data from the variant cannot exceed the length
    // as defined in the variables file.
    ushVariantLength = __min(ushLength, ushVariantLength);

    // Set the length of data to send to the host.
    *(unsigned short *)(pcSendBuffer + lSize) = htons(ushLength);
    lSize += sizeof(unsigned short);

    if (pVariant->CreateVar() != NULL)
    {
        char* pcStart = pcSendBuffer + lSize;
        char* pcArray = pcStart;
        CVariant variant;
        switch (ucElementSize)
        {
        case 2:
            {
                short sh;
                long lAddress = (long)pcStart;
                while (lAddress - (long)pcStart < ushVariantLength)
                {
                    variant = (*pVariant)[lOffset];
                    sh = *(short*)variant.CreateVar();

                    sh = htons(sh);

                    *(short *)pcArray = sh;

                    lAddress += 2;
                    pcArray  += 2;
                    lOffset++;
                }
            }
            break;
        case 4:
            {
                long l;
                long lAddress = (long)pcStart;

                while (lAddress - (long)pcStart < ushVariantLength)
                {
                    variant = (*pVariant)[lOffset];
                    l = *(long*)variant.CreateVar();

                    l = htonl(l);

                    *(long *)pcArray = l;

                    lAddress += 4;
                    pcArray  += 4;
                    lOffset++;
                }
            }
            break;
        case 8:
            {
                char cN[8];
                char cH[8];

                long lAddress = (long)pcStart;
                while (lAddress - (long)pcStart < ushVariantLength)
                {
                    variant = (*pVariant)[lOffset];
                    *(double *)cN = *(double*)variant.CreateVar();
                    *(double *)cH = *(double *)cN;

                    cN[0] = cH[7];
                    cN[1] = cH[6];
                    cN[2] = cH[5];
                    cN[3] = cH[4];
                    cN[4] = cH[3];
                    cN[5] = cH[2];
                    cN[6] = cH[1];
                    cN[7] = cH[0];

                    *(double *)pcArray = *(double *)cN;

                    lAddress += 8;
                    pcArray  += 8;
                    lOffset++;
                }
            }
            break;
        default:
            {
                memcpy(pcSendBuffer + lSize, pVariant->CreateVar(), ushVariantLength);
            }
            break;
        };
    }

    lSize += ushLength;

    lOffset = 0;
    if (pVarData->ArrayOffset() != -1)
    {
        // A single element is going.  Change the
        // offset from the start of the array to 
        // the offset that was set in the variable data.
        lOffset = pVarData->ArrayOffset();
    }
    lOffset = htonl(lOffset);
    *(unsigned long int *)(pcSendBuffer + lSize) = lOffset;
    lSize += sizeof(lOffset);

    lOffset = htonl(0);
    *(unsigned long int *)(pcSendBuffer + lSize) = lOffset;
    lSize += sizeof(lOffset);

    m_syncWriteData.Lock();
    m_mapWriteData[pcSendBuffer] = lSize;
    m_syncWriteData.Unlock();
}

void CFSISuiteCommsSystemInterface::AddData(CVariableData* pVarData)
{
    char *pcSendBuffer = new char[IOS_MAX_RECEIVE_BUFFER];
    memset(pcSendBuffer, 0, IOS_MAX_RECEIVE_BUFFER);
    long int lSize = 0;

    // Fill the commandSend buffer
    short shID = ADD_VARIABLE;
    shID = htons(shID);
    *(short *)pcSendBuffer = shID;
    lSize += sizeof(short);

    // Put the ID of the variable to change
    unsigned short ushIndex = pVarData->ID();
    ushIndex = htons(ushIndex);
    *(unsigned short *)(pcSendBuffer + lSize) = ushIndex;
    lSize += sizeof(unsigned short);

    // Basic type size 
    unsigned short ushLength        = strlen(pVarData->SimVarName().c_str());
    ushLength = htons(ushLength);
    *(unsigned short *)(pcSendBuffer + lSize) = ushLength;
    lSize += sizeof(unsigned short);

    // symbol name
    memcpy(pcSendBuffer + lSize, pVarData->SimVarName().c_str(), 
           strlen(pVarData->SimVarName().c_str()));
    lSize += strlen(pVarData->SimVarName().c_str());

    // size that the IOS expects
    CVariant var;
    unsigned short ushSize = var.Size(pVarData->Type()) * pVarData->ArrayLength();
    ushSize = htons(ushSize);
    *(unsigned short *)(pcSendBuffer + lSize) = ushSize;
    lSize += sizeof(unsigned short);

    m_syncWriteData.Lock();
    m_mapWriteData[pcSendBuffer] = lSize;
    m_syncWriteData.Unlock();
}
/////////////////////////////////////////////////////////////////////////////
//
// void CFSISuiteCommsSystemInterface::Start()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 09 February 1999
//
// Engineer         : Billy Baker
//
// Description      : Start() can be called at any time but must be 
//                    called after the loading of variables.  The call will
//                    be made when the first CCommsAction is created or prior
//                    to that when the COMMS DLL is loaded and initialized.
//                    Start() is responsible for setting up the mechanism for
//                    reading and writing--possibly the creation of a socket.
//
/////////////////////////////////////////////////////////////////////////////
void CFSISuiteCommsSystemInterface::Start()
{
    CCommsSystemInterface::Start();

    // Start a timer.
    int nCount;
	WSADATA			WSAData;

	if((nCount = WSAStartup(MAKEWORD(2,2), &WSAData)) != 0)
	{
		printf("WSAStartup error %d.\n", nCount);
		return;
	}

	PHOSTENT		pHostEnt;

	pHostEnt = gethostbyname(m_stlStrMachineName.c_str());
    if (pHostEnt != NULL)
    {
        memset(&soiAddressServer, 0, sizeof(SOCKADDR_IN));
	    memcpy((char *)& (soiAddressServer.sin_addr), pHostEnt->h_addr, pHostEnt->h_length);
	    soiAddressServer.sin_port = htons((unsigned short)m_ulPort);
	    soiAddressServer.sin_family = PF_INET;

        m_pCommsThread = AfxBeginThread(ThreadFunc, 
                                        (struct sockaddr*)&(soiAddressServer),
                                        THREAD_PRIORITY_TIME_CRITICAL,
                                        0, CREATE_SUSPENDED);
        CreatePipe(&m_hPipeRead, &m_hPipeWrite, NULL, 0);

        if (m_pCommsThread != NULL)
        {
            m_pCommsThread->m_bAutoDelete = false;

            m_pCommsThread->ResumeThread();

            m_bStarted = true;
        }
    }
}

/////////////////////////////////////////////////////////////////////////////
//
// void CFSISuiteCommsSystemInterface::Stop()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 09 February 1999
//
// Engineer         : Billy Baker
//
// Description      : Stop() can be called at any time but must be 
//                    called before the current instance of a comms 
//                    system interface derived class is deleted. The base
//                    class must be called after making sure that no addtional
//                    data will be read and have to be processed.
//
/////////////////////////////////////////////////////////////////////////////
void CFSISuiteCommsSystemInterface::Stop()
{
    // Stop listening/reading.
    if (m_pCommsThread != NULL)
    {
        // The comms thread will not auto delete itself because it should
        // run until the comms library is unloaded.  Thus, the comms thread
        // must be deleted.
        DWORD dwData = 1;
        DWORD dwBytesWritten;

        WriteFile(m_hPipeWrite, &dwData, sizeof(dwData), &dwBytesWritten, NULL);
        CloseHandle(m_hPipeWrite);

        WaitForSingleObject(m_pCommsThread->m_hThread, INFINITE);
        delete m_pCommsThread;
    }

    shutdown(socketConnect, SD_BOTH);
	closesocket(socketConnect);
    m_bConnected = false;

    WSACleanup();

    // Free data in the base class's data structures.
    CCommsSystemInterface::Stop();

    m_bStarted = false;
}

void CFSISuiteCommsSystemInterface::AddVariable(const _FSI_STL::string& stlStrVariable, 
                                                CVariableData& varData,
                                                _FSI_STL::list<CRange>& listRanges)
{
    if (m_mapVarName2Data.find(stlStrVariable) != m_mapVarName2Data.end())
    {
        return;
    }

    CVariableData* pVarData = new CVariableData;
    if (pVarData == NULL)
    {
        return;
    }

    CVariant var;
    *pVarData = varData;
    pVarData->ID(m_mapVarName2Data.size());
    _FSI_STL::map<_FSI_STL::string, CVariableData*>::iterator mbIt =
        m_mapVarName2Data.begin();
    _FSI_STL::map<_FSI_STL::string, CVariableData*>::iterator mbendIt =
        m_mapVarName2Data.end();
    long lOffset = 0;
    while (mbIt != mbendIt)
    {
        if (lOffset <= (*mbIt).second->Offset())
        {
            lOffset = (*mbIt).second->Offset() + var.Size((*mbIt).second->Type()) * (*mbIt).second->ArrayLength();
        }

        mbIt++;
    }

    pVarData->Offset(lOffset);

    m_mapVarName2Data[stlStrVariable] = pVarData;

    m_mapHostToIOSAlias[varData.SimVarName()] = stlStrVariable;

    if (m_bRecordDebrief == true && varData.Debrief() == true)
    {
        // Since this variable is listed as being
        // a debrief variable, add it to the map of
        // debrief data.
        if (m_mapVarName2Debrief.find(stlStrVariable) != m_mapVarName2Debrief.end())
        {
            m_mapVarName2Debrief.erase(m_mapVarName2Debrief.find(stlStrVariable));
        }

        m_mapVarName2Debrief[stlStrVariable] = pVarData;
        m_ulDebriefBufferSize += CVariant::Size(pVarData->Type()) *
                                                pVarData->ArrayLength();
    }

    CRange* pRange = NULL;
    _FSI_STL::list<CRange>::iterator lIt    = listRanges.begin();
    _FSI_STL::list<CRange>::iterator lendIt = listRanges.end();
    while (lIt != lendIt)
    {
        pRange = new CRange;
        if (pRange != NULL)
        {
            *pRange = (*lIt);
            m_mapVarName2Ranges[stlStrVariable].push_back(pRange);
        }

        lIt++;
    }

//    AddData(pVarData);
}

void CFSISuiteCommsSystemInterface::ResetStatistics()
{
    m_mapStatistics.clear();
    CString str;

    // Constants are host sizes.  We display client sizes.
    str.Format("%d", IOS_MAX_RECEIVE_BUFFER);
    m_mapStatistics["Buffer to Host"] = _FSI_STL::string((LPCTSTR)str);
    str.Format("%d", IOS_MAX_SEND_BUFFER);
    m_mapStatistics["Buffer from Host"] = _FSI_STL::string((LPCTSTR)str);

    str = "N/A";
    m_mapStatistics["Variables Found on Host"]          = _FSI_STL::string((LPCTSTR)str);
    m_mapStatistics["Variables Not Found on Host"]      = _FSI_STL::string((LPCTSTR)str);
    m_mapStatistics["Duplicate Variables Sent to Host"] = _FSI_STL::string((LPCTSTR)str);
    m_mapStatistics["Variables Exceeded Buffer"]        = _FSI_STL::string((LPCTSTR)str);
    m_mapStatistics["Variables Exceeded Max Variables"] = _FSI_STL::string((LPCTSTR)str);
}