/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : FailureSummarySystemInterface.h
//
// Date             : 16 February 2000
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.4 $
//
// Description      : FailureSummarySystemInterface.h contains the 
//                    definition of the CFailureSummarySystemInterface class.  
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : _FSI_STL::string, _FSI_STL::map, _FSI_STL::list.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: FailureSummarySystemInterface.h $
// Revision 1.4  2000/06/08 06:50:19  billyb
// Added ToFailureString.
// Revision 1.3  2000/05/18 20:53:59  billyb
// Added methods for working with failure variables as
// specified in the variable definition file.
// Revision 1.2  2000/03/06 16:22:39  billyb
// Changed function signatures to eliminate warnings.
/////////////////////////////////////////////////////////////////////////////
#if !defined(_FAILURESUMMARYSYSTEMINTERFACE_H_)
#define _FAILURESUMMARYSYSTEMINTERFACE_H_

#ifdef COMMS
#define COMMSAPI __declspec( dllexport )
#else
#define COMMSAPI __declspec( dllimport )
#endif

#include <list>
#include <map>
#include <string>

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CIOAction;
class CVariant;
class CFailureSummaryAction;

enum eFAILURE_ITEMS
{
    UNKNOWN_FAILURE,
    CB,
    MALFUNCTION_ACTIVE,
    MALFUNCTION_ARMED,
    NAVAID_KILLED,
    TOTAL_TYPES_OF_FAILURE
};

typedef struct DESC_WITH_ORDER
{
    _FSI_STL::string    s_stlStrTime;
    _FSI_STL::string    s_stlStrItem;
    _FSI_STL::string    s_stlStrDesc;
    unsigned long int   s_ulOrder;
} DescWithOrder;

class COMMSAPI CFailureSummarySystemInterface
{
protected:
    int                     m_nFailedCBs;
    int                     m_nFailedMalfs_Active;
    int                     m_nFailedMalfs_Armed;
    int                     m_nFailedNavaids;

    unsigned long           m_ulOrder;

    bool                    m_bScreenUpdateNeeded;

    _FSI_STL::map<enum eFAILURE_ITEMS, _FSI_STL::map<_FSI_STL::string, DescWithOrder*> > m_mapFailedItems;
    _FSI_STL::map<long, DescWithOrder*> m_mapFailuresInOrder;

    _FSI_STL::list<CAction*> m_listActions;

    CCriticalSection        m_sync;

    static _FSI_STL::map<enum eFAILURE_ITEMS, _FSI_STL::map<CVariant*, _FSI_STL::string> > m_mapFailureVariables;
    void EvaluateFailure(enum eFAILURE_ITEMS eFailure, CVariant* pVariant, _FSI_STL::string& rstlStrData);

    void DumpAllFailuresToFile();

    static _FSI_STL::string m_stlStrFile;
    
public:
	CFailureSummarySystemInterface();
	virtual ~CFailureSummarySystemInterface();

    _FSI_STL::string Summary();

    void AddFailure(enum eFAILURE_ITEMS eFailureItem,
                    const _FSI_STL::string& stlStrItem, 
                    const _FSI_STL::string& stlStrDescription);

    void DeleteFailure(enum eFAILURE_ITEMS eFailureItem,
                       const _FSI_STL::string& stlStrItem,
                       const _FSI_STL::string& stlStrDescription);

    void DeleteFailuresOfType(enum eFAILURE_ITEMS eFailureItem);

    static long int ToFailureType(const _FSI_STL::string& rstlStrType);
    static _FSI_STL::string ToFailureString(const long int lType);

    void UpdateComms();

    static void AddFailureVariable(_FSI_STL::string& rstlStrType, _FSI_STL::string& rstlStrData, CVariant* pVariant);

    friend CFailureSummaryAction;
};

#endif // !defined(_FAILURESUMMARYSYSTEMINTERFACE_H_)
