#include "..\core\stdafx.h"
#include "FailureSummaryAction.h"

#include "FailureSummaryActionPage.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

/////////////////////////////////////////////////////////////////////////////
//
// CFailureSummaryAction::CFailureSummaryAction
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 16 February 2000
//
// Engineer         : Billy Baker
//
// Description      : Default constructor.  Sets the name of the widget.
//                    Adds the CFailureSummaryActionPage to the list of widget
//                    property pages.
/////////////////////////////////////////////////////////////////////////////
CFailureSummaryAction::CFailureSummaryAction()
{
    m_stlStrWidgetName = _FSI_STL::string("Failure_Summary_Action");

    m_listWidgetPropPages.push_back(CFailureSummaryActionPage::CreateObject);
}

/////////////////////////////////////////////////////////////////////////////
//
// CFailureSummaryAction::~CFailureSummaryAction
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 16 February 2000
//
// Engineer         : Billy Baker
//
// Description      : Default destructor.
//
/////////////////////////////////////////////////////////////////////////////
CFailureSummaryAction::~CFailureSummaryAction()
{
    if (m_pFailureSummarySystemInterface != NULL)
    {
        _FSI_STL::list<CAction*>::iterator lIt;
        lIt = _FSI_STL::find(m_pFailureSummarySystemInterface->m_listActions.begin(),
                             m_pFailureSummarySystemInterface->m_listActions.end(), this);

        if (lIt != m_pFailureSummarySystemInterface->m_listActions.end())
        {
            m_pFailureSummarySystemInterface->m_listActions.erase(lIt);
        }
    }
}

/////////////////////////////////////////////////////////////////////////////
//
// CWidget* CFailureSummaryAction::CreateObject()
//
// Inputs           : None.
//
// Return Values    : Address of a new instance of CFailureSummaryAction.
//
// Date             : 16 February 2000
//
// Engineer         : Billy Baker
//
// Description      : CreateObject() is a common framework method that must be
//                    implemented by each CWidget derived class.  The main
//                    application associates the name of this widget with this
//                    static CreateObject method so that a new object can be
//                    created without linking against the library that contains
//                    this class.
//
/////////////////////////////////////////////////////////////////////////////
CWidget* CFailureSummaryAction::CreateObject()
{
    return new CFailureSummaryAction();
}

/////////////////////////////////////////////////////////////////////////////
//
// void CFailureSummaryAction::Initialize()
//
// Inputs           : CXMLWidget*& rpXMLWidget - pointer to return a new 
//                                               instance of a CXMLWidget.
//                    CWnd* pWnd - the parent of this widget.
//                    const long lId - the control ID.
//                    bool bEditMode - whether this widget is being created 
//                                     in the editor or the runtime.
//
// Return Values    : None.
//
// Date             : 16 February 2000
//
// Engineer         : Billy Baker
//
// Description      : Initialize() is a common framework method that must be
//                    implemented by each CWidget derived class.  Besides 
//                    standard initialization code for a CAction and CWidget
//                    derived class, the CCommsSystemInterface derived class
//                    is started if it has not already been started. 
//
/////////////////////////////////////////////////////////////////////////////
void CFailureSummaryAction::Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                                const long lId, bool bEditMode)
{
    // Call the base class.
    CWidget::Initialize(rpXMLWidget,pWnd, lId, bEditMode);

    // Set the action and widget pointers.
    m_pAction = this;
    m_pWidget = (CWidget*)this;

    if (rpXMLWidget != NULL)
    {
        m_pIOActionXMLWidget = m_pXMLWidget;
        ResetProperties();
    }

    if (m_bEditing == false && m_pFailureSummarySystemInterface != NULL)
    {
        m_pFailureSummarySystemInterface->m_sync.Lock();
        m_pFailureSummarySystemInterface->m_listActions.push_back(this);
        m_pFailureSummarySystemInterface->m_bScreenUpdateNeeded = true;
        m_pFailureSummarySystemInterface->m_sync.Unlock();
    }
}

/////////////////////////////////////////////////////////////////////////////
//
// void CFailureSummaryAction::ResetProperties()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 16 February 2000
//
// Engineer         : Billy Baker
//
// Description      : ResetProperties() is a common framework method that 
//                    should be implemented by each CWidget derived class.  
//                    ResetProperties is called when a new instance is created
//                    as well as when the widget props dialog is used to change
//                    properties. 
//
/////////////////////////////////////////////////////////////////////////////
void CFailureSummaryAction::ResetProperties()
{
    CWidget::ResetProperties();
    CIOAction::ResetProperties();
}

/////////////////////////////////////////////////////////////////////////////
//
// void CFailureSummaryAction::OnUpdate()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 16 February 2000
//
// Engineer         : Billy Baker
//
// Description      : OnUpdate() is a common framework method for CAction
//                    derived classes.  Its purpose is to send a new value
//                    to its parent graphical widget.  OnUpdate should 
//                    generally be called by some other class than the parent 
//                    graphical element.
//
/////////////////////////////////////////////////////////////////////////////
void CFailureSummaryAction::OnUpdate()
{
    // Make sure there is a Variant will a value to send to the parent
    // graphical widget.
    if (m_bDeleting == true)
        return;

    if (m_pFailureSummarySystemInterface == NULL)
        return;

    if (CWidget::IsValidAddress(m_pParentWidget) != VALID)
        return;

    CString strElementVar = CString(m_stlStrElementVar.c_str());

    CString message("");

    CVariant   tmpVar;
    int        count =  0;
    _FSI_STL::map<long, DescWithOrder*>::reverse_iterator mIt;
    _FSI_STL::map<long, DescWithOrder*>::reverse_iterator mendIt;
    mIt     = m_pFailureSummarySystemInterface->m_mapFailuresInOrder.rbegin();
    mendIt  = m_pFailureSummarySystemInterface->m_mapFailuresInOrder.rend();

    DescWithOrder* pDWO;

    while (mIt != mendIt && count < (m_lElement - 1))
    {
        pDWO = (*mIt).second;

        if (message != "")
            message =  CString(pDWO->s_stlStrTime.c_str()) + "     " + 
                       CString(pDWO->s_stlStrItem.c_str()) +  
                       CString(pDWO->s_stlStrDesc.c_str()) + "\n" +
                       message;
        else
            message =  CString(pDWO->s_stlStrTime.c_str()) + "     " + 
                       CString(pDWO->s_stlStrItem.c_str()) +  
                       CString(pDWO->s_stlStrDesc.c_str());

        count++;

        mIt++;
    }

    if (message != "")
        message += "\n" + CString(m_pFailureSummarySystemInterface->Summary().c_str());
    else
        message = CString(m_pFailureSummarySystemInterface->Summary().c_str());

    m_variant.Value(_FSI_STL::string((LPCTSTR)message));

    m_ChangeValue.Variant(&m_variant);

    m_ChangeValue.UseRange(false);

    m_pParentWidget->ChangeValue(strElementVar, &m_ChangeValue);

    if (m_pCommsSystemInterface != NULL)
    {
        m_pCommsSystemInterface->ToRefresh(m_pParentWidget);
    }
}


CFailureSummarySystemInterface* CFailureSummaryAction::FailureSummarySystemInterface()
{
    return m_pFailureSummarySystemInterface;
}

void CFailureSummaryAction::FailureSummarySystemInterface(const CFailureSummarySystemInterface* pFSSI)
{
    m_pFailureSummarySystemInterface = (CFailureSummarySystemInterface*)pFSSI;
}
