/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : DebriefCommsSystemInterface.h
//
// Date             : 13 February 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.2 $
//
// Description      : DebriefCommsSystemInterface.h contains the 
//                    definition of the CDebriefCommsSystemInterface
//                    class.  This class is responsible for reading all 
//                    of the data for a debriefing data file and updating 
///                   the controls on the screen based on a timer.  This 
//                    class will open the file and strip out the description 
//                    of the debriefing data.  This data is then read in 
//                    by CFSISuiteCommsSystemInterface::LoadVariables.  
//                    No updates will occur until a page is opened to 
//                    display the values.  Likewise, playback will end 
//                    when the end of the data is reached.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : CCommsAction, CFSISuiteCommsSystemInterface, 
//                    CVariableData, CCommsSystemInterface, map, 
//                    iterator, string, CVariant, CFile.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3
//                                          Microsoft Windows NT 5.0
//
//                    Compiler(s) - Visual C++ 5.0 with VisC++ service pack 3
//                                  Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: DebriefCommsSystemInterface.h $
// Revision 1.2  2000/03/06 16:41:27  billyb
// Changed function signatures to eliminate warnings.
// Changed update mechanism to match other comms 
// protocols.
// Revision 1.1  1999/08/24 18:24:51  billyb
// Initial Revision
//
#if !defined(_DEBRIEFCOMMSSYSTEMINTERFACE_H_)
#define _DEBRIEFCOMMSSYSTEMINTERFACE_H_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "FSISuiteCommsSystemInterface.h"

class CDebriefCommsSystemInterface : public CFSISuiteCommsSystemInterface  
{
private:
    // Pointer to the current element of the debriefing data to display.
    static char*               m_pcCurrentDebriefData;

    // Pointer to the end of the data.  The place to stop.
    static char*               m_pcEndDebriefData;

protected:
    static UINT                   ThreadFunc(LPVOID lParam);

public:
	CDebriefCommsSystemInterface();
	virtual ~CDebriefCommsSystemInterface();

    static CCommsSystemInterface* CreateComms();

    virtual void LoadVariables(const _FSI_STL::string& rstlStrVariablesFile);

    static void ReadData();

    virtual void Start();
    virtual void Stop();

    CString m_DebriefMarkFile;
    static  int   m_int_marks[10];
};

#endif // !defined(_DEBRIEFCOMMSSYSTEMINTERFACE_H_)
