/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : DebriefCommsSystemInterface.cpp
//
// Date             : 13 February 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.7 $
//
// Description      : DebriefCommsSystemInterface.cpp contains the 
//                    implementation of the CDebriefCommsSystemInterface
//                    class.  This class is responsible for reading all 
//                    of the data for a debriefing data file and updating 
///                   the controls on the screen based on a timer.  This 
//                    class will open the file and strip out the description 
//                    of the debriefing data.  This data is then read in 
//                    by CFSISuiteCommsSystemInterface::LoadVariables.  
//                    No updates will occur until a page is opened to 
//                    display the values.  Likewise, playback will end 
//                    when the end of the data is reached.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : CCommsAction, CFSISuiteCommsSystemInterface, 
//                    CVariableData, CCommsSystemInterface, map, 
//                    iterator, string, CVariant, CFile.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3
//                                          Microsoft Windows NT 5.0
//
//                    Compiler(s) - Visual C++ 5.0 with VisC++ service pack 3
//                                  Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: DebriefCommsSystemInterface.cpp $
// Revision 1.7  2000/06/16 20:47:14  billyb
// Fixed reading of debriefing data for arrays.
// Added same code as FSISuiteCommsSystemInterface
// to prevent reading from the file until all of the DLLs have
// been loaded.
// Revision 1.6  2000/03/06 21:30:22  billyb
// Changed function signatures to eliminate warnings.
// Changed timer to thread like other protocols use.
// Revision 1.5  2000/01/27 20:05:10  billyb
// Removed memsets.
// Revision 1.4  2000/01/27 07:58:36  billyb
// Added support for arrays.
// Revision 1.3  1999/11/04 19:55:33  billyb
// Changed for loop to while and added variable for map end()
// call to decrease calls to end().  Changed size() call to empty()
// since size() is a calculation and empty() is an accessor for
// a member variable.
// Revision 1.2  1999/08/24 21:31:36  billyb
// Added code to check for a debrief file header at the beginning of the file.
// If not a debrief file, then a conditional was needed in ReadData to make sure
// that a NULL dataset was not trying to be read.
//
#include "..\core\stdafx.h"
#include <winsock2.h>
#include "DebriefCommsSystemInterface.h"
#include "CommsAction.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

char*               CDebriefCommsSystemInterface::m_pcEndDebriefData = NULL;
char*               CDebriefCommsSystemInterface::m_pcCurrentDebriefData = NULL;
int                 CDebriefCommsSystemInterface::m_int_marks[10];
/////////////////////////////////////////////////////////////////////////////
//
// CDebriefCommsSystemInterface::CDebriefCommsSystemInterface()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 12 February 1999
//
// Engineer         : Billy Baker
//
// Description      : Default constructor.
//
/////////////////////////////////////////////////////////////////////////////
CDebriefCommsSystemInterface::CDebriefCommsSystemInterface(): 
                                        CFSISuiteCommsSystemInterface()
{
}

/////////////////////////////////////////////////////////////////////////////
//
// CDebriefCommsSystemInterface::~CDebriefCommsSystemInterface()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 12 February 1999
//
// Engineer         : Billy Baker
//
// Description      : Default destructor.
//
/////////////////////////////////////////////////////////////////////////////
CDebriefCommsSystemInterface::~CDebriefCommsSystemInterface()
{
}

/////////////////////////////////////////////////////////////////////////////
//
// void CDebriefCommsSystemInterface::LoadVariables()
//                    
//
// Inputs           : string& rstlStrVariablesFile - the name of the file
//                                                   to read.
//
// Return Values    : None.
//
// Date             : 12 February 1999
//
// Engineer         : Billy Baker
//
// Description      : LoadVariables() is a abstract virtual method 
//                    defined in CCommsSystemInterface.  Its purpose is 
//                    to read a data file(s) to obtain information 
//                    about the variables on the simulation side.  For 
//                    the Debrief comms system interface, the XML definition
//                    of the variables recorded in the debriefing data is
//                    extracted and placed in a temporary file that is
//                    passed to CFSISuiteCommsSystemInterface::LoadVariables.
//                    m_bRecordDebriefing is set to false so that the debrief
//                    file will not be opened which would delete all of the
//                    data.  All of the debriefing data is read into the 
//                    m_pcDebriefData memory.
//
/////////////////////////////////////////////////////////////////////////////
void CDebriefCommsSystemInterface::LoadVariables(const _FSI_STL::string& rstlStrVariablesFile)
{
   m_ulDebriefBufferSize = 0;

   if (rstlStrVariablesFile != _FSI_STL::string(""))
   {
      try
      {
         m_fileDebrief.Open(rstlStrVariablesFile.c_str(), CFile::modeRead | CFile::shareDenyWrite);
      }
      catch (...)
      {
         CString errMsg;
         errMsg.Format("Debrief Error: trying to open [%s] for writing.", rstlStrVariablesFile.c_str());
         AfxMessageBox(errMsg);
      }

      CString  debriefFileName(rstlStrVariablesFile.c_str());
      m_DebriefMarkFile =  debriefFileName.Left(debriefFileName.ReverseFind('.') +  1) +  "ini";
      m_int_marks[0]    =  GetPrivateProfileInt("Debrief Marks",  "Mark 1",         0, m_DebriefMarkFile);
      m_int_marks[1]    =  GetPrivateProfileInt("Debrief Marks",  "Mark 2",         0, m_DebriefMarkFile);
      m_int_marks[2]    =  GetPrivateProfileInt("Debrief Marks",  "Mark 3",         0, m_DebriefMarkFile);
      m_int_marks[3]    =  GetPrivateProfileInt("Debrief Marks",  "Mark 4",         0, m_DebriefMarkFile);
      m_int_marks[4]    =  GetPrivateProfileInt("Debrief Marks",  "Mark 5",         0, m_DebriefMarkFile);
      m_int_marks[5]    =  GetPrivateProfileInt("Debrief Marks",  "Mark 6",         0, m_DebriefMarkFile);
      m_int_marks[6]    =  GetPrivateProfileInt("Debrief Marks",  "Mark 7",         0, m_DebriefMarkFile);
      m_int_marks[7]    =  GetPrivateProfileInt("Debrief Marks",  "Mark 8",         0, m_DebriefMarkFile);
      m_int_marks[8]    =  GetPrivateProfileInt("Debrief Marks",  "Mark 9",         0, m_DebriefMarkFile);
      m_int_marks[9]    =  GetPrivateProfileInt("Debrief Marks",  "Mark 10",        0, m_DebriefMarkFile);

      // Create variant and determind mark_?_valid variable types.
      CVariant CVar_mark_valid;
      CCommsShared::GetLocalValue(CVar_mark_valid,    _FSI_STL::string( "mark_1_valid" ));
      long  old_type =  CVar_mark_valid.Type();

      // Enable/Disable the mark buttons.
      CVar_mark_valid.Value((long)GetPrivateProfileInt("Debrief Marks", "Mark 1 Valid",   0, m_DebriefMarkFile));
      CVar_mark_valid.ChangeType(old_type);
      CCommsShared::SetLocalValue(CVar_mark_valid,    _FSI_STL::string( "mark_1_valid" ), 0);

      CVar_mark_valid.Value((long)GetPrivateProfileInt("Debrief Marks", "Mark 2 Valid",   0, m_DebriefMarkFile));
      CVar_mark_valid.ChangeType(old_type);
      CCommsShared::SetLocalValue(CVar_mark_valid,    _FSI_STL::string( "mark_2_valid" ), 0);

      CVar_mark_valid.Value((long)GetPrivateProfileInt("Debrief Marks", "Mark 3 Valid",   0, m_DebriefMarkFile));
      CVar_mark_valid.ChangeType(old_type);
      CCommsShared::SetLocalValue(CVar_mark_valid,    _FSI_STL::string( "mark_3_valid" ), 0);

      CVar_mark_valid.Value((long)GetPrivateProfileInt("Debrief Marks", "Mark 4 Valid",   0, m_DebriefMarkFile));
      CVar_mark_valid.ChangeType(old_type);
      CCommsShared::SetLocalValue(CVar_mark_valid,    _FSI_STL::string( "mark_4_valid" ), 0);

      CVar_mark_valid.Value((long)GetPrivateProfileInt("Debrief Marks", "Mark 5 Valid",   0, m_DebriefMarkFile));
      CVar_mark_valid.ChangeType(old_type);
      CCommsShared::SetLocalValue(CVar_mark_valid,    _FSI_STL::string( "mark_5_valid" ), 0);
   
      CVar_mark_valid.Value((long)GetPrivateProfileInt("Debrief Marks", "Mark 6 Valid",   0, m_DebriefMarkFile));
      CVar_mark_valid.ChangeType(old_type);
      CCommsShared::SetLocalValue(CVar_mark_valid,    _FSI_STL::string( "mark_6_valid" ), 0);

      CVar_mark_valid.Value((long)GetPrivateProfileInt("Debrief Marks", "Mark 7 Valid",   0, m_DebriefMarkFile));
      CVar_mark_valid.ChangeType(old_type);
      CCommsShared::SetLocalValue(CVar_mark_valid,    _FSI_STL::string( "mark_7_valid" ), 0);

      CVar_mark_valid.Value((long)GetPrivateProfileInt("Debrief Marks", "Mark 8 Valid",   0, m_DebriefMarkFile));
      CVar_mark_valid.ChangeType(old_type);
      CCommsShared::SetLocalValue(CVar_mark_valid,    _FSI_STL::string( "mark_8_valid" ), 0);

      CVar_mark_valid.Value((long)GetPrivateProfileInt("Debrief Marks", "Mark 9 Valid",   0, m_DebriefMarkFile));
      CVar_mark_valid.ChangeType(old_type);
      CCommsShared::SetLocalValue(CVar_mark_valid,    _FSI_STL::string( "mark_9_valid" ), 0);

      CVar_mark_valid.Value((long)GetPrivateProfileInt("Debrief Marks", "Mark 10 Valid",  0, m_DebriefMarkFile));
      CVar_mark_valid.ChangeType(old_type);
      CCommsShared::SetLocalValue(CVar_mark_valid,    _FSI_STL::string( "mark_10_valid"), 0);
   

      if (m_fileDebrief.m_hFile != CFile::hFileNull)
      {
         char  cHeader[ucDebriefHeaderSize];

         m_fileDebrief.Read(cHeader,   ucDebriefHeaderSize);

         if (strcmp(cHeader, cDebriefHeader) != 0)
         {
            m_fileDebrief.Close();
            return;
         }

         // Get the full file length
         unsigned long  int   ulFileLength   =  m_fileDebrief.GetLength();

         // Seek to the debrief rate.
         m_fileDebrief.Seek(-(int)sizeof(unsigned long int),   CFile::end);

         // Read the debrief rate and read the same rate for the host rate.
         m_fileDebrief.Read(&m_fDebriefRate, sizeof(float));
         m_fileDebrief.Read(&m_fRate,        sizeof(float));

         // Make sure that the screen update ratio gets set correctly.
         Rate(m_fRate);
         DebriefRate(m_fDebriefRate);
         ScreenUpdateRate(m_fScreenUpdateRate);


         // Seek to the size of the description.
         m_fileDebrief.Seek(-(int)(2   *  sizeof(unsigned long int)),   CFile::end);

         // Read the description size
         unsigned long  int   ulDescriptionLength;
         m_fileDebrief.Read(&ulDescriptionLength,  sizeof(unsigned long int));

         // Seek to the beginning of the description.
         m_fileDebrief.Seek(-(int)(ulDescriptionLength   +  3  *  sizeof(unsigned long int)),   CFile::end);

         // Create memory and read the description.  Then, output the description to a text file for reading by the parent
         // class' LoadVariables. Make sure that m_bRecordDebrief is false.
         m_bRecordDebrief     =  false;
         char  *pcDescription =  new   char[ulDescriptionLength];

         m_fileDebrief.Read(pcDescription, ulDescriptionLength);
         CString  strPath(rstlStrVariablesFile.c_str());
         if (strPath.ReverseFind('.') > -1)
         {
            strPath  =  strPath.Left(strPath.ReverseFind('.')  +  1) +  "fml";
         }

         CFile fileDescription;
         try
         {
            fileDescription.Open((LPCTSTR)strPath, CFile::modeWrite  |  CFile::modeCreate);
            fileDescription.Write(pcDescription,   ulDescriptionLength);
            fileDescription.Close();
         }
         catch (...)
         {
            AfxMessageBox("Problem creating variable file for debriefing data.");
         }

         delete   [] pcDescription;

         // Call parent to read the description file.
         CFSISuiteCommsSystemInterface::LoadVariables(_FSI_STL::string((LPCTSTR)strPath));

         // Get the size of the debrief data and create memory in m_pcDebriefData to read all of the into.
         m_ulDebriefBufferSize   =  ulFileLength   -  ulDescriptionLength  -  ucDebriefHeaderSize  -  3  *  sizeof(unsigned long int);

         m_pcDebriefData   =  new   char[m_ulDebriefBufferSize];
         m_fileDebrief.SeekToBegin();

         // Seek to the beginning of the data.
         m_fileDebrief.Seek(ucDebriefHeaderSize,   CFile::begin);

         m_fileDebrief.Read(m_pcDebriefData,       m_ulDebriefBufferSize);

         m_pcEndDebriefData      =  m_pcDebriefData   +  m_ulDebriefBufferSize;
         m_pcCurrentDebriefData  =  m_pcDebriefData;

         // Seek to the size of each element in the total buffer of debriefing data and reset the buffer size to the element size.
         m_fileDebrief.Seek(-(int)(3   *  sizeof(unsigned long int)),   CFile::end);
         m_fileDebrief.Read(&m_ulDebriefBufferSize,   sizeof(unsigned long int));

         m_fileDebrief.Close();
      }
   }
}

/////////////////////////////////////////////////////////////////////////////
//
// CCommsSystemInterface* CDebriefCommsSystemInterface::CreateComms()
//
// Inputs           : None.
//
// Return Values    : address of a new instance of 
//                    CFISSuiteCommsSystemInterface.
//
// Date             : 12 February 1999
//
// Engineer         : Billy Baker
//
// Description      : CreateComms() creates a new instance of
//                    CDebriefCommsSystemInterface.  Each CCommsSystemInterface
//                    derived class must implement CreateComms so that the
//                    comms protocol can be dynamically changed during 
//                    operation.  A name, like Debrief, is associated with
//                    a pointer to this method.  By storing pointers to 
//                    CreateComms methods, a large switch statement is not
//                    needed.
//
/////////////////////////////////////////////////////////////////////////////
CCommsSystemInterface* CDebriefCommsSystemInterface::CreateComms()
{
    return new CDebriefCommsSystemInterface;
}

UINT CDebriefCommsSystemInterface::ThreadFunc(LPVOID lParam)
{
    DWORD dwData = 0;
    DWORD dwBytesRead;
    DWORD dwBytesLeft;
    DWORD dwBytesLeftMsg;

    float fRate = *(float*)lParam;

    unsigned long int ulOffset = 0;
    _FSI_STL::map<_FSI_STL::string, CVariableData*>::iterator moffIt;
    _FSI_STL::map<_FSI_STL::string, CVariableData*>::iterator moffendIt;

    while (1)
    {
        while (!m_bInitComplete)
        {
            Sleep(1000);
            ulOffset    = 0;
            moffIt      = m_mapVarName2Data.begin();
            moffendIt   = m_mapVarName2Data.end();
            while (moffIt != moffendIt)
            {
                (*moffIt).second->Offset(ulOffset);
                ulOffset += CVariant::Size((*moffIt).second->Type()) * (*moffIt).second->ArrayLength();
                moffIt++;
            }
        }

        // Check the pipe to see if a shutdown has been sent.
        PeekNamedPipe(m_hPipeRead, &dwData, sizeof(dwData), &dwBytesRead, 
                      &dwBytesLeft, &dwBytesLeftMsg);

        if (dwData == 1)
        {
            CloseHandle(m_hPipeRead);
            break;
        }

        m_bConnected =  true;

        ReadData();
        Sleep(1000 / fRate);
    }

    return 0;
}

/////////////////////////////////////////////////////////////////////////////
//
// void CDebriefCommsSystemInterface::ReadData()
//
// Inputs           : HWND hWnd - timer callback specific
//                    UINT uiMsg - timer callback specific
//                    UINT idEvent - timer callback specific
//                    DWORD dwTime - timer callback specific
//
// Return Values    : None.
//
// Date             : 12 February 1999
//
// Engineer         : Billy Baker
//
// Description      : ReadData() is a generic name used for a timer callback
//                    function.  Each comms system interface derived class
//                    should have a method used for passing data from 
//                    simulation on to the CVariants.  Then UpdateComms should
//                    be called to get the CCommsActions to update the
//                    graphical elements.  Be sure to use the CCriticalSection
//                    m_sync with Lock and Unlock to prevent a page change from
//                    deleting memory that needs to be written to.
//
/////////////////////////////////////////////////////////////////////////////
void CDebriefCommsSystemInterface::ReadData()
{
   // Read all of the data.
   m_sync.Lock();

   CVariant CVar_DebriefPlayback;
   CCommsShared::GetLocalValue(CVar_DebriefPlayback, _FSI_STL::string("DebriefPlayback"));
   bool  isPaused =  (bool)CVar_DebriefPlayback;

   CVariant CVar_DebriefPlaybackSkip;
   CCommsShared::GetLocalValue(CVar_DebriefPlaybackSkip, _FSI_STL::string("DebriefPlaybackSkip"));
   long  DebriefPlaybackSkip  =  (long)CVar_DebriefPlaybackSkip;
   long  old_type =  CVar_DebriefPlaybackSkip.Type();
   CVar_DebriefPlaybackSkip.Value((long)0);
   CVar_DebriefPlaybackSkip.ChangeType(old_type);
   CCommsShared::SetLocalValue(CVar_DebriefPlaybackSkip, _FSI_STL::string("DebriefPlaybackSkip"), 0);


   CVariant CVar_DebriefPlaybackMark;
   CCommsShared::GetLocalValue(CVar_DebriefPlaybackMark, _FSI_STL::string("DebriefPlaybackMark"));
   long  DebriefPlaybackMark  =  (long)CVar_DebriefPlaybackMark;
   old_type       =  CVar_DebriefPlaybackMark.Type();
   CVar_DebriefPlaybackMark.Value((long)0);
   CVar_DebriefPlaybackMark.ChangeType(old_type);
   CCommsShared::SetLocalValue(CVar_DebriefPlaybackMark, _FSI_STL::string("DebriefPlaybackMark"), 0);

   switch   (DebriefPlaybackMark)
   {
      case 0:       // Don't move to a mark anymore.
         break;

      case 1:       // Goto offset defined by Mark 1.
      case 2:       // Goto offset defined by Mark 2.
      case 3:       // Goto offset defined by Mark 3.
      case 4:       // Goto offset defined by Mark 4.
      case 5:       // Goto offset defined by Mark 5.
      case 6:       // Goto offset defined by Mark 6.
      case 7:       // Goto offset defined by Mark 7.
      case 8:       // Goto offset defined by Mark 8.
      case 9:       // Goto offset defined by Mark 9.
      case 10:      // Goto offset defined by Mark 10.
         m_pcCurrentDebriefData  =  m_pcDebriefData   +  m_ulDebriefBufferSize   *  (int)(m_fDebriefRate  *  m_int_marks[DebriefPlaybackMark -  1]);
         isPaused                =  false;
         break;
   }


   switch (DebriefPlaybackSkip)
   {
      case  0:       // Don't skip any more.
         break;

      case  1:       // Goto Start
         m_pcCurrentDebriefData  =  m_pcDebriefData;
         isPaused                =  false;
         break;

      case  2:       // Go back 10 minutes
         m_pcCurrentDebriefData  -= m_ulDebriefBufferSize   *  (int)(m_fDebriefRate  *  10 *  60);
         isPaused                =  false;
         break;

      case  3:       // Go back 1 minute
         m_pcCurrentDebriefData  -= m_ulDebriefBufferSize   *  (int)(m_fDebriefRate  *  1 *  60);
         isPaused                =  false;
         break;

      case  4:       // Go back 1 seconds
         m_pcCurrentDebriefData  -= m_ulDebriefBufferSize   *  (int)(m_fDebriefRate  *  1);
         isPaused                =  false;
         break;

      case  5:       // Go forward 1 seconds
         m_pcCurrentDebriefData  += m_ulDebriefBufferSize   *  (int)(m_fDebriefRate  *  1);
         isPaused                =  false;
         break;

      case  6:       // Go forward 1 minute
         m_pcCurrentDebriefData  += m_ulDebriefBufferSize   *  (int)(m_fDebriefRate  *  1 *  60);
         isPaused                =  false;
         break;

      case  7:       // Go forward 10 minutes
         m_pcCurrentDebriefData  += m_ulDebriefBufferSize   *  (int)(m_fDebriefRate  *  10 *  60);
         isPaused                =  false;
         break;

      case  8:       // Goto End (actually one frame before the end).
         m_pcCurrentDebriefData  =  m_pcEndDebriefData   -  m_ulDebriefBufferSize;
         isPaused                =  false;
         break;
   }

   // Make sure current location is between the beginning and end of the data.
   if (m_pcCurrentDebriefData       <  m_pcDebriefData)
      m_pcCurrentDebriefData        =  m_pcDebriefData;                                // Set to beginning.
   else if (m_pcCurrentDebriefData  >  m_pcEndDebriefData)
      m_pcCurrentDebriefData        =  m_pcEndDebriefData   -  m_ulDebriefBufferSize;  // Set to one frame from the end.


   if (m_pcCurrentDebriefData != m_pcEndDebriefData && m_pcCurrentDebriefData != NULL  && !m_mapVarName2Variant.empty() && !isPaused)
   {
      // Invoke the Decode method in CFSISuiteCommsSystemInterface.
      Decode(m_pcCurrentDebriefData, m_ulDebriefBufferSize);

      m_pcCurrentDebriefData += m_ulDebriefBufferSize;
   }

   if (m_pcCurrentDebriefData != m_pcDebriefData)  // Update unless we are paused at the beginning.
   {
      // Invoke all of the callback functions.
      m_syncUpdateCallback.Lock();

      _FSI_STL::list<UpdateCallback>::iterator  lucIt =  m_listUpdateCallbacks.begin();
      while (lucIt != m_listUpdateCallbacks.end())
      {
         (*lucIt)();
         lucIt++;
      }

      m_syncUpdateCallback.Unlock();
   }

   // See about sending the CVariant values to the grapical elements.
   UpdateComms();

   m_sync.Unlock();
}

/////////////////////////////////////////////////////////////////////////////
//
// void CDebriefCommsSystemInterface::Start()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 12 February 1999
//
// Engineer         : Billy Baker
//
// Description      : Start() can be called at any time but must be 
//                    called after the loading of variables.  The call will
//                    be made when the first CCommsAction is created or prior
//                    to that when the COMMS DLL is loaded and initialized.
//                    Start() is responsible for setting up the mechanism for
//                    reading and writing--possibly the creation of a socket.
//
/////////////////////////////////////////////////////////////////////////////
void CDebriefCommsSystemInterface::Start()
{
    CCommsSystemInterface::Start();

    // Start a timer.
    m_pCommsThread = AfxBeginThread(ThreadFunc, 
                                    (LPVOID)&m_fRate,
                                    THREAD_PRIORITY_TIME_CRITICAL,
                                    0, CREATE_SUSPENDED);

    CreatePipe(&m_hPipeRead, &m_hPipeWrite, NULL, 0);

    if (m_pCommsThread != NULL)
    {
        m_pCommsThread->m_bAutoDelete = false;

        m_pCommsThread->ResumeThread();

        m_bStarted = true;
    }
}

/////////////////////////////////////////////////////////////////////////////
//
// void CDebriefCommsSystemInterface::Stop()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 12 February 1999
//
// Engineer         : Billy Baker
//
// Description      : Stop() can be called at any time but must be 
//                    called before the current instance of a comms 
//                    system interface derived class is deleted. The base
//                    class must be called after making sure that no addtional
//                    data will be read and have to be processed.
//
/////////////////////////////////////////////////////////////////////////////
void CDebriefCommsSystemInterface::Stop()
{
    if (m_pCommsThread != NULL)
    {

        // The comms thread will not auto delete itself because it should
        // run until the comms library is unloaded.  Thus, the comms thread
        // must be deleted.
        DWORD dwData = 1;
        DWORD dwBytesWritten;
        WriteFile(m_hPipeWrite, &dwData, sizeof(dwData), &dwBytesWritten, NULL);
        CloseHandle(m_hPipeWrite);

        WaitForSingleObject(m_pCommsThread->m_hThread, INFINITE);
        delete m_pCommsThread;
    }

    CCommsSystemInterface::Stop();

    m_bStarted = false;
}