/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : CommsSystemInterface.h
//
// Date             : 09 February 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.8 $
//
// Description      : CommsSystemInterface.h contains the definition of 
//                    the CCommsSystemInterface class.  This class 
//                    serves as the base class for all classes that 
//                    seek to communicate with simulation.  The base 
//                    class defines a number of data structures for 
//                    managing the distribution of values from 
//                    simulation to the graphical elements that need 
//                    the value.  Also, the base class keeps track of 
//                    all derived classes for display in the comms 
//                    configuration page.  Several virtual methods are 
//                    defined which must be implemented by the derived 
//                    class in order to communicate.
//
//                    A typical algorithm is as follows:  when the comms
//                    DLL is loaded, the name of the protocol is read from
//                    the registry and an instance of the correct comms system
//                    interface derived class is created.  Then, the variables
//                    file is read.  During reading, the m_mapVarName2Data map
//                    should be filled in.  At this point, nothing should
//                    happen until the first instance of a CCommsAction is 
//                    created.  Each instance will know its VarName in the
//                    m_mapVarName2Data map.  From this, the ID can be
//                    determined.  The CCommsAction instance is then added to
//                    the list that goes with its VarName, m_mapVarName2Comms.
//                    The first addition to the list will 
//                    also create a CVariant instance that is added to the 
//                    m_mapVarName2Variant map.  When a page is changed, each
//                    CCommsAction will delete itself from the map of ID to
//                    comms.  The last deletion will delete the CVariant that
//                    was in VarName to Variant.  When the application shuts down, 
//                    stop must be called before deleting the instance of the
//                    comms system interface derived class.  Stop will delete
//                    the memory in m_mapVarName2Data as well as any CVariants
//                    that may still be in m_mapVarName2Variant.  The deletion of
//                    CVariant is more for dynamically changing the protocol.
//                    When stop is called in the normal fashion, all of the
//                    CVariants should already be deleted.
//
//                    Malfunctions may be an exception to the above scenario.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : CVariant, map, string, CCommsAction, CXMLPage, CVar
//                    iabledData.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3
//                                          Microsoft Windows NT 5.0
//
//                    Compiler(s) - Visual C++ 5.0 with VisC++ service pack 3
//                                  Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: CommsSystemInterface.h $
// Revision 1.8  2000/06/08 06:49:53  billyb
// Added InitComplete to tell a protocol that all of the DLLs have
// been loaded and the protocol can proceed.  Called from 
// CCommsComponentInterface::InitComplete.
// Revision 1.7  2000/05/03 21:30:03  billyb
// Added CCommsShared as a friend.
// Added list of update callbacks.
// Revision 1.6  2000/03/06 21:28:22  billyb
// Changed function signatures to eliminate warnings.
// Added methods for dynamically adding and delete data
// from the host.
// Revision 1.5  2000/02/01 19:52:57  billyb
// Added map of IOS alias to host var name.  Made 
// CHostVarNameLocalCommsAction a friend.
// Revision 1.4  1999/11/15 18:29:50  billyb
// Made CCommsStatsPage a friend.  Added map for statistics.
// Added map of HWND to screen update pass value.  Added
// map of HWND to frames per second.  Added FPSCounter
// to determine when one second has elapsed based on the 
// update rate from the host.
// Revision 1.3  1999/11/06 22:39:49  billyb
// Removed unneeded function.
// Revision 1.2  1999/08/24 21:31:57  billyb
// Added a debrief header size and an array for the header.
//
#if !defined(_COMMSSYSTEMINTERFACE_H_)
#define _COMMSSYSTEMINTERFACE_H_

#ifdef COMMS
#define COMMSAPI __declspec( dllexport )
#else
#define COMMSAPI __declspec( dllimport )
#endif

#include <map>
#include <string>
#include <afxmt.h>

#include "..\core\XMLPage.h"
#include "..\core\Variant.h"
#include "..\core\VariableData.h"
#include "..\core\range.h"
#include "..\core\corecommssysteminterface.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

static const unsigned char  ucDebriefHeaderSize = 17;
static const char           cDebriefHeader[ucDebriefHeaderSize] = "Debrief Datafile";

typedef void (*UpdateCallback)();

class CHostVarNameLocalCommsAction;
class CCommsAction;
class CCommsStatsPage;
class CWidget;
class CCommsShared;

class COMMSAPI CCommsSystemInterface : public CCoreCommsSystemInterface
{
protected:
    // The data structure that maps the variable to a list of
    // all comms actions that want the value for the variable.
    // The map simply keeps track of the alias to list relationship.
    // The comms action pointers should not be deleted in the comms
    // system interface.
    static _FSI_STL::map<_FSI_STL::string, _FSI_STL::list<CCommsAction*> > m_mapVarName2Comms;

    // The data structure that maps the variable to an instance of
    // CVariant.  A CVariant for PITCH would be shared by all comms
    // actions above in the list for PITCH.
    static _FSI_STL::map<_FSI_STL::string, CVariant*>              m_mapVarName2Variant;

    // The data structure that maps the variable alias to a list of
    // CRanges.  All actions referencing the same CVariant will also
    // reference the same list in this data structure.
    static _FSI_STL::map<_FSI_STL::string, _FSI_STL::list<CRange*> >    m_mapVarName2Ranges;

    // The name of the machine to connect to and the port number.
    _FSI_STL::string                                            m_stlStrMachineName;
    unsigned long int                                           m_ulPort;

    // Specifies the HZ of the host code or the HZ at which data
    // should be arriving from the host.
    static float                                                m_fRate;
    
    // Specifies the HZ to record debriefing data.
    static float                                                m_fDebriefRate;
    
    // Specifies the HZ to update the screen.
    static float                                                m_fScreenUpdateRate;

    static unsigned long int                                    m_ulFPSCounter;

    // Contains the ID for a timer event if a timer is used.
    unsigned long int                                    m_ulIDEvent;

    static CCriticalSection                              m_sync;
    static CCriticalSection                              m_syncCommsDelete;
    static CCriticalSection                              m_syncCommsAdd;
    static CCriticalSection                              m_syncRefresh;
    static CCriticalSection                              m_syncUpdateCallback;

    // A number used to represent when to record debrief data.
    // 2 would be every second pass, 3 would be every third pass.
    static unsigned char                                 m_ucDebriefRatio;

    // Store the update pass between calls.  This should initialize
    // to m_ucDebriefRatio so that the first pass will be recorded.
    static unsigned char                                 m_ucDebriefUpdatePass;

    // A number used to represent when to update the screen.
    // 2 would be every second pass, 3 would be every third pass.
    static unsigned char                                 m_ucScreenUpdateRatio;

    // Pointer to either the block of data in a pass to be recorded.
    // Or, to all of the data read in from a debriefing file.
    // Deleted in Stop().
    static char*                                         m_pcDebriefData;

    // The file to read and write debriefing data.
    static CFile                                         m_fileDebrief;

    // Map of the VarName to the same CVariableData pointers in
    // VarName2Data.  Used to only step through the Debriefing variables
    // when recording data.
    static _FSI_STL::map<_FSI_STL::string, CVariableData*>         m_mapVarName2Debrief;

    // The size of the block of data recorded in a single pass.
    static unsigned long int                             m_ulDebriefBufferSize;

    // Whether to record debriefing data.
    bool                                                 m_bRecordDebrief;

    static bool                                          m_bConnected;

    static bool                                          m_bInitComplete;

    // A secondary file path for merging with the FSISuite data file.
    _FSI_STL::string                                          m_stlStrSecondaryFile;

    CWinThread*  m_pCommsThread;
    static HANDLE                                 m_hPipeWrite;
    static HANDLE                                 m_hPipeRead;
    static bool                                   m_bWritePending;

    static _FSI_STL::list<CCommsAction*>               m_listCommsActionsToDelete;
    static _FSI_STL::list<CCommsAction*>               m_listCommsActionsToAdd;

    static _FSI_STL::map<_FSI_STL::string, _FSI_STL::string>  m_mapStatistics;
    static _FSI_STL::map<_FSI_STL::string, _FSI_STL::string> m_mapHostToIOSAlias;

    static _FSI_STL::map<HWND, _FSI_STL::map<CWidget*, bool> >  m_mapLocalsToRefresh;
    static _FSI_STL::map<HWND, unsigned char>           m_mapScreenUpdatePass;
    static _FSI_STL::map<HWND, unsigned long int>       m_mapFPS;

    static _FSI_STL::list<UpdateCallback>               m_listUpdateCallbacks;

protected:
	CCommsSystemInterface();

public:
    typedef CCommsSystemInterface* (*CreateComms)();

	virtual ~CCommsSystemInterface();

    // Accessor
    _FSI_STL::string MachineName();
    bool Debrief();
    unsigned long int Port();
    float Rate();
    float DebriefRate();
    float ScreenUpdateRate();
    
    // Mutator
    void MachineName(const _FSI_STL::string& rstlStrMachineName);
    void Debrief(bool bRecordDebrief);
    void Port(unsigned long int ulPort);
    void Rate(float unRate);
    void DebriefRate(float unDebriefRate);
    void ScreenUpdateRate(float unScreenUpdateRate);

    static void AddComms(CIOAction* pIOAction);
    static void DeleteComms(CIOAction* pIOAction);
    static void UpdateComms();

    virtual void LoadVariables(const _FSI_STL::string& rstlStrVariablesFile) = 0;

    virtual void WriteData(CVariant* pVariant, CVariableData* pVarData) = 0;

    virtual void AddVariable(const _FSI_STL::string& stlStrVariable, 
                             CVariableData& varData, 
                             _FSI_STL::list<CRange>& listRanges);

    virtual void AddData(CVariableData* pVarData);
    virtual void DeleteData();
    virtual void Start();
    virtual void Stop();
    static  bool Connected();

    void ToDelete(CCommsAction* pCommsAction);
    void ToAdd(CCommsAction* pCommsAction);
    void ToRefresh(CWidget* pWidget);

    // Map of the name of a variable alias to a structure of data that
    // goes along with the alias--ID, real variable name, type, etc.  See
    // the LoadVariables method of the specific comms system interface derived
    // class for the exact data.
    static _FSI_STL::map<_FSI_STL::string,  CVariableData*>             m_mapVarName2Data;

    // Map of comms system interface name, ZCT, WTX, FSISuite, etc, to the 
    // CreateComms pointer to create a new instance of a comms system interface
    // derived class without explicitly including the headers.
    static _FSI_STL::map<_FSI_STL::string, CreateComms>                 m_mapCommsSystems;

    static _FSI_STL::map<HWND, _FSI_STL::map<CWidget*, bool> >  m_mapWidgetsToRefresh;

    static void InitComplete();

    friend class CHostVarNameLocalCommsAction;
    friend class CCommsAction;
    friend class CCommsStatsPage;
    friend class CCommsShared;
};

#endif // !defined(_COMMSSYSTEMINTERFACE_H_)
