/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : CommsStatsPage.h
//
// Date             : 15 November 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.2 $
//
// Description      : CommsStatsPage.h contains the definition of
//                    the CCommsStatsPage class.  This class is used
//                    to display statistics about the current COMMS
//                    protocol.  It should be available on the Options
//                    property sheet when the COMMS DLL is loaded.  All
//                    CCommsSystemInterface derived protocols will include
//                    the frame rates for each parent window that has 
//                    widgets that require updates (see 
//                    CCommsSystemInterface::UpdateComms).
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : CString, CListCtrl, _FSI_STL::map, _FSI_STL::string
//                    ,
//                    _FSI_STL::map::iterator.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: CommsStatsPage.h $                                                                   
// Revision 1.2  1999/11/15 18:27:41  billyb                                                                   
// Added setup of list control.  Added walking through the map                                                                   
// of statistics and adding them to the list control.  Added comments.                                                                   
/////////////////////////////////////////////////////////////////////////////
#if !defined(_COMMSSTATSPAGE_H_)
#define _COMMSSTATSPAGE_H_

#include "resource.h"

#include "..\core\BasePage.h"

#include "CommsShared.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CCommsStatsPage : public CBasePage, public CCommsShared
{
// Construction
public:
	CCommsStatsPage();
	~CCommsStatsPage();
    static CBasePage* CreateObject();

// Dialog Data
	//{{AFX_DATA(CCommsStatsPage)
	enum { IDD = IDD_LOCAL_COMMS_STATS_PAGE };
	CListCtrl	m_wndHostStatsList;
	CString	m_strVariablesRequested;
	CString	m_strVariablesForDebrief;
	CString	m_strVariablesRead;
	CString	m_strVariablesWithRanges;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CCommsStatsPage)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CCommsStatsPage)
	virtual BOOL OnInitDialog();
	afx_msg void OnCommsStatsRefresh();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(_COMMSSTATSPAGE_H_)
