/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : CommsStatsPage.cpp
//
// Date             : 15 November 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.4 $
//
// Description      : CommsStatsPage.cpp contains the implementation of
//                    the CCommsStatsPage class.  This class is used
//                    to display statistics about the current COMMS
//                    protocol.  It should be available on the Options
//                    property sheet when the COMMS DLL is loaded.  All
//                    CCommsSystemInterface derived protocols will include
//                    the frame rates for each parent window that has 
//                    widgets that require updates (see 
//                    CCommsSystemInterface::UpdateComms).
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : CString, CListCtrl, _FSI_STL::map, _FSI_STL::string
//                    ,
//                    _FSI_STL::map::iterator.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: CommsStatsPage.cpp $                                                                   
// Revision 1.4  2000/05/03 21:11:58  billyb                                                                   
// Changed data structure to show real number of used                                                                   
// variables.                                                                   
// Revision 1.3  2000/03/06 20:47:10  billyb                                                                   
// Added casts to eliminate warnings.                                                                   
// Revision 1.2  1999/11/15 18:27:31  billyb                                                                   
// Added setup of list control.  Added walking through the map                                                                   
// of statistics and adding them to the list control.  Added comments.                                                                   
/////////////////////////////////////////////////////////////////////////////
#include "..\core\stdafx.h"
#include "CommsStatsPage.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
//
// CCommsStatsPage::CCommsStatsPage()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 15 November 1999
//
// Engineer         : Billy Baker
//
// Description      : Default constructor for the CCommsStatsPage class.  
//                    Besides control initialization, the constructor 
//                    sets the name of the property page 
//                    (m_stlStrPageName in CBasePage).
//
/////////////////////////////////////////////////////////////////////////////
CCommsStatsPage::CCommsStatsPage() : CBasePage(CCommsStatsPage::IDD)
{
	//{{AFX_DATA_INIT(CCommsStatsPage)
	m_strVariablesRequested = _T("");
	m_strVariablesForDebrief = _T("");
	m_strVariablesRead = _T("");
	m_strVariablesWithRanges = _T("");
	//}}AFX_DATA_INIT
    m_stlStrPageName = _FSI_STL::string("Statistics - FSISuite Protocol");
}

/////////////////////////////////////////////////////////////////////////////
//
// CCommsStatsPage::~CCommsStatsPage()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 15 November 1999
//
// Engineer         : Billy Baker
//
// Description      : Default destructor for CCommsStatsPage.
//
/////////////////////////////////////////////////////////////////////////////
CCommsStatsPage::~CCommsStatsPage()
{
}

void CCommsStatsPage::DoDataExchange(CDataExchange* pDX)
{
	CBasePage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCommsStatsPage)
	DDX_Control(pDX, IDC_HOST_STATS_LIST, m_wndHostStatsList);
	DDX_Text(pDX, IDC_VARIABLES_REQUESTED, m_strVariablesRequested);
	DDX_Text(pDX, IDC_VARIABLES_FOR_DEBRIEF, m_strVariablesForDebrief);
	DDX_Text(pDX, IDC_VARIABLES_READ, m_strVariablesRead);
	DDX_Text(pDX, IDC_VARIABLES_WITH_RANGES, m_strVariablesWithRanges);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CCommsStatsPage, CBasePage)
	//{{AFX_MSG_MAP(CCommsStatsPage)
	ON_BN_CLICKED(IDC_COMMS_STATS_REFRESH, OnCommsStatsRefresh)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
//
// CBasePage* CCommsStatsPage::CreateObject()
//
// Inputs           : None.
//
// Return Values    : A CBasePage pointer to a newly created CCommsStatsPage.
//
// Date             : 15 November 1999
//
// Engineer         : Billy Baker
//
// Description      : Creates a new CCommsStatsPage and returns a base 
//                    pointer to the new CCommsStatsPage.
//
/////////////////////////////////////////////////////////////////////////////
CBasePage* CCommsStatsPage::CreateObject()
{
    return new CCommsStatsPage;
}

/////////////////////////////////////////////////////////////////////////////
//
// BOOL CCommsStatsPage::OnInitDialog()
//
// Inputs           : None.
//
// Return Values    : Success of OnInitDialog code.
//
// Date             : 15 November 1999
//
// Engineer         : Billy Baker
//
// Description      : CCommsStatsPage::OnInitDialog() is an override to 
//                    initialize parts of the CCommsStatsPage property page. 
//                    CStatic controls that are common to all 
//                    CCommsSystemInterface derived protocols are updated.
//                    The size of the two columns is set.  Column 1 is 2/3
//                    of the width and column 2 is 1/3 of the width.  Each
//                    CCommsSystemInterface derived protocol shares a 
//                    m_mapStatistics member which holds data about the 
//                    different statistics.
//                    
/////////////////////////////////////////////////////////////////////////////
BOOL CCommsStatsPage::OnInitDialog() 
{
	CBasePage::OnInitDialog();

    // Data that should be common for all protocols.
    if (m_pCommsSystemInterface != NULL)
    {
	    m_strVariablesRequested.Format("%d", 
                            m_pCommsSystemInterface->m_mapVarName2Data.size());
	    m_strVariablesForDebrief.Format("%d", 
                            m_pCommsSystemInterface->m_mapVarName2Debrief.size());
	    m_strVariablesRead.Format("%d", 
                            m_pCommsSystemInterface->m_mapVarName2Comms.size());
	    m_strVariablesWithRanges.Format("%d", 
                            m_pCommsSystemInterface->m_mapVarName2Ranges.size());
    }
    else
    {
        m_strVariablesRequested     = "N/A";
        m_strVariablesForDebrief    = "N/A";
        m_strVariablesRead          = "N/A";
        m_strVariablesWithRanges    = "N/A";
    }

    // Setup the list with two column headings.
    CRect rect;
    m_wndHostStatsList.GetClientRect(&rect);

    m_wndHostStatsList.InsertColumn(0, "Statistic", LVCFMT_LEFT, 
                                                 (int)(rect.Width() * .6667f));

    m_wndHostStatsList.InsertColumn(1, "Value",  LVCFMT_LEFT, 
                                                 (int)(rect.Width() * .3333f));

    m_wndHostStatsList.DeleteAllItems();

    // Fill the list control with data from the protocol.
    _FSI_STL::map<_FSI_STL::string, _FSI_STL::string>::iterator mIt = 
                               m_pCommsSystemInterface->m_mapStatistics.begin();
    _FSI_STL::map<_FSI_STL::string, _FSI_STL::string>::iterator mendIt = 
                               m_pCommsSystemInterface->m_mapStatistics.end();

    int nItem = 0;
    while (mIt != mendIt)
    {
        m_wndHostStatsList.InsertItem(nItem, (*mIt).first.c_str(), 0);
        m_wndHostStatsList.SetItemText(nItem, 1, (*mIt).second.c_str());

        mIt++;
        nItem++;
    }

    UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

/////////////////////////////////////////////////////////////////////////////
//
// void CCommsStatsPage::OnCommsStatsRefresh()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 15 November 1999
//
// Engineer         : Billy Baker
//
// Description      : CCommsStatsPage::OnCommsStatsRefresh() is a handler for
//                    when the refresh button on the property page is clicked.
//                    CStatic controls that are common to all 
//                    CCommsSystemInterface derived protocols are updated.
//                    Each CCommsSystemInterface derived protocol shares a 
//                    m_mapStatistics member which holds data about the 
//                    different statistics.
//                    
/////////////////////////////////////////////////////////////////////////////
void CCommsStatsPage::OnCommsStatsRefresh() 
{
    // Data that should be common for all protocols.
    if (m_pCommsSystemInterface != NULL)
    {
	    m_strVariablesRequested.Format("%d", 
                            m_pCommsSystemInterface->m_mapVarName2Data.size());
	    m_strVariablesForDebrief.Format("%d", 
                            m_pCommsSystemInterface->m_mapVarName2Debrief.size());
	    m_strVariablesRead.Format("%d", 
                            m_pCommsSystemInterface->m_mapVarName2Comms.size());
	    m_strVariablesWithRanges.Format("%d", 
                            m_pCommsSystemInterface->m_mapVarName2Ranges.size());
    }
    else
    {
        m_strVariablesRequested     = "N/A";
        m_strVariablesForDebrief    = "N/A";
        m_strVariablesRead          = "N/A";
        m_strVariablesWithRanges    = "N/A";
    }

    m_wndHostStatsList.DeleteAllItems();

    // Fill the list control with data from the protocol.
    _FSI_STL::map<_FSI_STL::string, _FSI_STL::string>::iterator mIt = 
                               m_pCommsSystemInterface->m_mapStatistics.begin();
    _FSI_STL::map<_FSI_STL::string, _FSI_STL::string>::iterator mendIt = 
                               m_pCommsSystemInterface->m_mapStatistics.end();

    int nItem = 0;
    while (mIt != mendIt)
    {
        m_wndHostStatsList.InsertItem(nItem, (*mIt).first.c_str(), 0);
        m_wndHostStatsList.SetItemText(nItem, 1, (*mIt).second.c_str());

        mIt++;
        nItem++;
    }

    UpdateData(FALSE);
}
