/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : CommsShared.h
//
// Date             : 09 February 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.5 $
//
// Description      : CommsShared.h contains the definition of the 
//                    CCommsShared class.  This class is used to define 
//                    resources that will be shared by more than one 
//                    class implmemented in the COMMS DLL.  If a class 
//                    needs to access one of the variables in this 
//                    class, it must derive from this class.  This 
//                    method is used as opposed to having global variables.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : Comms::CCommsSystemInterface.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3
//                                          Microsoft Windows NT 5.0
//
//                    Compiler(s) - Visual C++ 5.0 with VisC++ service pack 3
//                                  Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: CommsShared.h $
// Revision 1.5  2000/06/16 20:45:41  billyb
// Fix type problems with ArrayOffset.
// Revision 1.4  2000/05/26 16:29:45  billyb
// Added default parameters for local variable functions for
// specifying a screen dependent variable.
// Revision 1.3  2000/05/03 22:16:03  billyb
// Added methods to set and get values from locals
// or the host.
// Added methods for update callbacks.
// Revision 1.2  2000/03/06 21:28:47  billyb
// Added failure summary.
/////////////////////////////////////////////////////////////////////////////
#if !defined(_COMMSSHARED_H_)
#define _COMMSSHARED_H_

#ifdef COMMS
#define COMMSAPI __declspec( dllexport )
#else
#define COMMSAPI __declspec( dllimport )
#endif

#include "CommsSystemInterface.h"
#include "LocalCommsSystemInterface.h"
#include "MessageLoggingSystemInterface.h"
#include "FailureSummarySystemInterface.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class COMMSAPI CCommsShared  
{
public:
	CCommsShared();
	virtual ~CCommsShared();

    static CCommsSystemInterface*           m_pCommsSystemInterface;
    static CMessageLoggingSystemInterface*  m_pLogSystemInterface;
    static CLocalCommsSystemInterface*      m_pLocalCommsSystemInterface;
    static CFailureSummarySystemInterface*  m_pFailureSummarySystemInterface;

    static CVariableData*   FindVariableData(const _FSI_STL::string& rstlStrVarName);
    static CVariant*        FindVariant(const _FSI_STL::string& rstlStrVarName);
    static CVariableData*   FindLocalVariableData(const _FSI_STL::string& rstlStrVarName);
    static CVariant*        FindLocalVariant(const _FSI_STL::string& rstlStrVarName,
                                            long hParent = INDEPENDENT_VARIABLE);
    static void             AddUpdateCallback(UpdateCallback callback);
    static void             DeleteUpdateCallback(UpdateCallback callback);

    static void             SetHostValue(CVariant& rVariant, 
                                            _FSI_STL::string& rstlStrVarName, 
                                            long lOffset);

    static void             SetLocalValue(CVariant& rVariant, 
                                            _FSI_STL::string& rstlStrVarName, 
                                            long lOffset,
                                            long hParent = INDEPENDENT_VARIABLE);

    static void             GetHostValue(CVariant& rVariant, _FSI_STL::string& rstlStrVarName);
    static void             GetLocalValue(CVariant& rVariant, _FSI_STL::string& rstlStrVarName, 
                                            long hParent = INDEPENDENT_VARIABLE);
    static void             SetHostVariable(char *var_name, char * value, int offset);
    static void             SetHostValue(char *VarName, class CVariant &rVariant,  unsigned long ulOffset);
};

#endif // !defined(_COMMSSHARED_H_)
