/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : CommsShared.cpp
//
// Date             : 09 February 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.6 $
//
// Description      : CommsShared.cpp contains the implementation of the 
//                    CCommsShared class.  This class is used to define 
//                    resources that will be shared by more than one 
//                    class implmemented in the COMMS DLL.  If a class 
//                    needs to access one of the variables in this 
//                    class, it must derive from this class.  This 
//                    method is used as opposed to having global variables.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : Comms::CCommsSystemInterface.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3
//                                          Microsoft Windows NT 5.0
//
//                    Compiler(s) - Visual C++ 5.0 with VisC++ service pack 3
//                                  Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: CommsShared.cpp $
// Revision 1.6  2000/06/16 20:45:35  billyb
// Fix type problems with ArrayOffset.
// Revision 1.5  2000/05/26 16:30:01  billyb
// Added default parameters for local variable functions for
// specifying a screen dependent variable.
// Revision 1.4  2000/05/18 20:52:50  billyb
// Update from FSI to fix copy and paste errors.
// Revision 1.3  2000/05/03 22:16:34  billyb
// Added methods to set and get values from locals
// or the host.
// Added methods for update callbacks.
// Revision 1.2  2000/03/06 21:33:21  billyb
// Added failure summary.
/////////////////////////////////////////////////////////////////////////////
#include "..\core\stdafx.h"
#include "CommsShared.h"

// Initialize the CommsSystemInterface pointer.
CCommsSystemInterface*          CCommsShared::m_pCommsSystemInterface = NULL;
CMessageLoggingSystemInterface* CCommsShared::m_pLogSystemInterface = NULL;
CLocalCommsSystemInterface*     CCommsShared::m_pLocalCommsSystemInterface = NULL;
CFailureSummarySystemInterface* CCommsShared::m_pFailureSummarySystemInterface = NULL;

/////////////////////////////////////////////////////////////////////////////
//
// CCommsShared::CCommsShared()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 09 February 1999
//
// Engineer         : Billy Baker
//
// Description      : Default constructor.
//
/////////////////////////////////////////////////////////////////////////////
CCommsShared::CCommsShared()
{
}

/////////////////////////////////////////////////////////////////////////////
//
// CCommsShared::~CCommsShared()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 09 February 1999
//
// Engineer         : Billy Baker
//
// Description      : Default destructor.
//
/////////////////////////////////////////////////////////////////////////////
CCommsShared::~CCommsShared()
{
}

CVariableData* CCommsShared::FindVariableData(const _FSI_STL::string& rstlStrVarName)
{
    CVariableData* pVarData = NULL;

    if (m_pCommsSystemInterface != NULL)
    {
        _FSI_STL::map<_FSI_STL::string, CVariableData*>::iterator mIt = 
            m_pCommsSystemInterface->m_mapVarName2Data.find(rstlStrVarName);

        if (mIt != m_pCommsSystemInterface->m_mapVarName2Data.end())
        {
            pVarData = (*mIt).second;
        }
        else
        {
            _FSI_STL::map<_FSI_STL::string, _FSI_STL::string>::iterator mHostIt =
                m_pCommsSystemInterface->m_mapHostToIOSAlias.find(rstlStrVarName);

            if (mHostIt != m_pCommsSystemInterface->m_mapHostToIOSAlias.end())
            {
                pVarData = m_pCommsSystemInterface->m_mapVarName2Data[(*mHostIt).second];
            }
        }
    }

    return pVarData;
}

CVariant* CCommsShared::FindVariant(const _FSI_STL::string& rstlStrVarName)
{
    CVariant* pVariant = NULL;

    if (m_pCommsSystemInterface != NULL)
    {
        _FSI_STL::map<_FSI_STL::string, CVariant*>::iterator mIt = 
            m_pCommsSystemInterface->m_mapVarName2Variant.find(rstlStrVarName);

        if (mIt != m_pCommsSystemInterface->m_mapVarName2Variant.end())
        {
            pVariant = (*mIt).second;
        }
        else
        {
            _FSI_STL::map<_FSI_STL::string, _FSI_STL::string>::iterator mHostIt =
                m_pCommsSystemInterface->m_mapHostToIOSAlias.find(rstlStrVarName);

            if (mHostIt != m_pCommsSystemInterface->m_mapHostToIOSAlias.end())
            {
                if (m_pCommsSystemInterface->m_mapVarName2Variant.find((*mHostIt).second) !=
                    m_pCommsSystemInterface->m_mapVarName2Variant.end())
                {
                    pVariant = m_pCommsSystemInterface->m_mapVarName2Variant[(*mHostIt).second];
                }
            }
        }
    }

    return pVariant;
}

CVariableData* CCommsShared::FindLocalVariableData(const _FSI_STL::string& rstlStrVarName)
{
    CVariableData* pVarData = NULL;

    if (m_pLocalCommsSystemInterface != NULL)
    {
        _FSI_STL::map<_FSI_STL::string, CVariableData*>::iterator mIt = 
            m_pLocalCommsSystemInterface->m_mapVarName2Data.find(rstlStrVarName);

        if (mIt != m_pLocalCommsSystemInterface->m_mapVarName2Data.end())
        {
            pVarData = (*mIt).second;
        }
    }

    return pVarData;
}

CVariant* CCommsShared::FindLocalVariant(const _FSI_STL::string& rstlStrVarName, long hParent)
{
    CVariant* pVariant = NULL;

    if (m_pLocalCommsSystemInterface != NULL)
    {
        _FSI_STL::map<_FSI_STL::string, _FSI_STL::map<long, CVariant*> >::iterator mIt = 
            m_pLocalCommsSystemInterface->m_mapVarName2Variant.find(rstlStrVarName);

        if (mIt != m_pLocalCommsSystemInterface->m_mapVarName2Variant.end())
        {
            if ((*mIt).second.find(hParent) != (*mIt).second.end())
            {
                pVariant = ((*mIt).second)[hParent];
            }
        }
    }

    return pVariant;
}

void CCommsShared::AddUpdateCallback(UpdateCallback callback)
{
    CCommsSystemInterface::m_listUpdateCallbacks.push_back(callback);
}

void CCommsShared::DeleteUpdateCallback(UpdateCallback callback)
{
    CCommsSystemInterface::m_syncUpdateCallback.Lock();
    _FSI_STL::list<UpdateCallback>::iterator lIt = 
                _FSI_STL::find(CCommsSystemInterface::m_listUpdateCallbacks.begin(),
                               CCommsSystemInterface::m_listUpdateCallbacks.end(),
                               callback);
    if (lIt != CCommsSystemInterface::m_listUpdateCallbacks.end())
    {
        CCommsSystemInterface::m_listUpdateCallbacks.erase(lIt);
    }
    CCommsSystemInterface::m_syncUpdateCallback.Unlock();
}

void CCommsShared::SetHostValue(CVariant& rVariant, 
                                _FSI_STL::string& rstlStrVarName, 
                                long lOffset)
{
    if (m_pCommsSystemInterface == NULL)
        return;

    CVariableData* pVarData = FindVariableData(rstlStrVarName);

    if (pVarData == NULL)
        return;

    long lCurrentOffset = pVarData->ArrayOffset();
    pVarData->ArrayOffset(lOffset);

    // Call the instantiated CCommsSystemInterface derived class' 
    // WriteData member to update simulation.
    m_pCommsSystemInterface->WriteData(&rVariant, pVarData);

    pVarData->ArrayOffset(lCurrentOffset);
}

void CCommsShared::GetHostValue(CVariant& rVariant, _FSI_STL::string& rstlStrVarName)
{
    CVariant* pVariant = FindVariant(rstlStrVarName);

    if (pVariant != NULL)
        rVariant = *pVariant;
}

void CCommsShared::SetLocalValue(CVariant& rVariant, 
                                _FSI_STL::string& rstlStrVarName, 
                                long lOffset,
                                long hParent)
{
    if (m_pLocalCommsSystemInterface == NULL)
        return;

    CVariableData* pVarData = FindLocalVariableData(rstlStrVarName);

    if (pVarData == NULL)
        return;

    long lCurrentOffset = pVarData->ArrayOffset();
    pVarData->ArrayOffset(lOffset);

    // Call the instantiated CCommsSystemInterface derived class' 
    // WriteData member to update simulation.
    m_pLocalCommsSystemInterface->WriteData(&rVariant, pVarData, hParent);

    pVarData->ArrayOffset(lCurrentOffset);
}

void CCommsShared::GetLocalValue(CVariant& rVariant, _FSI_STL::string& rstlStrVarName, long hParent)
{
    CVariant* pVariant = FindLocalVariant(rstlStrVarName, hParent);

    if (pVariant != NULL)
        rVariant = *pVariant;
}

void CCommsShared::SetHostValue(char *VarName, CVariant &rVariant,  unsigned long ulOffset = 0)
{
   
   _FSI_STL::string rstlStrVarName(VarName);

   CVariableData* pVarData = FindVariableData(rstlStrVarName);

   if (pVarData == NULL)
        return;

   unsigned long ulCurrentOffset = pVarData->ArrayOffset();
   pVarData->ArrayOffset(ulOffset);
   m_pCommsSystemInterface->WriteData(&rVariant, pVarData);

   pVarData->ArrayOffset(ulCurrentOffset);
}

void CCommsShared::SetHostVariable(char *var_name, char * value, int offset)
{
   CVariant variant;
   variant.Value((_FSI_STL::string)value);
   SetHostValue(var_name, variant, offset);
}