/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : CommsConfigPage.h
//
// Date             : 09 February 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.1 $
//
// Description      : CommsConfigPage.h contains the definition of the 
//                    CCommsConfigPage class.  CCommsConfigPage is 
//                    derived from Core::CBasePage and CCommsShared.  
//                    The CCommsShared derivation is needed to gain 
//                    access to the pointer to the instance of a 
//                    CCommsSystemInterface derived class.  This is 
//                    necesary because this property page is used to 
//                    select the comms protocol and set the IO source 
//                    datafile.  If either of these changes, then the 
//                    pointer will be needed to either delete the old 
//                    CCommsSystemInterface derived class and create a 
//                    new one and to read the IO source datafile. The
//                    general purpose of this class is to read and write
//                    configuration data to the registry.  This page is
//                    displayed in the COptions dialog.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : CString, Core::CBasePage, Comms::CCommsShared.
//                    Comms::CCommsSystemInterface.
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3
//                                          Microsoft Windows NT 5.0
//
//                    Compiler(s) - Visual C++ 5.0 with VisC++ service pack 3
//                                  Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: CommsConfigPage.h $
// Revision 1.1  1999/08/24 18:24:48  billyb
// Initial Revision
//
#if !defined(_COMMSCONFIGPAGE_H_)
#define _COMMSCONFIGPAGE_H_

#include "resource.h"

#include "..\core\BasePage.h"
#include "CommsShared.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CCommsConfigPage : public CBasePage, public CCommsShared
{
private:

// Construction
public:
	CCommsConfigPage();
	~CCommsConfigPage();
    static CBasePage* CreateObject();

// Dialog Data
	//{{AFX_DATA(CCommsConfigPage)
	enum { IDD = IDD_COMMS_PAGE_CONFIG };
	CString	m_strMachineName;
	CString	m_strVariablesFile;
	BOOL	m_bRecordDebrief;
	CString	m_strCommsType;
    CString m_strPort;
	float	m_fDebriefRate;
	float	m_fScreenUpdateRate;
	float	m_fHostRate;
	//}}AFX_DATA


// Overrides
	// ClassWizard generate virtual function overrides
	//{{AFX_VIRTUAL(CCommsConfigPage)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	// Generated message map functions
	//{{AFX_MSG(CCommsConfigPage)
	afx_msg void OnVariablesfileButton();
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

    virtual void SetProperties(void* pWidget);
    virtual void UpdateProperties(void* pWidget);
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(_COMMSCONFIGPAGE_H_)
