/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : CommsConfigPage.cpp
//
// Date             : 09 February 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.2 $
//
// Description      : CommsConfigPage.cpp contains the implementation of the 
//                    CCommsConfigPage class.  CCommsConfigPage is 
//                    derived from Core::CBasePage and CCommsShared.  
//                    The CCommsShared derivation is needed to gain 
//                    access to the pointer to the instance of a 
//                    CCommsSystemInterface derived class.  This is 
//                    necesary because this property page is used to 
//                    select the comms protocol and set the IO source 
//                    datafile.  If either of these changes, then the 
//                    pointer will be needed to either delete the old 
//                    CCommsSystemInterface derived class and create a 
//                    new one and to read the IO source datafile. The
//                    general purpose of this class is to read and write
//                    configuration data to the registry.  This page is
//                    displayed in the COptions dialog.  The standard 
//                    CBasePage framework methods--SetProperties and 
//                    UpdateProperties--are defined and implemented in
//                    Core::CIOActionPage.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : CString, Core::CBasePage, CCommsShared.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3
//                                          Microsoft Windows NT 5.0
//
//                    Compiler(s) - Visual C++ 5.0 with VisC++ service pack 3
//                                  Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: CommsConfigPage.cpp $
// Revision 1.2  1999/11/04 19:54:34  billyb
// Changed for loop to while and added variable for map end()
// call to decrease calls to end().
//
#include "..\core\stdafx.h"
#include "CommsConfigPage.h"
#include "CommsSystemInterface.h"

typedef CCommsSystemInterface* (*CreateComms)();

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
//
// CCommsConfigPage::CCommsConfigPage()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 09 February 1999
//
// Engineer         : Billy Baker
//
// Description      : Default constructor.  Calls parent's constructor 
//                    passing the resource template ID for the property 
//                    page.  Sets the non-displayed name of the 
//                    property page.
//
/////////////////////////////////////////////////////////////////////////////
CCommsConfigPage::CCommsConfigPage() : CBasePage(CCommsConfigPage::IDD)
{
	//{{AFX_DATA_INIT(CCommsConfigPage)
	m_strMachineName = _T("");
	m_strVariablesFile = _T("");
	m_bRecordDebrief = FALSE;
	m_strCommsType = _T("");
    m_strPort = _T("");
	m_fDebriefRate = 1.0f;
	m_fScreenUpdateRate = 1.0f;
	m_fHostRate = 1.0f;
	//}}AFX_DATA_INIT
    m_stlStrPageName = _FSI_STL::string("Host Comms Config");
}

/////////////////////////////////////////////////////////////////////////////
//
// CCommsConfigPage::~CCommsConfigPage()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 09 February 1999
//
// Engineer         : Billy Baker
//
// Description      : Default destructor.
//
/////////////////////////////////////////////////////////////////////////////
CCommsConfigPage::~CCommsConfigPage()
{
}

void CCommsConfigPage::DoDataExchange(CDataExchange* pDX)
{
	CBasePage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCommsConfigPage)
	DDX_Text(pDX, IDC_MACHINENAME, m_strMachineName);
	DDX_Text(pDX, IDC_VARIABLESFILE, m_strVariablesFile);
	DDX_Check(pDX, IDC_RECORD_DEBRIEF, m_bRecordDebrief);
	DDX_CBString(pDX, IDC_COMMS_TYPE, m_strCommsType);
	DDX_Text(pDX, IDC_PORT, m_strPort);
	DDX_Text(pDX, IDC_DEBRIEF_RECORD_RATE, m_fDebriefRate);
	DDV_MinMaxFloat(pDX, m_fDebriefRate, 1.f, 100.f);
	DDX_Text(pDX, IDC_SCREEN_UPDATE_RATE, m_fScreenUpdateRate);
	DDV_MinMaxFloat(pDX, m_fScreenUpdateRate, 1.f, 100.f);
	DDX_Text(pDX, IDC_HOST_RATE, m_fHostRate);
	DDV_MinMaxFloat(pDX, m_fHostRate, 1.f, 100.f);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CCommsConfigPage, CBasePage)
	//{{AFX_MSG_MAP(CCommsConfigPage)
	ON_BN_CLICKED(IDC_VARIABLESFILE_BUTTON, OnVariablesfileButton)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
//
// CBasePage* CCommsConfigPage::CreateObject()
//
// Inputs           : None.
//
// Return Values    : Address of a new instance of CCommsConfigPage
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : CreateObject() is a common framework method that must be
//                    implemented by each CBasePage derived class.  The DLL
//                    that uses this page associates the name of this page with 
//                    this static CreateObject method so that a new object can be
//                    created without linking against the library that contains
//                    this class.
//
/////////////////////////////////////////////////////////////////////////////
CBasePage* CCommsConfigPage::CreateObject()
{
    return new CCommsConfigPage;
}

/////////////////////////////////////////////////////////////////////////////
//
// void CCommsConfigPage::SetProperties()
//
// Inputs           : None.
//
// Return Values    : void* pWidget - for COptions property pages, pWidget
//                                    is the addrss of the name of the 
//                                    component whose configuration is being
//                                    changed or checked.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : SetProperties() is a common framework method that must be
//                    implemented by each CBasePage derived class. SetProperties
//                    is called after the property page has been created but
//                    before OnInitDialog().  Its purpose is to read the 
//                    registry for configuration data.
//
/////////////////////////////////////////////////////////////////////////////
void CCommsConfigPage::SetProperties(void* pWidget)
{
    CString strComponentName = CString((char *)pWidget);
    HKEY hKey;

    // Open the registry.
    RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\FSISuite\\") + strComponentName, 0, KEY_READ, &hKey);

    if (hKey != NULL)
    {
		CString strValue = "";
		DWORD dwType, dwCount;

        // Get the machine name.
		LONG lResult = RegQueryValueEx(hKey, _T("MachineName"), 
                                       NULL, &dwType, NULL, &dwCount);
		if (lResult == ERROR_SUCCESS)
		{
			ASSERT(dwType == REG_SZ);
			lResult = RegQueryValueEx(hKey, _T("MachineName"), NULL, &dwType,
				            (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)),
                                      &dwCount);

			strValue.ReleaseBuffer();
		}

        m_strMachineName = strValue;

        strValue = "";

        // Get the protocol type.
		lResult = RegQueryValueEx(hKey, _T("CommsType"), 
                                       NULL, &dwType, NULL, &dwCount);
		if (lResult == ERROR_SUCCESS)
		{
			ASSERT(dwType == REG_SZ);
			lResult = RegQueryValueEx(hKey, _T("CommsType"), NULL, &dwType,
				            (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)),
                                      &dwCount);

			strValue.ReleaseBuffer();
		}

        m_strCommsType = strValue;


        // Get whether debriefing is using used.
        unsigned long int ulData = 0;
        DWORD dwSize = sizeof (unsigned long int);
        RegQueryValueEx(hKey, _T("RecordDebrief"), NULL, NULL, (BYTE*)&ulData, 
                        &dwSize);

        if (ulData == 0)
        {
            m_bRecordDebrief = FALSE;
        }
        else
        {
            m_bRecordDebrief = TRUE;
        }

        strValue = "";
        // Get the name of the IO source datafile.
		lResult = RegQueryValueEx(hKey, _T("VariablesFile"), 
                                       NULL, &dwType, NULL, &dwCount);
		if (lResult == ERROR_SUCCESS)
		{
			ASSERT(dwType == REG_SZ);
			lResult = RegQueryValueEx(hKey, _T("VariablesFile"), NULL, &dwType,
				            (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)),
                                      &dwCount);

			strValue.ReleaseBuffer();
		}

        m_strVariablesFile = strValue;

        strValue = "";
        // Get the port number.
		lResult = RegQueryValueEx(hKey, _T("Port"), 
                                       NULL, &dwType, NULL, &dwCount);
		if (lResult == ERROR_SUCCESS)
		{
			ASSERT(dwType == REG_SZ);
			lResult = RegQueryValueEx(hKey, _T("Port"), NULL, &dwType,
				            (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)),
                                      &dwCount);

			strValue.ReleaseBuffer();
		}

        m_strPort = strValue;

        // Find out what rate data should be arriving.
        strValue = "1";
		lResult = RegQueryValueEx(hKey, _T("HostRate"), 
                                       NULL, &dwType, NULL, &dwCount);
		if (lResult == ERROR_SUCCESS)
		{
			ASSERT(dwType == REG_SZ);
			lResult = RegQueryValueEx(hKey, _T("HostRate"), NULL, &dwType,
				            (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)),
                                      &dwCount);

			strValue.ReleaseBuffer();
		}

        m_fHostRate = atof((LPCTSTR)strValue);

        // Find out what rate data should be recorded for debriefing.
        strValue = "1";
		lResult = RegQueryValueEx(hKey, _T("DebriefRate"), 
                                       NULL, &dwType, NULL, &dwCount);
		if (lResult == ERROR_SUCCESS)
		{
			ASSERT(dwType == REG_SZ);
			lResult = RegQueryValueEx(hKey, _T("DebriefRate"), NULL, &dwType,
				            (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)),
                                      &dwCount);

			strValue.ReleaseBuffer();
		}

        m_fDebriefRate = atof((LPCTSTR)strValue);

        // Find out what rate data should be recorded for debriefing.
        strValue = "1";
		lResult = RegQueryValueEx(hKey, _T("ScreenUpdateRate"), 
                                       NULL, &dwType, NULL, &dwCount);
		if (lResult == ERROR_SUCCESS)
		{
			ASSERT(dwType == REG_SZ);
			lResult = RegQueryValueEx(hKey, _T("ScreenUpdateRate"), NULL, &dwType,
				            (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)),
                                      &dwCount);

			strValue.ReleaseBuffer();
		}

        m_fScreenUpdateRate = atof((LPCTSTR)strValue);

        RegCloseKey(hKey);
    }
}

/////////////////////////////////////////////////////////////////////////////
//
// void CCommsConfigPage::UpdateProperties()
//
// Inputs           : None.
//
// Return Values    : void* pWidget - for COptions property pages, pWidget
//                                    is the addrss of the name of the 
//                                    component whose configuration is being
//                                    changed or checked.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : UpdateProperties() is a common framework method that must
//                    be implemented by each CBasePage derived class. 
//                    UpdateProperties is called after the Ok or Apply button
//                    on the COptions dialog has been pressed.  Its purpose is
//                    to write the copnfiguration data to the registry.  Special
//                    code here determines if the comms protocol changed and if
//                    so creates a new comms system interface.  Also, if the
//                    IO source datafile changed, then it is reread.
//
/////////////////////////////////////////////////////////////////////////////
void CCommsConfigPage::UpdateProperties(void* pWidget)
{
    if (GetSafeHwnd() == NULL)
    {
        return;
    }

    CString strComponentName = CString((char *)pWidget);
    HKEY hKey;
    DWORD dw;

    // Open the registry.
    RegCreateKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\FSISuite\\") + strComponentName,
                 0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, &dw);

    if (hKey != NULL)
    {
        UpdateData(TRUE);

        // Write the machine name to connect to.
        RegSetValueEx(hKey, _T("MachineName"), NULL, REG_SZ, 
                      (BYTE*)(LPCTSTR)m_strMachineName,
                      m_strMachineName.GetLength() + 1);

        // Write the name of the comms protocol.
        RegSetValueEx(hKey, _T("CommsType"), NULL, REG_SZ, 
                      (BYTE*)(LPCTSTR)m_strCommsType,
                      m_strCommsType.GetLength() + 1);

        // Write whether to record debriefing information.
        unsigned long int ulData;
        dw = sizeof(unsigned long int);
        ulData = m_bRecordDebrief;
        RegSetValueEx(hKey, _T("RecordDebrief"), NULL, REG_DWORD, 
                      (BYTE*)&ulData, dw);

        // Write the path to the IO source datafile.
        RegSetValueEx(hKey, _T("VariablesFile"), NULL, REG_SZ, 
                      (BYTE*)(LPCTSTR)m_strVariablesFile,
                      m_strVariablesFile.GetLength() + 1);

        // Write the port number.
        RegSetValueEx(hKey, _T("Port"), NULL, REG_SZ, 
                      (BYTE*)(LPCTSTR)m_strPort,
                      m_strPort.GetLength() + 1);

        // Write the host rate.
        CString strValue;
        strValue.Format("%f", m_fHostRate);
        RegSetValueEx(hKey, _T("HostRate"), NULL, REG_SZ, 
                      (BYTE*)(LPCTSTR)strValue,
                      strValue.GetLength() + 1);

        // Write the debrief rate.
        strValue.Format("%f", m_fDebriefRate);
        RegSetValueEx(hKey, _T("DebriefRate"), NULL, REG_SZ, 
                      (BYTE*)(LPCTSTR)strValue,
                      strValue.GetLength() + 1);

        // Write the debrief rate.
        strValue.Format("%f", m_fScreenUpdateRate);
        RegSetValueEx(hKey, _T("ScreenUpdateRate"), NULL, REG_SZ, 
                      (BYTE*)(LPCTSTR)strValue,
                      strValue.GetLength() + 1);

        RegCloseKey(hKey);
    }
}

/////////////////////////////////////////////////////////////////////////////
//
// void CCommsConfigPage::OnVariablesButton()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 09 February 1999
//
// Engineer         : Billy Baker
//
// Description      : OnVariablesButton() handles clicks on the button 
//                    to browse for the name of the Variables file.  A 
//                    common file dialog is created and displayed.
//
/////////////////////////////////////////////////////////////////////////////
void CCommsConfigPage::OnVariablesfileButton() 
{
    // Get all of the current data.
    UpdateData(TRUE);

    CFileDialog cfd(TRUE, "fml", m_strVariablesFile,
                    OFN_SHAREAWARE | OFN_PATHMUSTEXIST | OFN_HIDEREADONLY,
                    "Variables Description File (*.fml)|*.fml|All Files (*.*)|*.*||",
                    this);

    long int lRetVal = cfd.DoModal();

    // If ok was clicked, then update the name of the file.
    if (lRetVal == IDOK)
    {
        m_strVariablesFile = cfd.GetPathName();
        UpdateData(FALSE);
    }
	
}

/////////////////////////////////////////////////////////////////////////////
//
// BOOL CCommsConfigPage::OnInitDialog()
//
// Inputs           : None.
//
// Return Values    : TRUE.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : OnInitDialog() is an override of the MFC common framework
//                    method by the same name for a CDialog derived class.  Its
//                    purpose is to fill the combobox of comms protocols with 
//                    the names of the protocols implemented in this DLL.
//
/////////////////////////////////////////////////////////////////////////////
BOOL CCommsConfigPage::OnInitDialog() 
{
	CBasePage::OnInitDialog();
	
	// TODO: Add extra initialization here
    CComboBox* pComboBox = (CComboBox*)GetDlgItem(IDC_COMMS_TYPE);

    if (pComboBox != NULL)
    {
        pComboBox->ResetContent();

        _FSI_STL::map<_FSI_STL::string, CreateComms>::iterator mIt = 
                              CCommsSystemInterface::m_mapCommsSystems.begin();
        _FSI_STL::map<_FSI_STL::string, CreateComms>::iterator mendIt = 
                              CCommsSystemInterface::m_mapCommsSystems.end();

        // Fill the combobox with the names of the implemented comms systems
        // interfaces.
        while (mIt != mendIt)
        {
            pComboBox->AddString(mIt->first.c_str());
            mIt++;
        }

        pComboBox->SelectString(-1, m_strCommsType);
    }
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
