/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : CommsComponentInterface.cpp
//
// Date             : 09 February 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.5 $
//
// Description      : CCommsComponentInterface.cpp contains the 
//                    implementation of the CCommsComponentInterface class. 
//                    CCommsComponenInterface is derived from 
//                    Core::CComponentInterface and serves as the 
//                    mechanism by which the main application can get 
//                    information about what is implemented in the DLL 
//                    without having to link against the DLL.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : Core::CComponentInterface, _FSI_STL::string, _FSI_STL::list, 
//                    _FSI_STL::map, Comms::CLocalCommsAction,
//                    Comms::CCommsAction, Comms::CCommsSystemInterface,
//                    Comms::CFSISuiteCommsSystemInterface,
//                    Comms::CDebriefCommsSystemInterface,
//                    Comms::CWTXCommsSystemInterface,
//                    Comms::CZCTCommsSystemInterface,
//                    Comms::CLocalCommsConfigPage,
//                    Comms::CCommsConfigPage, the NT Registry,
//                    CString, Comms::CLocalCommsSystemInterface.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 4
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: CommsComponentInterface.cpp $
// Revision 1.5  2000/06/08 06:48:10  billyb
// Added InitComplete.
// Revision 1.4  2000/03/06 21:34:43  billyb
// Added failure summary.
// Revision 1.3  2000/01/20 08:10:05  billyb
// Added CHostVarNameLocalCommsAction to exported actions.
// Revision 1.2  1999/11/15 00:27:38  billyb
// Added comms stats page to list of property pages.
//
#include "..\core\stdafx.h"
#include "CommsComponentInterface.h"

#include "CommsAction.h"
#include "LocalCommsAction.h"
#include "MessageLogAction.h"
#include "FailureSummaryAction.h"
#include "HostVarNameLocalCommsAction.h"

#include "CommsConfigPage.h"
#include "LocalCommsConfigPage.h"
#include "CommsStatsPage.h"

#include "DebriefCommsSystemInterface.h"
#include "FSISuiteCommsSystemInterface.h"
//#include "WTXCommsSystemInterface.h"
//#include "ZCTCommsSystemInterface.h"
#include "..\fsisuite\product_version.h"


#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// The following static members contain the date and time of the last
// compilation of this class.
const char CCommsComponentInterface::m_cRevisionDate[] = __DATE__;
const char CCommsComponentInterface::m_cRevisionTime[] = __TIME__;

/////////////////////////////////////////////////////////////////////////////
//
// CCommsComponentInterface::CCommsComponentInterface()
//
// Inputs           : _FSI_STL::string strlStrPathName - the path to the DLL 
//                                                  that was loaded.
//
// Return Values    : None.
//
// Date             : 09 February 1999
//
// Engineer         : Billy Baker
//
// Description      : Default constructor.  The date and time of the 
//                    compilation of this code is set.  Any actions 
//                    implemented in this DLL are added to a list of 
//                    actions.  Any graphical widgets implemented in 
//                    this DLL are added to a list of graphical 
//                    widgets.  Any property pages used to configure 
//                    the resources for this DLL are added to a list of 
//                    property pages.  All static CreateComms methods 
//                    implemented in CCommsSystemInterface derived 
//                    classes are added to a map.
//
/////////////////////////////////////////////////////////////////////////////
CCommsComponentInterface::CCommsComponentInterface(_FSI_STL::string stlStrPathName) :
                        CComponentInterface(_FSI_STL::string("Comms"),stlStrPathName)
{
    // Set the compile data and time.
    _FSI_STL::string stlStrDate(m_cRevisionDate);
    _FSI_STL::string stlStrTime(m_cRevisionTime);
    m_stlStrDate = stlStrDate + " " + stlStrTime;

    // Add the Actions that implemented in this DLL.
    m_listActions.push_back(CCommsAction::CreateObject);
    m_listActions.push_back(CFailureSummaryAction::CreateObject);
    m_listActions.push_back(CLocalCommsAction::CreateObject);
    m_listActions.push_back(CMessageLogAction::CreateObject);
    m_listActions.push_back(CHostVarNameLocalCommsAction::CreateObject);

    // Add the Property Pages that are implemented in this DLL.
    // These are FSISuite::CWidgetProps property pages.
    m_listPropPages.push_back(CCommsConfigPage::CreateObject);
    m_listPropPages.push_back(CLocalCommsConfigPage::CreateObject);
    m_listPropPages.push_back(CCommsStatsPage::CreateObject);

    // Initialize the data structure of all non-local COMMS systems.
    CCommsSystemInterface::m_mapCommsSystems["Debrief"] = 
                                    CDebriefCommsSystemInterface::CreateComms;

    CCommsSystemInterface::m_mapCommsSystems["FSISuite"] = 
                                    CFSISuiteCommsSystemInterface::CreateComms;

#ifdef USE_WTX    
    // Protocol for use with VxWorks.  This should only be used
    // during development.  WTX requires licenses to be purchased.
    CCommsSystemInterface::m_mapCommsSystems["WTX"] = 
                                    CWTXCommsSystemInterface::CreateComms;
#endif

//    CCommsSystemInterface::m_mapCommsSystems["ZCT"] = 
//                                    CZCTCommsSystemInterface::CreateComms;
}

/////////////////////////////////////////////////////////////////////////////
//
// CCommsComponentInterface::~CCommsComponentInterface()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 09 February 1999
//
// Engineer         : Billy Baker
//
// Description      : Default destructor.  The CCommsSystemInterface derived
//                    class that was instaniated is deleted.  The LocalComms 
//                    system is stopped and deleted if LocalComms was created.
//
/////////////////////////////////////////////////////////////////////////////
CCommsComponentInterface::~CCommsComponentInterface()
{
}

/////////////////////////////////////////////////////////////////////////////
//
// void CCommsComponentInterface::CleanComponentResources()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 13 July 1999
//
// Engineer         : Billy Baker
//
// Description      : CleanComponentResources() is a common framework method
//                    used to cleanup any resources that were probably created
//                    in InitializeComponentConfig().
//
/////////////////////////////////////////////////////////////////////////////
void CCommsComponentInterface::CleanComponentResources()
{
    CComponentInterface::CleanComponentResources();

    if (CCommsAction::m_pCommsSystemInterface != NULL)
    {
        CCommsAction::m_pCommsSystemInterface->Stop();

        delete CCommsAction::m_pCommsSystemInterface;

        CCommsAction::m_pCommsSystemInterface = NULL;
    }

    if (CLocalCommsAction::m_pLocalCommsSystemInterface != NULL)
    {
        CLocalCommsAction::m_pLocalCommsSystemInterface->Stop();

        delete CLocalCommsAction::m_pLocalCommsSystemInterface;

        CLocalCommsAction::m_pLocalCommsSystemInterface = NULL;
    }

    if (CMessageLogAction::m_pLogSystemInterface != NULL)
    {
        CMessageLogAction::m_pLogSystemInterface->Stop();

        delete CMessageLogAction::m_pLogSystemInterface;

        CMessageLogAction::m_pLogSystemInterface = NULL;
    }

    if (CFailureSummaryAction::m_pFailureSummarySystemInterface != NULL)
    {
        delete CFailureSummaryAction::m_pFailureSummarySystemInterface;

        CFailureSummaryAction::m_pFailureSummarySystemInterface = NULL;
    }
}

/////////////////////////////////////////////////////////////////////////////
//
// void CCommsComponentInterface::InitializeComponentConfig()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 09 February 1999
//
// Engineer         : Billy Baker
//
// Description      : InitializeComponentConfig() is a common framework method
//                    used to read the configuration data for this DLL from
//                    the registry.
//
/////////////////////////////////////////////////////////////////////////////
void CCommsComponentInterface::InitializeComponentConfig()
{
    CComponentInterface::InitializeComponentConfig();

    // Open the branch of the registry for this component.
    HKEY hKey;
    RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("Software\\FlightSafety\\FSISuite\\") + CString(m_stlStrComponentName.c_str()), 0, KEY_READ, &hKey);

    if (hKey != NULL)
    {
		CString strValue = "";
		DWORD dwType, dwCount;

        // Create the message logging system interface.
        CMessageLogAction::m_pLogSystemInterface = new CMessageLoggingSystemInterface();

        // Start message logging.
        if (CMessageLogAction::m_pLogSystemInterface != NULL)
        {
            CMessageLogAction::m_pLogSystemInterface->Start();
        }

        // Create the local comms system.
        CLocalCommsAction::m_pLocalCommsSystemInterface = new CLocalCommsSystemInterface();

        DWORD dwSize = sizeof (unsigned long int);

        // Get the IO source datafile name for the local comms system.
		LONG lResult = RegQueryValueEx(hKey, _T("LocalVariablesFile"), 
                                       NULL, &dwType, NULL, &dwCount);
		if (lResult == ERROR_SUCCESS)
		{
			ASSERT(dwType == REG_SZ);
			lResult = RegQueryValueEx(hKey, _T("LocalVariablesFile"), NULL, &dwType,
				            (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)),
                                      &dwCount);

			strValue.ReleaseBuffer();
		}

        // Read in the variables for the local comms system.
        if (CLocalCommsAction::m_pLocalCommsSystemInterface != NULL)
        {
            CLocalCommsAction::m_pLocalCommsSystemInterface->LoadVariables(_FSI_STL::string((LPCTSTR)strValue));
        }

        // Start local comms.
        if (CLocalCommsAction::m_pLocalCommsSystemInterface != NULL)
        {
            CLocalCommsAction::m_pLocalCommsSystemInterface->Start();
        }

        // Get the type of protocol to use to talk to simulation or a 
        // debriefing source.
        strValue = "";
		lResult = RegQueryValueEx(hKey, _T("CommsType"), 
                                       NULL, &dwType, NULL, &dwCount);
		if (lResult == ERROR_SUCCESS)
		{
			ASSERT(dwType == REG_SZ);
			lResult = RegQueryValueEx(hKey, _T("CommsType"), NULL, &dwType,
				            (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)),
                                      &dwCount);

			strValue.ReleaseBuffer();
		}

        // Create the correct protocol.
        if (CCommsSystemInterface::m_mapCommsSystems.find((LPCTSTR)strValue) != 
                                CCommsSystemInterface::m_mapCommsSystems.end())
        {
            CCommsAction::m_pCommsSystemInterface =
                CCommsSystemInterface::m_mapCommsSystems[(LPCTSTR)strValue]();
        }

        // Get whether debriefing is using used.
        unsigned long int ulData = 0;
        RegQueryValueEx(hKey, _T("RecordDebrief"), NULL, NULL, (BYTE*)&ulData, 
                        &dwSize);

        if (CCommsAction::m_pCommsSystemInterface != NULL)
        {
            if (ulData == 0)
            {
                CCommsAction::m_pCommsSystemInterface->Debrief(false);
            }
            else
            {
                CCommsAction::m_pCommsSystemInterface->Debrief(true);
            }
        }

        // Find out what machine to talk to.
        strValue = "";
		lResult = RegQueryValueEx(hKey, _T("MachineName"), 
                                       NULL, &dwType, NULL, &dwCount);
		if (lResult == ERROR_SUCCESS)
		{
			ASSERT(dwType == REG_SZ);
			lResult = RegQueryValueEx(hKey, _T("MachineName"), NULL, &dwType,
				            (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)),
                                      &dwCount);

			strValue.ReleaseBuffer();
		}

        if (CCommsAction::m_pCommsSystemInterface != NULL)
        {
            CCommsAction::m_pCommsSystemInterface->MachineName(_FSI_STL::string((LPCTSTR)strValue));
        }

        // Find out what port to talk to.
        strValue = "0";
		lResult = RegQueryValueEx(hKey, _T("Port"), 
                                       NULL, &dwType, NULL, &dwCount);
		if (lResult == ERROR_SUCCESS)
		{
			ASSERT(dwType == REG_SZ);
			lResult = RegQueryValueEx(hKey, _T("Port"), NULL, &dwType,
				            (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)),
                                      &dwCount);

			strValue.ReleaseBuffer();
		}

        if (CCommsAction::m_pCommsSystemInterface != NULL)
        {
            CCommsAction::m_pCommsSystemInterface->Port(atoi((LPCSTR)strValue));
        }

        // Find out what rate data should be arriving.
        strValue = "30";
		lResult = RegQueryValueEx(hKey, _T("HostRate"), 
                                       NULL, &dwType, NULL, &dwCount);
		if (lResult == ERROR_SUCCESS)
		{
			ASSERT(dwType == REG_SZ);
			lResult = RegQueryValueEx(hKey, _T("HostRate"), NULL, &dwType,
				            (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)),
                                      &dwCount);

			strValue.ReleaseBuffer();
		}

        if (CCommsAction::m_pCommsSystemInterface != NULL)
        {
            CCommsAction::m_pCommsSystemInterface->Rate(atof((LPCSTR)strValue));
        }

        // Find out what rate data should be recorded for debriefing.
        strValue = "15";
		lResult = RegQueryValueEx(hKey, _T("DebriefRate"), 
                                       NULL, &dwType, NULL, &dwCount);
		if (lResult == ERROR_SUCCESS)
		{
			ASSERT(dwType == REG_SZ);
			lResult = RegQueryValueEx(hKey, _T("DebriefRate"), NULL, &dwType,
				            (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)),
                                      &dwCount);

			strValue.ReleaseBuffer();
		}

        if (CCommsAction::m_pCommsSystemInterface != NULL)
        {
            CCommsAction::m_pCommsSystemInterface->DebriefRate(atof((LPCSTR)strValue));
        }

        // Find out what rate the screen should be updated.
        strValue = "30";
		lResult = RegQueryValueEx(hKey, _T("ScreenUpdateRate"), 
                                       NULL, &dwType, NULL, &dwCount);
		if (lResult == ERROR_SUCCESS)
		{
			ASSERT(dwType == REG_SZ);
			lResult = RegQueryValueEx(hKey, _T("ScreenUpdateRate"), NULL, &dwType,
				            (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)),
                                      &dwCount);

			strValue.ReleaseBuffer();
		}

        if (CCommsAction::m_pCommsSystemInterface != NULL)
        {
            CCommsAction::m_pCommsSystemInterface->ScreenUpdateRate(atof((LPCSTR)strValue));
        }

        // Get the IO source datafile name.
        strValue = "";
		lResult = RegQueryValueEx(hKey, _T("VariablesFile"), 
                                       NULL, &dwType, NULL, &dwCount);
		if (lResult == ERROR_SUCCESS)
		{
			ASSERT(dwType == REG_SZ);
			lResult = RegQueryValueEx(hKey, _T("VariablesFile"), NULL, &dwType,
				            (LPBYTE)strValue.GetBuffer(dwCount/sizeof(TCHAR)),
                                      &dwCount);

			strValue.ReleaseBuffer();
		}

        // Read in the variables.
        if (CCommsAction::m_pCommsSystemInterface != NULL)
        {
            CCommsAction::m_pCommsSystemInterface->LoadVariables(_FSI_STL::string((LPCTSTR)strValue));
        }

        RegCloseKey(hKey);
    }

    if (CCommsAction::m_pCommsSystemInterface != NULL)
    {
        CCommsAction::m_pCommsSystemInterface->Start();
    }

    CFailureSummaryAction::m_pFailureSummarySystemInterface = new CFailureSummarySystemInterface;
}

void CCommsComponentInterface::InitComplete()
{
    if (CCommsShared::m_pCommsSystemInterface != NULL)
    {
        CCommsShared::m_pCommsSystemInterface->InitComplete();
    }
}