/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : CommsAction.cpp
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.21 $
//
// Description      : CommsAction.cpp contains the implementation of the 
//                    CCommsAction class.  This action is derived from 
//                    Core::CIOAction.  Its purpose is to distribute a 
//                    value to a graphical element in its OnUpdate 
//                    member.  This member is called from 
//                    CCommsSystemInterface::UpdateComms().  
//                    CCommsSystemInterface keeps track of all 
//                    CCommsAction instances so that it may update all 
//                    of them.  Each CCommsAction instance shares a 
//                    single CVariant instance.  Thus, many graphical 
//                    elements may want the value of a variable and 
//                    each graphical element will have an instance of a 
//                    CCommsAction to read that variable.  However, the 
//                    value will be read from simulation once and 
//                    placed in the shared CVariant.  CCommsAction will 
//                    also update simulation variable in OnLButtonUp.  
//                    This member will be called whenever an action 
//                    occurs on a graphical element.  The action might 
//                    be clicking a button or pressing the 
//                    enter/carriage return key while in an editbox.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : Core::CIOAction, Core::CWidget, Comms::CCommsShared, 
//                    Core::CVariant, _FSI_STL::string, _FSI_STL::list, _FSI_STL::map, 
//                    _FSI_STL::vector, Comms::CCommsSystemInterface, 
//                    Core::CChangeValue, Core::CRange.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 4
//                                          Microsoft Windows NT 2000
//
//                    Compiler(s) - Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: CommsAction.cpp $
// Revision 1.21  2000/06/16 20:45:26  billyb
// Fix type problems with ArrayOffset.
// Revision 1.20  2000/06/08 06:48:32  billyb
// Revised locking scheme.
// Revision 1.19  2000/03/31 22:27:41  billyb
// Removed help text.  Added additional conditional in Deleting().
// Revision 1.18  2000/03/06 21:32:29  billyb
// Added const to references to eliminate warnings.
// Revision 1.16  2000/02/09 18:41:43  billyb
// Removed limit for not sending full arrays to the host.
// Revision 1.15  2000/02/07 07:48:22  billyb
// Reverted to old locking scheme.
// Revision 1.14  2000/02/04 09:56:07  billyb
// Moved Lock down in OnLButtonUp.  Moved ChangeType
// up before getting the desired element.
// Revision 1.13  2000/01/27 23:27:53  billyb
// Changed OnLButtonUp to not write to host for entire array.
// Revision 1.12  2000/01/27 19:49:42  billyb
// Support for arrays.
// Revision 1.11  1999/12/31 16:34:55  billyb
// Changed default name to "HOST ".
// Revision 1.10  1999/11/15 00:28:11  billyb
// Added additional conditional for checking for a NULL pointer.
// Revision 1.9  1999/11/06 22:39:29  billyb
// Remove continuation for string.  VTune would not parse with
// it.
// Revision 1.8  1999/11/04 19:53:51  billyb
// Changed for loop to while and added variable for map end()
// call to decrease calls to end().  Changed size() call to empty()
// since size() is a calculation and empty() is an accessor for
// a member variable.
// Revision 1.7  1999/10/21 01:39:50  billyb
// Optimized loops in OnUpdate.
// Revision 1.6  1999/10/20 18:34:38  billyb
// Added MsgThread method which is called when an invalid
// entry is entered and range checking is available.  Changed
// OnLButtonUp to return an enum.  Added range checking
// to OnLButtonUp.
// Revision 1.5  1999/09/24 17:13:47  billyb
// Added conversion to OnLButtonUp so that converted
// data will be unconverted before it is sent to the host.
// Revision 1.4  1999/09/02 19:51:50  billyb
// Moved include for format page from IOAction.h to here.
// Revision 1.3  1999/09/02 17:09:42  billyb
// Added using data conversion information to convert the 
// new data in OnUpdate before calling ChangeValue.
// Made sure that the initial data format was set when using
// the page editor.
// Revision 1.2  1999/08/30 22:20:10  billyb
// Added FormatPage to list of property pages for the editor.  
// Changed the precision of the variant based on any precision 
// data specific to an instance of a CommsAction.
// Revision 1.1  1999/04/02 19:41:28  billyb
/////////////////////////////////////////////////////////////////////////////
#include "..\core\stdafx.h"
#include "CommsAction.h"

#include "CommsActionPage.h"
#include "..\core\RangePage.h"
#include "..\core\FormatPage.h"

#include "..\core\DataConversion.h"

#include <algorithm>

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

_FSI_STL::string  CCommsAction::m_stlStrError;

UINT CCommsAction::MsgThread(LPVOID param)
{
    ::MessageBox(NULL, 
                 _T(m_stlStrError.c_str()), 
                 _T("Invalid Range"), 
                 MB_OK | MB_ICONERROR | MB_SYSTEMMODAL);
    return 0;
}

/////////////////////////////////////////////////////////////////////////////
//
// CCommsACtion::CCommsAction
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : Default constructor.  Sets the name of the widget.
//                    Adds the CCommsActionPage to the list of widget
//                    property pages.
/////////////////////////////////////////////////////////////////////////////
CCommsAction::CCommsAction()
{
    m_stlStrWidgetName = _FSI_STL::string("IOS_Comms");

    m_listWidgetPropPages.push_back(CCommsActionPage::CreateObject);
    m_listWidgetPropPages.push_back(CRangePage::CreateObject);
    m_listWidgetPropPages.push_back(CFormatPage::CreateObject);

    m_bFirstDelete = true;
    m_bInitialized = false;
}

/////////////////////////////////////////////////////////////////////////////
//
// CCommsACtion::~CCommsAction
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : Default destructor.  If a CCommsSystemInterface derived
//                    class has been instaniated, then an attempt is made to
//                    remove this instance of CCommsAction from the list of
//                    CCommsAction instances managed by the 
//                    CCommsSystemInterface derived class.
//
/////////////////////////////////////////////////////////////////////////////
CCommsAction::~CCommsAction()
{
}

/////////////////////////////////////////////////////////////////////////////
//
// void CCommsACtion::Initialize()
//
// Inputs           : CXMLWidget*& rpXMLWidget - pointer to return a new 
//                                               instance of a CXMLWidget.
//                    CWnd* pWnd - the parent of this widget.
//                    const long lId - the control ID.
//                    bool bEditMode - whether this widget is being created 
//                                     in the editor or the runtime.
//
// Return Values    : None.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : Initialize() is a common framework method that must be
//                    implemented by each CWidget derived class.  Besides 
//                    standard initialization code for a CAction and CWidget
//                    derived class, the CCommsSystemInterface derived class
//                    is started if it has not already been started. 
//
/////////////////////////////////////////////////////////////////////////////
void CCommsAction::Initialize(CXMLWidget*& rpXMLWidget, CWnd* pWnd, 
                                const long lId, bool bEditMode)
{
    if (m_pCommsSystemInterface != NULL && lId != 0)
    {
        // Start comms if it hasn't been started and we're not editing.
        if (m_pCommsSystemInterface->Started() == false && m_bEditing == false)
        {
            m_pCommsSystemInterface->Start();
        }
    }

    // Set the help text.
    if (rpXMLWidget == NULL)
    {
        m_stlStrName = "HOST ";
    }

    // Call the base class.
    CWidget::Initialize(rpXMLWidget,pWnd, lId, bEditMode);

    // Set the action and widget pointers.
    m_pAction = this;
    m_pWidget = (CWidget*)this;

    if (rpXMLWidget != NULL)
    {
        m_pIOActionXMLWidget = m_pXMLWidget;
        ResetProperties();
    }

    m_bInitialized = true;
}

/////////////////////////////////////////////////////////////////////////////
//
// CWidget* CCommsACtion::CreateObject()
//
// Inputs           : None.
//
// Return Values    : Address of a new instance of CCommsAction.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : CreateObject() is a common framework method that must be
//                    implemented by each CWidget derived class.  The main
//                    application associates the name of this widget with this
//                    static CreateObject method so that a new object can be
//                    created without linking against the library that contains
//                    this class.
//
/////////////////////////////////////////////////////////////////////////////
CWidget* CCommsAction::CreateObject()
{
    return new CCommsAction();
}

/////////////////////////////////////////////////////////////////////////////
//
// void CCommsACtion::ResetProperties()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : ResetProperties() is a common framework method that 
//                    should be implemented by each CWidget derived class.  
//                    ResetProperties is called when a new instance is created
//                    as well as when the widget props dialog is used to change
//                    properties. 
//
/////////////////////////////////////////////////////////////////////////////
void CCommsAction::ResetProperties()
{
    m_sync.Lock();
    CWidget::ResetProperties();
    CIOAction::ResetProperties();

    // If we're not editing and the comms system has been created,
    // add this commsaction to the comms system.
    if (m_bEditing == false && m_pCommsSystemInterface != NULL)
    {
        m_pCommsSystemInterface->ToAdd(this);
    }
    else if (m_bEditing == true && m_pCommsSystemInterface != NULL)
    {
        const _FSI_STL::string& stlStrName = Variable();

        // Make sure pCommsAction's variables are in the list of varaibles.
        if (m_pCommsSystemInterface->m_mapVarName2Data.find(stlStrName) != 
                              m_pCommsSystemInterface->m_mapVarName2Data.end())
        {
            if (m_pCommsSystemInterface->m_mapVarName2Ranges.find(stlStrName) != 
                            m_pCommsSystemInterface->m_mapVarName2Ranges.end())
            {
                _FSI_STL::list<CRange*>::iterator lIt = 
                   m_pCommsSystemInterface->m_mapVarName2Ranges[stlStrName].begin();
                _FSI_STL::list<CRange*>::iterator lendIt = 
                   m_pCommsSystemInterface->m_mapVarName2Ranges[stlStrName].end();

                while (lIt != lendIt) 
                {
                    AddRange((*lIt));
                    lIt++;
                }
            }

            m_lInitialDataFormat = m_pCommsSystemInterface->m_mapVarName2Data[stlStrName]->InitialDataFormat();
        }
    }

    m_sync.Unlock();
}

/////////////////////////////////////////////////////////////////////////////
//
// enum LButtonUpReturn CCommsACtion::OnLButtonUp()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : OnLButtonUp() is a common framework method for CAction
//                    derived classes.  Its purpose is to perform a action 
//                    based on some user interaction with the graphical 
//                    element to which the instance of this class is attached.
//                    In this case, OnLButtonUp is used to get a value from
//                    the graphical element to then write to simulation.
//
/////////////////////////////////////////////////////////////////////////////
enum LButtonUpReturn CCommsAction::OnLButtonUp()
{
    if (m_bCanWrite == false)
        return LBU_CAN_NOT_WRITE;

    if (m_bDeleting == true)
    {
        // Since memory is going away, the parent is probably
        // going away as well.  Let the parent think that
        // everything went ok.  Or, no write can take place
        return LBU_OK;
    }

    if (m_pCommsSystemInterface == NULL)
        return LBU_NO_COMMS;

    CVariableData* pVarData = NULL;

    if (m_pCommsSystemInterface->m_mapVarName2Data.find(m_stlStrVariableToWatch) !=
        m_pCommsSystemInterface->m_mapVarName2Data.end())
    {
        // Get the variable data to change the type.
        pVarData = 
            m_pCommsSystemInterface->m_mapVarName2Data[m_stlStrVariableToWatch];

        if (pVarData == NULL)
            return LBU_OK;
    }
    else
    {
        return LBU_OK;
    }

    CVariant variant;

    m_sync.Lock();

    // Make sure this instance is attached to a graphical element.
    if (CWidget::IsValidAddress(m_pParentWidget) != VALID )
    {
        m_sync.Unlock();
        return LBU_OK;
    }

    if (m_bUseSpecificRange == true && m_pRange != NULL)
    {
        variant = m_pRange->Lower();
        variant.ChangeType(pVarData->Type());
    }
    else
    {
        // Get the value from the parent graphical element.
        CVariant  *pVariant   =  m_pParentWidget->GetValue(CString(m_stlStrElementVar.c_str()));

        if (pVariant != NULL)
        {
            variant = *pVariant;
            variant.ChangeType(pVarData->Type());
            variant = variant[m_lElement];
        }
        else
        {
            m_sync.Unlock();
            return LBU_OK;
        }
    }

    // Perform range check before data conversion because the parent widget
    // will have a high and low in terms of the convert type if a conversion
    // was desired.
    if (!m_vectRanges.empty())
    {
        variant.LimitFloating(m_bLimitFloating);
        variant.Precision(m_ucPrecision);
        if (m_pParentWidget->RangeLow(m_stlStrElementVar) > variant  ||
            m_pParentWidget->RangeHigh(m_stlStrElementVar) < variant)
        {
           CString   error;
           CString   data( (char *) ((_FSI_STL::string)variant).c_str() );
           CString   low(  (char *) ((_FSI_STL::string)(m_pParentWidget->RangeLow(m_stlStrElementVar))).c_str() );
           CString   high( (char *) ((_FSI_STL::string)(m_pParentWidget->RangeHigh(m_stlStrElementVar))).c_str() );
           error.Format("Sorry, %s is not a valid entry.\nThe valid range is %s to %s", data, low, high);
           m_stlStrError   =  (LPCTSTR)error;

           AfxBeginThread(MsgThread, (LPVOID)0);

           m_sync.Unlock();
           return LBU_NOT_IN_RANGE;
        }
    }

    m_sync.Unlock();


    // See the parent widget is using a converted data value.  If so,
    // then convert it back to the format in which it came form the host.
    if (m_lDataFormat != m_lInitialDataFormat &&
        m_lDataFormat != Generic_No_Conversions)
    {
        variant = CDataConversion::Convert(variant, 
                                           (DATA_FORMATS)m_lDataFormat,
                                           (DATA_FORMATS)m_lInitialDataFormat);
    }

    long lOffset = pVarData->ArrayOffset();
    pVarData->ArrayOffset(m_lElement);

    // Call the instantiated CCommsSystemInterface derived class' 
    // WriteData member to update simulation.
    m_pCommsSystemInterface->WriteData(&variant, pVarData);

    pVarData->ArrayOffset(lOffset);

    return LBU_OK;
}

/////////////////////////////////////////////////////////////////////////////
//
// void CCommsACtion::OnUpdate()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 08 February 1999
//
// Engineer         : Billy Baker
//
// Description      : OnUpdate() is a common framework method for CAction
//                    derived classes.  Its purpose is to send a new value
//                    to its parent graphical widget.  OnUpdate should 
//                    generally be called by some other class than the parent 
//                    graphical element.
//
/////////////////////////////////////////////////////////////////////////////
void CCommsAction::OnUpdate()
{
    if (m_bDeleting == true)
        return;

    // Make sure there is a Variant will a value to send to the parent
    // graphical widget.
    if (m_pVariant == NULL)
        return;

    // Depending on the read_mode--read always, read changed, read never, 
    // or read_once-- update the parent graphical widget.  Also, if a read
    // has not been performed once and the read_mode is not read never, then
    // go ahead and get an initial value. 
    if (((m_bReadOnce    == true  && m_bRead == false) || 
         (m_bReadChanged == true  && m_pVariant->WasChanged(m_lElement) == true) || 
         (m_bReadAlways  == true) || 
         (m_bInitialRead == true)) && 
        (m_bReadOnce == true || m_bReadChanged == true || m_bReadAlways == true))
    {
        CString strElementVar(m_stlStrElementVar.c_str());
        CVariant variant;
        if (m_pVariant->Length() == 1 || m_lElement == -1)
            variant = *m_pVariant;
        else
            variant = (*m_pVariant)[m_lElement];

        // Run through any attached ranges to see if the current value is
        // in one of the ranges.
        int nRangeSize = m_vectRanges.size();
        if (nRangeSize > 0 && m_bUseGenericRange == true)
        {
            int nRangeStep = 0;
            bool bDone = false;
            while (nRangeStep < nRangeSize)
            {
                // Evaluate the range for the value pointed to by m_pVariant.
                if (m_vectRanges[nRangeStep]->Evaluate(variant) == true)
                {
                    // The range evaluated to true.  Reset m_ChangeValue to 
                    // match the range that was true.
                    m_ChangeValue.Text(m_vectRanges[nRangeStep]->TextTrue());
                    m_ChangeValue.Background(m_vectRanges[nRangeStep]->BackgroundTrue());
                    m_ChangeValue.Foreground(m_vectRanges[nRangeStep]->ForegroundTrue());
                    bDone = true;
                    break;
                }

                nRangeStep++;
            }

            m_ChangeValue.TrueOrFalseValue(bDone);
        }
        else if (m_bUseSpecificRange == true && m_pRange != NULL)
        {
            if (m_pRange->Evaluate(variant) == true)
            {
                // The range evaluated to true.  Reset m_ChangeValue to 
                // match the range that was true.
                m_ChangeValue.Text(m_pRange->TextTrue());
                m_ChangeValue.Background(m_pRange->BackgroundTrue());
                m_ChangeValue.Foreground(m_pRange->ForegroundTrue());
                m_ChangeValue.TrueOrFalseValue(true);
            }
            else
            {
                // The range evaluated to true.  Reset m_ChangeValue to 
                // match the range that was true.
                m_ChangeValue.Text(m_pRange->TextFalse());
                m_ChangeValue.Background(m_pRange->BackgroundFalse());
                m_ChangeValue.Foreground(m_pRange->ForegroundFalse());
                m_ChangeValue.TrueOrFalseValue(false);
            }
        }

        // Send the new value to the parent graphical widget.
        // m_bUseRange will tell the parent whether to use the m_pVariant
        // value of the data for colors and text.
        m_ChangeValue.UseRange(m_bUseRange);

        m_sync.Lock();

        if (!(CWidget::IsValidAddress(m_pParentWidget) != VALID))
        {
            if (m_lElement > -1 &&
                m_lDataFormat != m_lInitialDataFormat &&
                m_lDataFormat != Generic_No_Conversions)
            {
                CVariant varConverted;

                varConverted = CDataConversion::Convert(variant, 
                                                        (DATA_FORMATS)m_lInitialDataFormat,
                                                        (DATA_FORMATS)m_lDataFormat);
                m_ChangeValue.Variant(&varConverted);

                varConverted.LimitFloating(m_bLimitFloating);
                varConverted.Precision(m_ucPrecision);

                // Put here so that varConverted will still be in scope.
                m_pParentWidget->ChangeValue(strElementVar, &m_ChangeValue);
            }
            else
            {
                m_ChangeValue.Variant(&variant);

                variant.LimitFloating(m_bLimitFloating);
                variant.Precision(m_ucPrecision);

                m_pParentWidget->ChangeValue(strElementVar, &m_ChangeValue);
            }

            if (m_pCommsSystemInterface != NULL)
                m_pCommsSystemInterface->ToRefresh(m_pParentWidget);

            // If this is a read once initializer, then mark as being read.
            if (m_bReadOnce == true)
                m_bRead = true;

            m_bInitialRead = false;
        }

        m_sync.Unlock();
    }
}

void CCommsAction::Deleting(bool bDeleting)
{
    if (m_pCommsSystemInterface != NULL && 
        m_bFirstDelete == true          &&
        m_bInitialized == true          &&
        bDeleting      == true)
    {
        CWidget::Deleting(false);
        m_pCommsSystemInterface->ToDelete(this);

        m_bFirstDelete = false;
    }
    else
    {
        // Don't need to delete from CommsSystem since
        // it could not have been added if it was NULL.
        CWidget::Deleting(bDeleting);
    }
}

