/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : AutotestComponentInterface.cpp
//
// Date             : 10 April 2000
//
// Engineer         : Billy Baker
//
// Revision         : $Revision$
//
// Description      : CAutotestComponentInterface is derived from 
//                    CComponentInterface.  CComponentInterface is the 
//                    contract that all plugin components to the 
//                    framework must implement in the form of a derived 
//                    class.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : None.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3
//                                          Microsoft Windows NT 5.0
//
//                    Compiler(s) - Visual C++ 5.0 with VisC++ service pack 3
//                                  Visual C++ 6.0
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log$
/////////////////////////////////////////////////////////////////////////////
#include "..\core\stdafx.h"
#include "AutotestComponentInterface.h"
#include "..\comms\CommsShared.h"
#include "..\fsisuite\product_version.h"

// The following static members contain the date and time of the last
// compilation of this class.
const char CAutotestComponentInterface::m_cRevisionDate[] = __DATE__;
const char CAutotestComponentInterface::m_cRevisionTime[] = __TIME__;
_FSI_STL::string CAutotestComponentInterface::m_stlStrFortranPath;

typedef void (*_SetFunctionPointers)(void*, void*, void*, void*, void*, 
                                     void*, void*, void*, void*, void*);
typedef void (*_FatControl)();

_SetFunctionPointers sfp    = NULL;
_FatControl fc              = NULL;
HINSTANCE hDLL              = NULL;

void SetHostReal(char* pcVariableName, unsigned int unLength, 
                            float *pfValue)
{
    CVariant variant;
    variant.Value(*pfValue);

    _FSI_STL::string stlStrVarName;
    stlStrVarName.assign(pcVariableName, unLength);

    CCommsShared::SetHostValue(variant, stlStrVarName, 0);
}

void SetHostInt(char* pcVariableName, unsigned int unLength, 
                            int *pnValue)
{
    CVariant variant;
    variant.Value((long)*pnValue);

    _FSI_STL::string stlStrVarName;
    stlStrVarName.assign(pcVariableName, unLength);

    CCommsShared::SetHostValue(variant, stlStrVarName, 0);
}

void SetLocalReal(char* pcVariableName, unsigned int unLength, 
                            float *pfValue)
{
    CVariant variant;
    variant.Value(*pfValue);

    _FSI_STL::string stlStrVarName;
    stlStrVarName.assign(pcVariableName, unLength);

    CCommsShared::SetLocalValue(variant, stlStrVarName, 0);
}

void SetLocalInt(char* pcVariableName, unsigned int unLength, 
                            int *pnValue)
{
    CVariant variant;
    variant.Value((long)*pnValue);

    _FSI_STL::string stlStrVarName;
    stlStrVarName.assign(pcVariableName, unLength);

    CCommsShared::SetLocalValue(variant, stlStrVarName, 0);
}

void SetHostRealArray(char* pcVariableName, unsigned int unLength,
                                int* pnArrayLength, float *pfArray)
{
    CVariant variant;
    _FSI_STL::string stlStrVarName;

    stlStrVarName.assign(pcVariableName, unLength);

    int j = 0;
    while (j < *pnArrayLength)
    {
        variant.Value(pfArray[j]);
        CCommsShared::SetHostValue(variant, stlStrVarName, j);

        j++;
    }
}

void SetHostIntArray(char* pcVariableName, unsigned int unLength,
                                int* pnArrayLength, int* pnArray)
{
    CVariant variant;
    _FSI_STL::string stlStrVarName;

    stlStrVarName.assign(pcVariableName, unLength);

    int j = 0;
    while (j < *pnArrayLength)
    {
        variant.Value((long)pnArray[j]);
        CCommsShared::SetHostValue(variant, stlStrVarName, j);

        j++;
    }
}

float GetHostReal(char* pcVariableName, unsigned int unLength)
{
    CVariant variant;

    _FSI_STL::string stlStrVarName;
    stlStrVarName.assign(pcVariableName, unLength);

    CCommsShared::GetHostValue(variant, stlStrVarName);

    return (float)variant;
}

int GetHostInt(char* pcVariableName, unsigned int unLength)
{
    CVariant variant;

    _FSI_STL::string stlStrVarName;
    stlStrVarName.assign(pcVariableName, unLength);

    CCommsShared::GetHostValue(variant, stlStrVarName);

    return (int)(long)variant;
}

float GetLocalReal(char* pcVariableName, unsigned int unLength)
{
    CVariant variant;

    _FSI_STL::string stlStrVarName;
    stlStrVarName.assign(pcVariableName, unLength);

    CCommsShared::GetLocalValue(variant, stlStrVarName);

    return (float)variant;
}

int GetLocalInt(char* pcVariableName, unsigned int unLength)
{
    CVariant variant;

    _FSI_STL::string stlStrVarName;
    stlStrVarName.assign(pcVariableName, unLength);

    CCommsShared::GetLocalValue(variant, stlStrVarName);

    return (int)(long)variant;
}

void UpdateAutotest()
{
    if (fc != NULL)
    {
        fc();
    }
}

/////////////////////////////////////////////////////////////////////////////
//
// CAutotestComponentInterface::CAutotestComponentInterface()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 10 April 2000
//
// Engineer         : Billy Baker
//
// Description      : CAutotestComponentInterface::CAutotestComponentInterface is 
//                    the default constuctor for this class.  It 
//                    initializes the map of option pages, initializes 
//                    the string with the date and time of compilation, 
//                    and initializes the name of the component.
//
/////////////////////////////////////////////////////////////////////////////
CAutotestComponentInterface::CAutotestComponentInterface(_FSI_STL::string stlStrPathName) :
            CComponentInterface(_FSI_STL::string("Autotest"),stlStrPathName)
{
    _FSI_STL::string stlStrDate(m_cRevisionDate);
    _FSI_STL::string stlStrTime(m_cRevisionTime);

    m_stlStrDate = stlStrDate + " " + stlStrTime;

    CString str(stlStrPathName.c_str());
    str = str.Left(str.ReverseFind('\\') + 1) + "for_at.dll";

    m_stlStrFortranPath  = _FSI_STL::string((LPCTSTR)str);
}

/////////////////////////////////////////////////////////////////////////////
//
// CAutotestComponentInterface::~CAutotestComponentInterface()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 10 April 2000
//
// Engineer         : Billy Baker
//
// Description      : CAutotestComponentInterface::~CAutotestComponentInterface 
//                    is the default destructor for this class.  It 
//                    does not need to delete the option pages since 
//                    they are attached to a window when they are 
//                    created and will be delete when that window is 
//                    destroyed.  The pointers in the map, though, are 
//                    freed with a call to the map clear() method in the
//                    base destructor.
//
/////////////////////////////////////////////////////////////////////////////
CAutotestComponentInterface::~CAutotestComponentInterface()
{
}

/////////////////////////////////////////////////////////////////////////////
//
// void CAutotestComponentInterface::InitializeComponentConfig()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 14 April 2000
//
// Engineer         : Billy Baker
//
// Description      : InitializeComponentConfig() is a common framework method
//                    used to read the configuration data for this DLL from
//                    the registry.
//
/////////////////////////////////////////////////////////////////////////////
void CAutotestComponentInterface::InitializeComponentConfig()
{
    CComponentInterface::InitializeComponentConfig();

    // Load the library.
    hDLL = AfxLoadLibrary(m_stlStrFortranPath.c_str());
    if (hDLL != NULL)
    {
        fc = (_FatControl)GetProcAddress(hDLL, "FAT_CONTROL");

        sfp = (_SetFunctionPointers)GetProcAddress(hDLL, "SetFunctionPointers");

        if (sfp != NULL)
        {   
            sfp(SetHostReal,        SetHostInt, 
                SetLocalReal,       SetLocalInt,
                SetHostRealArray,   SetHostIntArray,
                GetHostReal,        GetHostInt,
                GetLocalReal,       GetLocalInt);
        }
    }

    CCommsShared::AddUpdateCallback(UpdateAutotest);
}

/////////////////////////////////////////////////////////////////////////////
//
// void CAutotestComponentInterface::CleanComponentResources()
//
// Inputs           : None.
//
// Return Values    : None.
//
// Date             : 14 April 2000
//
// Engineer         : Billy Baker
//
// Description      : CleanComponentResources() is a common framework method
//                    used to cleanup any resources that were probably created
//                    in InitializeComponentConfig().
//
/////////////////////////////////////////////////////////////////////////////
void CAutotestComponentInterface::CleanComponentResources()
{
    CComponentInterface::CleanComponentResources();

    CCommsShared::DeleteUpdateCallback(UpdateAutotest);

    if (hDLL != NULL)
    {
        fc  = NULL;
        sfp = NULL;

        AfxFreeLibrary(hDLL);
    }
}