#include <windows.h>
#include "c_autotest_int.h"

static CPP_SetHostReal          SetHostReal         = NULL;
static CPP_SetHostInt           SetHostInt          = NULL;
static CPP_SetLocalReal         SetLocalReal        = NULL;
static CPP_SetLocalInt          SetLocalInt         = NULL;
static CPP_SetHostRealArray     SetHostRealArray    = NULL;
static CPP_SetHostIntArray      SetHostIntArray     = NULL;
static CPP_GetHostReal          GetHostReal         = NULL;
static CPP_GetHostInt           GetHostInt          = NULL;
static CPP_GetLocalReal         GetLocalReal        = NULL;
static CPP_GetLocalInt          GetLocalInt         = NULL;


extern "C"
{
    _declspec(dllexport) void SetFunctionPointers(void *sethostreal,
                                                  void *sethostint,
                                                  void *setlocalreal,
                                                  void *setlocalint,
                                                  void *sethostrealarray,
                                                  void *sethostintarray,
                                                  void *gethostreal,
                                                  void *gethostint,
                                                  void *getlocalreal,
                                                  void *getlocalint)
    {
        SetHostReal         =   (CPP_SetHostReal)sethostreal;
        SetHostInt          =   (CPP_SetHostInt)sethostint;
        SetLocalReal        =   (CPP_SetLocalReal)setlocalreal;
        SetLocalInt         =   (CPP_SetLocalInt)setlocalint;
        SetHostRealArray    =   (CPP_SetHostRealArray)sethostrealarray;
        SetHostIntArray     =   (CPP_SetHostIntArray)sethostintarray;
        GetHostReal         =   (CPP_GetHostReal)gethostreal;
        GetHostInt          =   (CPP_GetHostInt)gethostint;
        GetLocalReal        =   (CPP_GetLocalReal)getlocalreal;
        GetLocalInt         =   (CPP_GetLocalInt)getlocalint;
    }

    void __stdcall SETHOSTREAL(char* pcVariableName, unsigned int unLength, 
                                float *pfValue)
    {
        if (SetHostReal != NULL)
        {
            SetHostReal(pcVariableName, unLength, pfValue);
        }
    }

    void __stdcall SETHOSTINT(char* pcVariableName, unsigned int unLength, 
                                int *pnValue)
    {
        if (SetHostInt != NULL)
        {
            SetHostInt(pcVariableName, unLength, pnValue);
        }
    }

    void __stdcall SETHOSTREALARRAY(char* pcVariableName, unsigned int unLength,
                                    int* pnArrayLength, float *pfArray)
    {
        if (SetHostRealArray != NULL)
        {
            SetHostRealArray(pcVariableName, unLength, pnArrayLength, pfArray);
        }
    }

    void __stdcall SETHOSTINTARRAY(char* pcVariableName, unsigned int unLength,
                                    int* pnArrayLength, int* pnArray)
    {
        if (SetHostIntArray != NULL)
        {
            SetHostIntArray(pcVariableName, unLength, pnArrayLength, pnArray);
        }
    }

    void __stdcall SETLOCALREAL(char* pcVariableName, unsigned int unLength, 
                                float *pfValue)
    {
        if (SetLocalReal != NULL)
        {
            SetLocalReal(pcVariableName, unLength, pfValue);
        }
    }

    void __stdcall SETLOCALINT(char* pcVariableName, unsigned int unLength, 
                                int *pnValue)
    {
        if (SetLocalInt != NULL)
        {
            SetLocalInt(pcVariableName, unLength, pnValue);
        }
    }

    float __stdcall GETHOSTREAL(char* pcVariableName, unsigned int unLength)
    {
        if (GetHostReal != NULL)
        {
            return GetHostReal(pcVariableName, unLength);
        }

        return 0.0f;
    }

    int __stdcall GETHOSTINT(char* pcVariableName, unsigned int unLength)
    {
        if (GetHostInt != NULL)
        {
            return GetHostInt(pcVariableName, unLength);
        }

        return 0;
    }

    float __stdcall GETLOCALREAL(char* pcVariableName, unsigned int unLength)
    {
        if (GetLocalReal != NULL)
        {
            return GetLocalReal(pcVariableName, unLength);
        }

        return 0.0f;
    }

    int __stdcall GETLOCALINT(char* pcVariableName, unsigned int unLength)
    {
        if (GetLocalInt != NULL)
        {
            return GetLocalInt(pcVariableName, unLength);
        }

        return 0;
    }
}
