-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Hydraulics_Types;
with Force_Types;

package Jpats_Hydraulics is

   function Pump_Shaft_Horsepower return Float;

   function Primary_System_Pressure_Function
     return Jpats_Hydraulics_Types.Normalized_Pressure_Type;
   function Emergency_System_Pressure_Function
     return Jpats_Hydraulics_Types.Normalized_Pressure_Type;
   function HYDR_FL_LO_Annunciator_Request
     return Boolean;
   function HYDR_PX_LO_Annunciator_Request
     return Boolean;
   function EMERG_HYDR_PX_LO_Annunciator_Request
     return Boolean;
   function Primary_Hyd_Px return Force_Types.Psi;

   procedure Reset_Emerg_Hyd_Px;

end Jpats_Hydraulics;
