-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Hydraulics.Container;
with Jpats_Electrical;
with Jpats_Electrical_Types;
with Log;

package body Jpats_Hydraulics is

   function Pump_Shaft_Horsepower
     return Float
   is
      package Ctnr renames Container;
   begin
      return Ctnr.Pump.Shaft_Horsepower(Ctnr.This_Subsystem.The_Pump);
   exception
      when others =>
         Log.Report("Jpats_Hydraulics.Primary_System_Pressure_Function()");
         raise;
   end Pump_Shaft_Horsepower;


   function Primary_System_Pressure_Function
     return Jpats_Hydraulics_Types.Normalized_Pressure_Type
   is
      package Ctnr renames Container;
   begin
      return Ctnr.System.Normalized_Pressure (Ctnr.This_Subsystem.The_Primary_System);
   exception
      when others =>
         Log.Report("Jpats_Hydraulics.Primary_System_Pressure_Function()");
         raise;
   end Primary_System_Pressure_Function;

   function Emergency_System_Pressure_Function
     return Jpats_Hydraulics_Types.Normalized_Pressure_Type
   is
      package Ctnr renames Container;
   begin
      return Ctnr.System.Normalized_Pressure (Ctnr.This_Subsystem.The_Emergency_System);
   exception
      when others =>
         Log.Report("Jpats_Hydraulics.Emergency_System_Pressure_Function()");
         raise;
   end Emergency_System_Pressure_Function;

   function HYDR_FL_LO_Annunciator_Request
     return Boolean
   is
      package Ctnr   renames Container;
      package Ele    renames Jpats_Electrical;
      package Ele_T  renames Jpats_Electrical_Types;
      package Low_Sw renames Ctnr.Fluid_Low_Level_Switch;
      The_Res_Low_Sw : Low_Sw.Instance renames Ctnr.This_Subsystem.The_Reservoir_Fluid_Low_Level_Switch;
   begin
--      return Ele.Is_Powered(Ele_T.Hyd_Sys_Cb) and Low_Sw.Is_Closed (The_Res_Low_Sw);
      return  Low_Sw.Is_Closed (The_Res_Low_Sw);
   exception
      when others =>
         Log.Report("Jpats_Hydraulics.HYDR_FL_LO_Annunciator_Request()");
         raise;
   end HYDR_FL_LO_Annunciator_Request;

   function HYDR_PX_LO_Annunciator_Request -- EDM
     return Boolean
   is
   begin
      return False;
   exception
      when others =>
         Log.Report("Jpats_Hydraulics.HYDR_PX_LO_Annunciator_Request()");
         raise;
   end HYDR_PX_LO_Annunciator_Request;

   function EMERG_HYDR_PX_LO_Annunciator_Request -- EDM??
     return Boolean
   is
      package Ctnr  renames Container;
   begin
      return Ctnr.Accumulator.Pressure(Ctnr.This_Subsystem.The_Accumulator) < 2400.0;
   exception
      when others =>
         Log.Report("Jpats_Hydraulics.EMERG_HYDR_PX_LO_Annunciator_Request()");
         raise;
   end EMERG_HYDR_PX_LO_Annunciator_Request;

   function Primary_Hyd_Px
     return Force_Types.Psi
   is
      package Ctnr  renames Container;
   begin
      return Ctnr.System.Pressure (Ctnr.This_Subsystem.The_Primary_System);
   exception
      when others =>
         Log.Report("Jpats_Hydraulics.Primary_Hyd_Px()");
         raise;
   end Primary_Hyd_Px;

   procedure Reset_Emerg_Hyd_Px
   is
      package Ctnr  renames Container;
   begin
      Ctnr.This_Host_Interface.Emerg_Px_Reset_Command := True;
   exception
      when others =>
         Log.Report("Jpats_Hydraulics.Reset_Emerg_Hyd_Px");
         raise;
   end Reset_Emerg_Hyd_Px;





end Jpats_Hydraulics;
