-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Hydraulics.Container;
with Length_Types;

with Electrical_Units_Types;

with Jpats_Ios_Interface;
with Log;

package body Jpats_Hydraulics.Ios_Interface is

   package Ctnr renames Container;
   Ios : Ctnr.Ios_Interface_Instance renames Ctnr.This_Ios_Interface;
   Io : Ctnr.Io_Interface_Instance renames Ctnr.This_Io_Interface;
   package JII renames Jpats_Ios_Interface;

   procedure Hyd_Pressure_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Hyd_Pressure := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Hydraulics.Ios_Interface.Hyd_Pressure_Command()");
         raise;
   end Hyd_Pressure_Command;

   procedure Low_Emerg_Hyd_Pressure_Malf_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Low_Emerg_Hyd_Pressure_Malf := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Hydraulics.Ios_Interface.Low_Emerg_Hyd_Pressure_Malf_Command()");
         raise;
   end Low_Emerg_Hyd_Pressure_Malf_Command;

   procedure Low_Hyd_Quantity_Malf_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Low_Hyd_Quantity_Malf := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Hydraulics.Ios_Interface.Low_Hyd_Quantity_Malf_Command()");
         raise;
   end Low_Hyd_Quantity_Malf_Command;

   procedure Hyd_Pressure_High_Malf_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Hyd_Pressure_High_Malf := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Hydraulics.Ios_Interface.Hyd_Pressure_High_Malf_Command()");
         raise;
   end Hyd_Pressure_High_Malf_Command;

   procedure Emerg_Hyd_Px_Reset_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Emerg_Hyd_Px_Reset := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Hydraulics.Ios_Interface.Emerg_Hyd_Px_Reset_Command()");
         raise;
   end Emerg_Hyd_Px_Reset_Command;

   procedure Hyd_Pump_Fail_Malf_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Hyd_Pump_Fail_Malf := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Hydraulics.Ios_Interface.Hyd_Pump_Fail_Malf_Command()");
         raise;
   end Hyd_Pump_Fail_Malf_Command;

   procedure Register_Ios_Variables
   is
   begin

      JPATS_IOS_Interface.Register
        (Name        => "Low_Hyd_Quantity_Malf",
         Variable    => Ios.Low_Hyd_Quantity_Malf'Address,
         Set_Routine => Low_Hyd_Quantity_Malf_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Hyd_Pressure_High_Malf",
         Variable    => Ios.Hyd_Pressure_High_Malf'Address,
         Set_Routine => Hyd_Pressure_High_Malf_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Low_Emerg_Hyd_Pressure_Malf",
         Variable    => Ios.Low_Emerg_Hyd_Pressure_Malf'Address,
         Set_Routine => Low_Emerg_Hyd_Pressure_Malf_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Primary_Hyd_Px",
         Variable    => Ios.Primary_Hyd_Px'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Hyd_Pressure",
         Variable    => Ios.Hyd_Pressure'Address,
         Set_Routine => Hyd_Pressure_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Emerg_Hyd_Px_Reset",
         Variable    => Ios.Emerg_Hyd_Px_Reset'Address,
         Set_Routine => Emerg_Hyd_Px_Reset_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Dummy",
         Variable    => Ios.Dummy'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Hyd_Pump_Fail_Malf",
         Variable    => Ios.Hyd_Pump_Fail_Malf'Address,
         Set_Routine => Hyd_Pump_Fail_Malf_Command'Access
         );

   exception
      when others =>
         Log.Report("Jpats_Hydraulics.Ios_Interface.Register_Ios_Variables()");
         raise;
   end Register_Ios_Variables;


end Jpats_Hydraulics.Ios_Interface;
