-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-------------------------------------------------------------------------------
--  HYDRAULIC SYSTEM
--  The hydraulic system (Figure 1-20) is a closed loop, 3000
--  psi system with a total system capacity of approximately
--  1.25 gallons. During normal operation, the hydraulic system
--  operates the landing gear, main gear doors, flaps, speed
--  brake, and nose wheel steering. Hydraulic system pressure
--  indication is provided on the engine/systems/NACWS display
--  in each cockpit. Caution annunciators are provided on
--  the annunciator panel in each cockpit to indicate low
--  hydraulic fluid level and low hydraulic pressure. During
--  emergency operation, the hydraulic system will allow one
--  extension of the landing gear, landing gear doors, and flaps.
--  Hydraulic system components include an engine driven
--  hydraulic pump, 0.6 gallon power package reservoir, selector
--  manifold, emergency accumulator, emergency selector
--  manifold, emergency firewall shutoff valve, fluid sampling
--  valve, nose and main landing gear actuators, main gear door
--  actuator, flap actuator, speed brake actuator, and nose wheel
--  steering actuator.
--  The hydraulic system service bay, located in the lower aft
--  fuselage behind the right wing trailing edge, contains:
--    * A manual pressure release handle to release the pressurized
--  fluid from the emergency accumulator back to
--  the reservoir.
--    * A fluid quantity indicator, which shows the level of
--  hydraulic fluid in the power package reservoir.
--    * A ground hydraulic power, sampling, and servicing
--  connection.

--  NORMAL OPERATION
--  During normal operation, the engine driven hydraulic pump
--  pressurizes the normal hydraulic system to 3000 psi and the
--  emergency accumulator to 3000 psi nominal through a one
--  way check valve. Once pressure in the system exceeds 1800
--  psi, the system can be used to power nose wheel steering,
--  landing gear, flaps, and speed brake operations. The power
--  package includes a 3200 to 3250 psi pressure relief valve to
--  prevent damage from high system pressures.
--  If hydraulic pressure in the emergency accumulator drops
--  below 2400 ( 150) psi, an amber EHYD PX LO annunciator
--  will illuminate. If main hydraulic pressure drops below
--  1790 psi indicated, the hydraulic pressure display on the
--  engine/systems/NACWS display will change color to indicate
--  a caution (amber). Low hydraulic fluid levels are
--  detected by a proximity switch on the reservoir, which is
--  activated when a rod connected to the reservoir diaphragm
--  moves as volume decreases. If the hydraulic fluid level in
--  the reservoir drops below approximately 1 quart, an amber
--  HYDR FL LO annunciator will illuminate and the hydraulic
--  pressure display will change color to amber.
--  Hydraulic fluid level can be checked in the hydraulic system
--  service bay. A green indicating rod will be visible in the reservoir
--  level indicator window. If the indicating rod shows
--  FULL in the window, with the emergency accumulator
--  charged or discharged, the system is fully serviced. Pull the
--  manual pressure release handle to release system pressure
--  from the emergency accumulator. As the accumulator discharges,
--  the fluid level in the reservoir should increase.
--  However, the accumulator is designed to allow pressure to
--  bleed out over time and no change in indication is possible
--  when the release handle is pulled if the accumulator is not
--  charged (e.g. first flight of day).
--  Power for the hydraulic system is provided through a circuit
--  breaker placarded HYD SYS, located on the battery bus circuit
--  breaker panel in the front cockpit.
--  During engine start, the hydraulic pump pressurizes the
--  emergency accumulator through a hydraulic fuse that only
--  allows approximately 45 cubic inches of hydraulic fluid to
--  pass until the pressure on the main side and the emergency
--  side are approximately equal. In the event of a hydraulic
--  system leak between the main system and the emergency
--  system, the fuse will prevent the loss of all hydraulic fluid
--  from the main system to the emergency system, allowing
--  gear and flaps to be lowered using the main system. There is
--  also a one way check valve which prevents backflow from
--  the emergency system to the main system, allowing the gear
--  and flaps to be lowered using the emergency system.

--  EMERGENCY OPERATION
--  When the emergency accumulator is pressurized during
--  engine start, the fluid pushes back a helium precharge in the
--  accumulator. The helium precharge provides pressure to
--  drive a metal bellows, which provides pressure for emergency
--  landing gear and flap operation. The emergency system
--  includes a 3500 psi pressure relief valve to prevent
--  damage from high system pressures. Should the primary
--  hydraulic system fail, the emergency accumulator has sufficient
--  fluid routed through independent emergency lines to
--  ensure the landing gear and flaps can be extended.
--  To use the emergency hydraulic system, pull the emergency
--  landing gear extension handle, placarded EMER LDG GR,
--  on the lower right side of the instrument panel in the front
--  cockpit only. Regardless of landing gear control position,
--  the landing gear will extend and lock down. Once the gear
--  are down and locked, the flaps may be extended to landing
--  (LDG) only by selecting takeoff (TO) or LDG.
--  The emergency accumulator is a maintenance free design
--  which does not have a pressure gage or any other indication
--  of system health.
--  Data source:  Raytheon Phase X Data Package
--  Data source:  Flight Manual USAF/USN Series T-6A Aircraft, Air Force TO 1T-6A-1
--                Navy (NAVAIR) A1-T6AAA-NFM-100, CVV Draft December 1998.
--
-------------------------------------------------------------------------------

private package Jpats_Hydraulics.Controller is

   procedure Initialize;
   procedure Update
     (Iconst : in Float);

end Jpats_Hydraulics.Controller;
