-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Accumulator_G;
with Low_Level_Switch_G;
with Hydraulic_Pump_G;
with Reservoir_G;
with Hydraulic_System_G;
with Mechanical_Two_Position_Valve_G;
with Electrical_Units_Types;
with Jpats_Hydraulics_Types;

with Length_Types;
with Force_Types;

private package Jpats_Hydraulics.Container is

-- primary system and emergency systems
   package System is new Hydraulic_System_G
     (Quantity_Type            => Length_Types.Gallons,
      Pressure_Type            => Force_Types.Psi,
      Normalized_Quantity_Type => Jpats_Hydraulics_Types.Normalized_Quantity_Type,
      Normalized_Pressure_Type => Jpats_Hydraulics_Types.Normalized_Pressure_Type,
      Package_Name             => "Jpats_Hydraulics.Container.System");

-- accumulator
   package Accumulator is new Accumulator_G
     (Quantity_Type => Length_Types.Gallons,
      Pressure_Type => Force_Types.Psi,
      Package_Name  => "Jpats_Hydraulics.Container.Hydraulic_Accumulator");

-- low level switch
   package Fluid_Low_Level_Switch is new Low_Level_Switch_G
     (Quantity_Type       => Length_Types.Gallons,
      Low_Level_Threshold => 0.25,
      Current_Type        => Electrical_Units_Types.Amps,
      Package_Name        => "Jpats_Hydraulics.Container.Hydraulic_Fluid_Low_Level_Switch");

   package Pressure_Low_Level_Switch is new Low_Level_Switch_G
     (Quantity_Type       => Force_Types.Psi,
      Low_Level_Threshold => 2400.0,
      Current_Type        => Electrical_Units_Types.Amps,
      Package_Name        => "Jpats_Hydraulics.Container.Hydraulic_Pressure_Low_Level_Switch");

-- pump
   package Pump is new Hydraulic_Pump_G
     (Quantity_Type   => Length_Types.Gallons,
      Pressure_Type   => Force_Types.Psi,
      Engine_Rpm_Type => Float,
      Package_Name    => "Jpats_Hydraulics.Container.Hydraulic_Pump");

-- reservoir
   package Reservoir is new Reservoir_G
     (Quantity_Type => Length_Types.Gallons,
      Package_Name  => "Jpats_Hydraulics.Container.Hydraulic_Reservoir");


      -- shutoff valve
   package Shutoff_Valve is new Mechanical_Two_Position_Valve_G
      (Package_Name  => "Jpats_Hydraulics.Container.Hydraulic_Shutoff_Valve");

   type Instance is
      record
         The_Primary_System                     : System.Instance;
         The_Emergency_System                   : System.Instance;
         The_Accumulator                        : Accumulator.Instance;
         The_Reservoir_Fluid_Low_Level_Switch   : Fluid_Low_Level_Switch.Instance;
         The_Low_Pressure_Switch                : Pressure_Low_Level_Switch.Instance;
         The_Pump                               : Pump.Instance;
         The_Reservoir                          : Reservoir.Instance;
         The_Shutoff_Valve                      : Shutoff_Valve.Instance;

         HC_High_Px_Malf_Px : Float := 0.0;
         HC_Low_Qty_Timer   : Float := 0.0;
         HC_V_Hyd_Accum     : Length_Types.Gallons := 0.21;

      end record;
   This_Subsystem : Instance;

   type Io_Interface_Instance is
      record
         null;
      end record;

   Io_Size : constant Integer := 4;

   -- rep clause goes here if io

   This_Io_Interface : Io_Interface_Instance;

   type Ios_Interface_Instance is
      record
         Hyd_Pressure       : Boolean := False;
         Emerg_Hyd_Px_Reset : Boolean := False;
         Dummy              : Boolean := False;
         Primary_Hyd_Px     : Float   := 0.0;

         Low_Emerg_Hyd_Pressure_Malf : Boolean := False;
         Low_Hyd_Quantity_Malf       : Boolean := False;
         Hyd_Pressure_High_Malf      : Boolean := False;
         Hyd_Pump_Fail_Malf          : Boolean := False;
      end record;
   This_Ios_Interface : Ios_Interface_Instance;

   type Host_Interface_Instance is
      record
         Emerg_Px_Reset_Command : Boolean := False;
      end record;
   This_Host_Interface : Host_Interface_Instance;

end Jpats_Hydraulics.Container;
