-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

generic
   type Quantity_Type is digits <>;
   type Pressure_Type is digits <>;
   type Normalized_Quantity_Type is digits <>;
   type Normalized_Pressure_Type is digits <>;
   Package_Name : in String;
package Hydraulic_System_G is
   type Instance is private;
   procedure Update
     (An_Instance         : in out Instance;
      Quantity            : in     Quantity_Type;
      Pressure            : in     Pressure_Type;
      Normalized_Quantity : in     Normalized_Quantity_Type;
      Normalized_Pressure : in     Normalized_Pressure_Type);

   procedure Initialize
     (An_Instance : in out Instance);

   function Quantity
     (An_Instance : in Instance)
      return Quantity_Type;
   function Pressure
     (An_Instance : in Instance)
      return Pressure_Type;
   function Normalized_Quantity
     (An_Instance : in Instance)
      return Normalized_Quantity_Type;
   function Normalized_Pressure
     (An_Instance : in Instance)
      return Normalized_Pressure_Type;
private
   type Instance is
      record
         Quantity            : Quantity_Type;
         Pressure            : Pressure_Type;
         Normalized_Quantity : Normalized_Quantity_Type;
         Normalized_Pressure : Normalized_Pressure_Type;
      end record;
end Hydraulic_System_G;
