-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Log;

package body Hydraulic_System_G is

   procedure Update
     (An_Instance         : in out Instance;
      Quantity            : in     Quantity_Type;
      Pressure            : in     Pressure_Type;
      Normalized_Quantity : in     Normalized_Quantity_Type;
      Normalized_Pressure : in     Normalized_Pressure_Type) is
   begin
      An_Instance.Quantity            := Quantity;
      An_Instance.Pressure            := Pressure;
      An_Instance.Normalized_Quantity := Normalized_Quantity;
      An_Instance.Normalized_Pressure := Normalized_Pressure;
   exception
      when others =>
         Log.Report(Package_Name & ".Update()");
         raise;
   end Update;

   procedure Initialize
     (An_Instance : in out Instance)
   is
   begin
      An_Instance.Quantity            := 0.0;
      An_Instance.Pressure            := 0.0;
      An_Instance.Normalized_Quantity := 0.0;
      An_Instance.Normalized_Pressure := 0.0;
   exception
      when others =>
         Log.Report(Package_Name & ".Initialize()");
         raise;
   end Initialize;

   function Quantity
     (An_Instance : in Instance)
      return Quantity_Type is
   begin
      return An_Instance.Quantity;
   exception
      when others =>
         Log.Report(Package_Name & ".Quantity()");
         raise;
   end Quantity;

   function Pressure
     (An_Instance : in Instance)
      return Pressure_Type is
   begin
      return An_Instance.Pressure;
   exception
      when others =>
         Log.Report(Package_Name & ".Pressure()");
         raise;
   end Pressure;

   function Normalized_Quantity
     (An_Instance : in Instance)
      return Normalized_Quantity_Type is
   begin
      return An_Instance.Normalized_Quantity;
   exception
      when others =>
         Log.Report(Package_Name & ".Normalized_Quantity()");
         raise;
   end Normalized_Quantity;

   function Normalized_Pressure
     (An_Instance : in Instance)
      return Normalized_Pressure_Type is
   begin
      return An_Instance.Normalized_Pressure;
   exception
      when others =>
         Log.Report(Package_Name & ".Normalized_Pressure()");
         raise;
   end Normalized_Pressure;

end Hydraulic_System_G;
