-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

generic
   type Quantity_Type is digits <>;
   type Pressure_Type is digits <>;
   type Engine_Rpm_Type is digits <>;
   Package_Name : in String;
package Hydraulic_Pump_G is
   type Instance is private;
   procedure Update
     (An_Instance : in out Instance;
      Load        : in     Quantity_Type;
      Engine_Rpm  : in     Engine_Rpm_Type);

   procedure Initialize
     (An_Instance : in out Instance);

   function Capability
     (An_Instance : in Instance)
      return Quantity_Type;
   function Percent_Of_Capabilty
     (An_Instance : in Instance)
      return Float;
   function Pressure
     (An_Instance : in Instance)
     return Pressure_Type;
   function Shaft_Horsepower
     (An_Instance : in Instance)
     return Float;

private
   type Instance is
      record
         Capability           : Quantity_Type;
         Percent_Of_Capabilty : Float;
         Pressure             : Pressure_Type;
         Shaft_Horsepower     : Float;
      end record;
end Hydraulic_Pump_G;
