-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Log;

package body Hydraulic_Pump_G is

   procedure Update
     (An_Instance : in out Instance;
      Load        : in     Quantity_Type;
      Engine_Rpm  : in     Engine_Rpm_Type) is
   begin
      An_Instance.Shaft_Horsepower := 1.8 * Float(Load);
   exception
      when others =>
         Log.Report(Package_Name & ".Update()");
         raise;
   end Update;

   procedure Initialize
     (An_Instance :in out Instance)
   is
   begin
      An_Instance.Capability           := 0.0; --Quantity_Type;
      An_Instance.Percent_Of_Capabilty := 0.0; --Float;
      An_Instance.Pressure             := 0.0; --Pressure_Type;
      An_Instance.Shaft_Horsepower     := 0.0; --Float;
   exception
      when others =>
         Log.Report(Package_Name & ".Initialize()");
         raise;
   end Initialize;

   function Capability
     (An_Instance : in Instance)
      return Quantity_Type is
   begin
      return An_Instance.Capability;
   exception
      when others =>
         Log.Report(Package_Name & ".Capability()");
         raise;
   end Capability;

   function Percent_Of_Capabilty
     (An_Instance : in Instance)
      return Float is
   begin
      return An_Instance.Percent_Of_Capabilty;
   exception
      when others =>
         Log.Report(Package_Name & ".Percent_Of_Capabilty()");
         raise;
   end Percent_Of_Capabilty;

   function Pressure
     (An_Instance : in Instance)
      return Pressure_Type is
   begin
      return An_Instance.Pressure;
   exception
      when others =>
         Log.Report(Package_Name & ".Pressure()");
         raise;
   end Pressure;

   function Shaft_Horsepower
     (An_Instance : in Instance)
     return Float
   is
   begin
      return An_Instance.Shaft_Horsepower;
   exception
      when others =>
         Log.Report(Package_Name & ".Shaft_Horsepower()");
         raise;
   end Shaft_Horsepower;

end Hydraulic_Pump_G;
