-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Log;

package body Accumulator_G is

   procedure Initialize
     (An_Instance : in out Instance)
   is
   begin
      An_Instance.Quantity := 0.0;
      An_Instance.Pressure := 0.0;
   exception
      when others =>
         Log.Report(Package_Name & ".Initialize()");
         raise;
   end Initialize;

   procedure Set_Quantity
     (An_Instance : in out Instance;
      Value       : in     Quantity_Type)
   is
   begin
      An_Instance.Quantity := Value;
   exception
      when others =>
         Log.Report(Package_Name & ".Set_Quantity()");
         raise;
   end Set_Quantity;

   procedure Set_Pressure
     (An_Instance : in out Instance;
      Value       : in     Pressure_Type)
   is
   begin
      An_Instance.Pressure := Value;
   exception
      when others =>
         Log.Report(Package_Name & ".Set_Pressure()");
         raise;
   end Set_Pressure;


   function Quantity
     (An_Instance : in Instance)
     return Quantity_Type
   is
   begin
      return An_Instance.Quantity;
   exception
      when others =>
         Log.Report(Package_Name & ".Quantity()");
         raise;
   end Quantity;

   function Pressure
     (An_Instance : in Instance)
     return Pressure_Type
   is
   begin
      return An_Instance.Pressure;
   exception
      when others =>
         Log.Report(Package_Name & ".Pressure()");
         raise;
   end Pressure;

   procedure Update
     (An_Instance : in out Instance;
      Px          : in     Pressure_Type;
      Qty         : in     Quantity_Type)
   is
   begin
      Set_Pressure (An_Instance,Px);
      Set_Quantity (An_Instance,Qty);
   exception
      when others =>
         Log.Report(Package_Name & ".Update()");
         raise;
   end Update;


end Accumulator_G;
