-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
-------------------------------------------------------------------------------
-- This is a solenoid valve which opens when powered.
-------------------------------------------------------------------------------

generic

   type Ampere_Type is digits <>;
   Valve_Load : in Ampere_Type;
   Open_Restriction_Factor   : in Float;
   Closed_Restriction_Factor : in Float;
   Package_Name : in String;

package Transfer_Valve_G is

   type Instance is Private;

   procedure Update
     (An_Instance : in out Instance;
      Power_In    : in     Boolean);

   function Load
     (An_Instance : in Instance)
      return Ampere_Type;

   function Is_Open
     (An_Instance : in Instance)
      return Boolean;

   function Is_Closed
     (An_Instance : in Instance)
      return Boolean;

private

   type State_Type is (Open, Closed);

   type Instance is
      record
        State : State_Type;
        Load  : Ampere_Type;
        Restriction_Factor : Float;
      end record;

end Transfer_Valve_G;
