-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Howard Landmann
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Interpolation_Table.Singly_Indexed;

with Coordinate_Types;
with Mass_Types;
with Length_Types;

package Tank_Mass_Property is

   type Instance is private;
   package It renames Interpolation_Table;
   package Ct renames Coordinate_Types;

   procedure Set_Wing_CG
     (Sign          :in     Float;
      Gal           :in     Length_Types.Gallons;
      AFUELBL       :in out IT.Singly_Indexed.Instance;
      FUELFS        :in out IT.Singly_Indexed.Instance;
      An_Instance   :in out Instance);

   procedure Assign_CG
     (tank_cg        :in     CT.Reference_System;
      An_Instance    :in out Instance);

   function Get_CG(An_Instance :in Instance)
                          return CT.Reference_System ;

   procedure Set_Wing_Inertia
     (Gal           :in     Length_Types.Gallons;
      Fuel_Wt       :in     Mass_Types.Lbm;
      FUELKXX       :in out IT.Singly_Indexed.Instance;
      FUELKYY       :in out IT.Singly_Indexed.Instance;
      FUELKZZ       :in out IT.Singly_Indexed.Instance;
      FUELIXZ       :in out IT.Singly_Indexed.Instance;
      An_Instance   :in out Instance);

   procedure Set_Collector_Inertia (Fuel_Wt     :in     Mass_Types.Lbm;
                                    An_Instance :in out Instance);

   procedure Set_MOI
     (Ac_Cg         :in     CT.Reference_System;
      Fuel_Wt       :in     Mass_Types.Lbm;
      An_Instance   :in out Instance);

   procedure Assign_MOI(Inertia     : in     CT.Inertia_Axis;
                        An_Instance : in out Instance);

   function Get_MOI(An_Instance :in Instance)
                              return CT.Inertia_Axis;

private

   type Instance is record
      The_Inertia             : CT.Inertia_Axis := (1.0,1.0,1.0,1.0);
      The_Moment_of_Inertia   : CT.Inertia_Axis := (1.0,1.0,1.0,1.0);
      The_Fuel_cg             : CT.Reference_System := (14.0,0.0,7.0);
   end record;

end Tank_Mass_Property;



