-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Howard Landmann
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------

with Log;

package body Tank_Mass_Property is
   procedure Set_Wing_CG
     (Sign          :in     Float;
      Gal           :in     Length_Types.Gallons;
      AFUELBL       :in out IT.Singly_Indexed.Instance;
      FUELFS        :in out IT.Singly_Indexed.Instance;
      An_Instance   :in out Instance) is
   begin
       An_Instance.The_Fuel_Cg.fs :=
           IT.Singly_Indexed.Interpolate(Gal,FUELFS'access)/12.0;
       An_Instance.The_Fuel_Cg.Bl  := Sign *
           IT.Singly_Indexed.Interpolate(Gal,AFUELBL'access)/12.0;
       An_Instance.The_Fuel_Cg.Wl := - 0.047 * (An_Instance.The_Fuel_Cg.Bl)**2
           + 0.825 * abs(An_Instance.The_Fuel_Cg.Bl) + 3.008;
   exception
      when others =>
         Log.Report("Tank_Mass_Property.Set_Wing_CG()");
         raise;
   end Set_Wing_CG;

   procedure Assign_CG
     (tank_cg        :in     Coordinate_Types.Reference_System;
      An_Instance    :in out Instance) is
   begin
      An_Instance.The_Fuel_Cg := tank_cg;
   exception
      when others =>
         Log.Report("Tank_Mass_Property.Assign_CG()");
         raise;
   end Assign_CG;

   function Get_CG(An_Instance :in Instance)
            return Coordinate_Types.Reference_System is
   begin
      return An_Instance.The_Fuel_Cg;
   exception
      when others =>
         Log.Report("Tank_Mass_Property.Get_CG()");
         raise;
   end Get_CG;

   procedure Set_Wing_Inertia
     (Gal           :in     Length_Types.Gallons;
      Fuel_Wt       :in     Mass_Types.Lbm;
      FUELKXX       :in out IT.Singly_Indexed.Instance;
      FUELKYY       :in out IT.Singly_Indexed.Instance;
      FUELKZZ       :in out IT.Singly_Indexed.Instance;
      FUELIXZ       :in out IT.Singly_Indexed.Instance;
      An_Instance   :in out Instance) is
      K_gyra : Length_Types.Feet :=  0.0;
   begin
      K_gyra  := IT.Singly_Indexed.Interpolate(Gal,FUELKXX'access)/12.0;
      An_Instance.The_Inertia.xx := (Fuel_Wt * K_gyra ** 2) / 32.174;

      K_gyra  := IT.Singly_Indexed.Interpolate(Gal,FUELKYY'access)/12.0;
      An_Instance.The_Inertia.yy := (Fuel_Wt * K_gyra ** 2) / 32.174;

      K_gyra  := IT.Singly_Indexed.Interpolate(Gal,FUELKZZ'access)/12.0;
      An_Instance.The_Inertia.zz := (Fuel_Wt * K_gyra ** 2) / 32.174;

      An_Instance.The_Inertia.xz := IT.Singly_Indexed.Interpolate
                    (An_Instance.The_Inertia.xx,FUELIXZ'access);
   exception
      when others =>
         Log.Report("Tank_Mass_Property.Set_Wing_Inertia()");
         raise;
   end Set_Wing_Inertia;

   procedure Set_Collector_Inertia (Fuel_Wt     :in     Mass_Types.Lbm;
                                    An_Instance :in out Instance) is
   begin
      An_Instance.The_Inertia.xx := 0.003128 * Fuel_Wt;
      An_Instance.The_Inertia.yy := 0.009621 * Fuel_Wt;
      An_Instance.The_Inertia.zz := 0.009440 * Fuel_Wt;
      An_Instance.The_Inertia.xz := 0.000100 * Fuel_Wt;
   exception
      when others =>
         Log.Report("Tank_Mass_Property.Set_Collector_Inertia()");
         raise;
   end Set_Collector_Inertia;

   procedure Set_MOI
     (Ac_CG         :in     Coordinate_Types.Reference_System;
      Fuel_Wt       :in     Mass_Types.Lbm;
      An_Instance   :in out Instance) is
   begin
      An_Instance.The_Moment_of_Inertia.xx :=   An_Instance.The_Inertia.xx + Fuel_Wt/32.174 *
                       ((AC_CG.Bl - An_Instance.The_Fuel_Cg.Bl) **2
                                    + (AC_CG.Wl - An_Instance.The_Fuel_Cg.Wl)**2);

      An_Instance.The_Moment_of_Inertia.yy :=   An_Instance.The_Inertia.yy + Fuel_Wt/32.174 *
                       ((AC_CG.fs - An_Instance.The_Fuel_Cg.fs)**2
                             + (AC_CG.Wl - An_Instance.The_Fuel_Cg.Wl)**2);

      An_Instance.The_Moment_of_Inertia.zz :=   An_Instance.The_Inertia.zz + Fuel_Wt/32.174 *
                       ((AC_CG.Bl - An_Instance.The_Fuel_Cg.Bl)**2
                             + (AC_CG.fs - An_Instance.The_Fuel_Cg.fs)**2);

      An_Instance.The_Moment_of_Inertia.xz :=   An_Instance.The_Inertia.xz + Fuel_Wt/32.174 *
                            ((AC_CG.fs - An_Instance.The_Fuel_Cg.fs)
                                    * (AC_CG.Wl  - An_Instance.The_Fuel_Cg.Wl));
   exception
      when others =>
         Log.Report("Tank_Mass_Property.Set_MOI()");
         raise;
   end Set_MOI;

   procedure Assign_MOI (Inertia      : in     Coordinate_Types.Inertia_Axis;
                         An_Instance  : in out Instance) is
   begin
      An_Instance.The_Moment_of_Inertia := Inertia;
   exception
      when others =>
         Log.Report("Tank_Mass_Property.Assign_MOI()");
         raise;
   end Assign_MOI;

   function Get_MOI(An_Instance :in Instance)
          return Coordinate_Types.Inertia_Axis is
   begin
      return An_Instance.The_Moment_of_Inertia;
   exception
      when others =>
         Log.Report("Tank_Mass_Property.Get_MOI()");
         raise;
   end Get_MOI;
end Tank_Mass_Property;












