-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm, Yogesh Tupe
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Mass_Types;
with Length_Types;

package Tank is

   type Instance is tagged private;

   procedure Initialize
     (An_Instance : in out Instance'Class;
      Lbm_Init    : in     Mass_Types.Lbm);

   procedure Update
     (An_Instance : in out Instance'Class;
      Qty         : in     Mass_Types.Lbm);

   function Quantity
     (An_Instance : in Instance'Class)
      return Mass_Types.Lbm;

   function Volume
     (An_Instance : in Instance'Class)
     return Length_Types.Gallons;

   function Is_Empty
     (An_Instance : in Instance'Class)
      return Boolean;

   function Is_Not_Empty
     (An_Instance : in Instance'Class)
      return Boolean;

private

   type Instance is tagged
      record
         Quantity : Mass_Types.Lbm;
         Volume   : Length_Types.Gallons;
      end record;

end Tank;
