-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm, Yogesh Tupe
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Log;

package body Tank is

   procedure Initialize
     (An_Instance : in out Instance'Class;
      Lbm_Init    : in     Mass_Types.Lbm)
   is
   begin
      An_Instance.Quantity := Lbm_Init;
      An_Instance.Volume   := Lbm_Init/6.7;
   exception
      when others =>
         Log.Report("Tank.Initialize()");
         raise;
   end Initialize;

   procedure Update
     (An_Instance : in out Instance'Class;
      Qty         : in     Mass_Types.Lbm)
   is
   begin
      An_Instance.Quantity := Qty;
      An_Instance.Volume :=  Qty / 6.7;
   exception
      when others =>
         Log.Report("Tank.Update()");
         raise;
   end Update;

   function Quantity
     (An_Instance : in Instance'Class)
     return Mass_Types.Lbm
   is
   begin
      return An_Instance.Quantity;
   exception
      when others =>
         Log.Report("Tank.Quantity()");
         raise;
   end Quantity;

   function Volume
     (An_Instance : in Instance'Class)
     return Length_Types.Gallons
   is
   begin
      return An_Instance.Volume;
   exception
      when others =>
         Log.Report("Tank.Volume()");
         raise;
   end Volume;

   function Is_Empty
     (An_Instance : in Instance'Class)
     return Boolean
   is
   begin
      return An_Instance.Quantity <= 0.0;
   exception
      when others =>
         Log.Report("Tank.Is_Empty()");
         raise;
   end Is_Empty;

   function Is_Not_Empty
     (An_Instance : in Instance'Class)
     return Boolean
   is
   begin
      return not Is_Empty (An_Instance);
   exception
      when others =>
         Log.Report("Tank.Is_Not_Empty()");
         raise;
   end Is_Not_Empty;

end Tank;
